/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.config;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mailaccount.MailAccount;
import java.util.Map;

public class MailAccountProperties
implements IMailProperties {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAccountProperties.class));
    protected final Map<String, String> properties;

    public MailAccountProperties(MailAccount mailAccount) {
        if (null == mailAccount) {
            throw new IllegalArgumentException("mail account is null.");
        }
        this.properties = mailAccount.getProperties();
    }

    @Override
    public int getAttachDisplaySize() {
        String attachDisplaySizeStr = this.properties.get("com.openexchange.mail.attachmentDisplaySizeLimit");
        if (null == attachDisplaySizeStr) {
            return MailProperties.getInstance().getAttachDisplaySize();
        }
        try {
            return Integer.parseInt(attachDisplaySizeStr.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Attachment Display Size: Non parseable value.", (Throwable)e);
            return MailProperties.getInstance().getMailFetchLimit();
        }
    }

    @Override
    public char getDefaultSeparator() {
        String defaultSepStr = this.properties.get("com.openexchange.mail.defaultSeparator");
        if (null == defaultSepStr) {
            return MailProperties.getInstance().getDefaultSeparator();
        }
        char defaultSep = defaultSepStr.trim().charAt(0);
        if (defaultSep <= ' ') {
            char fallback = MailProperties.getInstance().getDefaultSeparator();
            LOG.error((Object)new StringBuilder(64).append("\tDefault Separator: Invalid separator (decimal ascii value=").append((int)defaultSep).append("). Setting to fallback: ").append(fallback).append('\n'));
            return fallback;
        }
        return defaultSep;
    }

    @Override
    public int getMailAccessCacheIdleSeconds() {
        String tmp = this.properties.get("com.openexchange.mail.mailAccessCacheIdleSeconds");
        if (null == tmp) {
            return MailProperties.getInstance().getMailAccessCacheIdleSeconds();
        }
        try {
            return Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Mail Access Cache idle seconds: Non parseable value.", (Throwable)e);
            return MailProperties.getInstance().getMailAccessCacheIdleSeconds();
        }
    }

    @Override
    public int getMailAccessCacheShrinkerSeconds() {
        String tmp = this.properties.get("com.openexchange.mail.mailAccessCacheShrinkerSeconds");
        if (null == tmp) {
            return MailProperties.getInstance().getMailAccessCacheShrinkerSeconds();
        }
        try {
            return Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Mail Access Cache shrinker-interval seconds: Non parseable value.", (Throwable)e);
            return MailProperties.getInstance().getMailAccessCacheShrinkerSeconds();
        }
    }

    @Override
    public int getMailFetchLimit() {
        String mailFetchLimitStr = this.properties.get("com.openexchange.mail.mailFetchLimit");
        if (null == mailFetchLimitStr) {
            return MailProperties.getInstance().getMailFetchLimit();
        }
        try {
            return Integer.parseInt(mailFetchLimitStr.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Mail Fetch Limit: Non parseable value.", (Throwable)e);
            return MailProperties.getInstance().getMailFetchLimit();
        }
    }

    @Override
    public int getWatcherFrequency() {
        String watcherFreqStr = this.properties.get("com.openexchange.mail.watcherFrequency");
        if (null == watcherFreqStr) {
            return MailProperties.getInstance().getWatcherFrequency();
        }
        try {
            return Integer.parseInt(watcherFreqStr.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Watcher frequency: Non parseable value.", (Throwable)e);
            return MailProperties.getInstance().getWatcherFrequency();
        }
    }

    @Override
    public int getWatcherTime() {
        String watcherTimeStr = this.properties.get("com.openexchange.mail.watcherTime");
        if (null == watcherTimeStr) {
            return MailProperties.getInstance().getWatcherTime();
        }
        try {
            return Integer.parseInt(watcherTimeStr.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Watcher time: Non parseable value.", (Throwable)e);
            return MailProperties.getInstance().getWatcherTime();
        }
    }

    @Override
    public boolean isAllowNestedDefaultFolderOnAltNamespace() {
        String allowNestedStr = this.properties.get("com.openexchange.mail.allowNestedDefaultFolderOnAltNamespace");
        if (null == allowNestedStr) {
            return MailProperties.getInstance().isAllowNestedDefaultFolderOnAltNamespace();
        }
        return Boolean.parseBoolean(allowNestedStr.trim());
    }

    @Override
    public boolean isIgnoreSubscription() {
        String ignoreSubsStr = this.properties.get("com.openexchange.mail.ignoreSubscription");
        if (null == ignoreSubsStr) {
            return MailProperties.getInstance().isIgnoreSubscription();
        }
        return Boolean.parseBoolean(ignoreSubsStr.trim());
    }

    @Override
    public boolean isSupportSubscription() {
        String supportSubsStr = this.properties.get("com.openexchange.mail.supportSubscription");
        if (null == supportSubsStr) {
            return MailProperties.getInstance().isSupportSubscription();
        }
        return Boolean.parseBoolean(supportSubsStr.trim());
    }

    @Override
    public boolean isUserFlagsEnabled() {
        String userFlagsStr = this.properties.get("com.openexchange.mail.userFlagsEnabled");
        if (null == userFlagsStr) {
            return MailProperties.getInstance().isUserFlagsEnabled();
        }
        return Boolean.parseBoolean(userFlagsStr.trim());
    }

    @Override
    public boolean isWatcherEnabled() {
        String watcherEnabledStr = this.properties.get("com.openexchange.mail.watcherEnabled");
        if (null == watcherEnabledStr) {
            return MailProperties.getInstance().isWatcherEnabled();
        }
        return Boolean.parseBoolean(watcherEnabledStr.trim());
    }

    @Override
    public boolean isWatcherShallClose() {
        String watcherShallCloseStr = this.properties.get("com.openexchange.mail.watcherShallClose");
        if (null == watcherShallCloseStr) {
            return MailProperties.getInstance().isWatcherShallClose();
        }
        return Boolean.parseBoolean(watcherShallCloseStr.trim());
    }

    @Override
    public void waitForLoading() throws InterruptedException {
        MailProperties.getInstance().waitForLoading();
    }
}

