/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.mail.cache.PooledMailAccess;
import com.openexchange.mail.cache.queue.MailAccessQueue;
import com.openexchange.mail.cache.queue.MailAccessQueueImpl;
import com.openexchange.mail.cache.queue.SingletonMailAccessQueue;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class EnqueueingMailAccessCache
implements IMailAccessCache {
    protected static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(EnqueueingMailAccessCache.class));
    protected static final boolean DEBUG = LOG.isDebugEnabled();
    private static final boolean DROP_TIMED_OUT_QUEUES = false;
    private static volatile EnqueueingMailAccessCache singleton;
    private final ConcurrentMap<Key, MailAccessQueue> map;
    private final int defaultIdleSeconds;
    private final ScheduledTimerTask timerTask;
    private final int queueCapacity;

    public static EnqueueingMailAccessCache newInstance(int queueCapacity) throws OXException {
        return new EnqueueingMailAccessCache(queueCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnqueueingMailAccessCache getInstance(int queueCapacity) throws OXException {
        EnqueueingMailAccessCache tmp = singleton;
        if (null != tmp) return tmp;
        Class<EnqueueingMailAccessCache> clazz = EnqueueingMailAccessCache.class;
        synchronized (EnqueueingMailAccessCache.class) {
            tmp = singleton;
            if (null != tmp) return tmp;
            singleton = tmp = new EnqueueingMailAccessCache(queueCapacity);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (null == singleton) return;
        Class<EnqueueingMailAccessCache> clazz = EnqueueingMailAccessCache.class;
        synchronized (EnqueueingMailAccessCache.class) {
            if (null == singleton) return;
            singleton.dispose();
            singleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private EnqueueingMailAccessCache(int queueCapacity) throws OXException {
        this.queueCapacity = queueCapacity;
        try {
            this.map = new NonBlockingHashMap();
            int configuredIdleSeconds = MailProperties.getInstance().getMailAccessCacheIdleSeconds();
            this.defaultIdleSeconds = configuredIdleSeconds <= 0 ? 7 : configuredIdleSeconds;
            TimerService service = ServerServiceRegistry.getInstance().getService(TimerService.class, true);
            int configuredShrinkerSeconds = MailProperties.getInstance().getMailAccessCacheShrinkerSeconds();
            int shrinkerMillis = (configuredShrinkerSeconds <= 0 ? 3 : configuredShrinkerSeconds) * 1000;
            this.timerTask = service.scheduleWithFixedDelay((Runnable)new PurgeExpiredRunnable(this.map), (long)shrinkerMillis, (long)shrinkerMillis);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> removeMailAccess(Session session, int accountId) {
        Key key = EnqueueingMailAccessCache.keyFor(accountId, session);
        MailAccessQueue accessQueue = (MailAccessQueue)this.map.get(key);
        if (null == accessQueue) {
            return null;
        }
        MailAccessQueue mailAccessQueue = accessQueue;
        synchronized (mailAccessQueue) {
            if (accessQueue.isDeprecated()) {
                return null;
            }
            PooledMailAccess pooledMailAccess = (PooledMailAccess)accessQueue.poll();
            if (null == pooledMailAccess) {
                return null;
            }
            MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = pooledMailAccess.getMailAccess();
            mailAccess.setCached(false);
            if (DEBUG) {
                LOG.debug((Object)("Remove&Get for " + key));
            }
            return mailAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putMailAccess(Session session, int accountId, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) {
        Key key;
        MailAccessQueue accessQueue;
        int idleSeconds = mailAccess.getCacheIdleSeconds();
        if (idleSeconds <= 0) {
            idleSeconds = this.defaultIdleSeconds;
        }
        if (null == (accessQueue = (MailAccessQueue)this.map.get(key = EnqueueingMailAccessCache.keyFor(accountId, session))) || accessQueue.isDeprecated()) {
            int capacity;
            try {
                capacity = MailProviderRegistry.getMailProviderBySession(session, accountId).getProtocol().getMaxCount(mailAccess.getMailConfig().getServer(), 0 == accountId);
            }
            catch (OXException e) {
                capacity = this.queueCapacity;
            }
            MailAccessQueue tmp = capacity > 0 ? (1 == capacity ? new SingletonMailAccessQueue() : new MailAccessQueueImpl(capacity)) : new MailAccessQueueImpl(-1);
            accessQueue = this.map.putIfAbsent(key, tmp);
            if (null == accessQueue) {
                accessQueue = tmp;
            }
        }
        MailAccessQueue mailAccessQueue = accessQueue;
        synchronized (mailAccessQueue) {
            if (accessQueue.isDeprecated()) {
                return false;
            }
            int n = idleSeconds = accessQueue.isEmpty() ? idleSeconds : idleSeconds >> 1;
            if (accessQueue.offer(PooledMailAccess.valueFor(mailAccess, (long)idleSeconds * 1000L))) {
                mailAccess.setCached(true);
                if (DEBUG) {
                    int size = accessQueue.size();
                    if (size == 1) {
                        LOG.debug((Object)("Queued ONE mail access for " + key));
                    } else if (size > this.queueCapacity) {
                        LOG.debug((Object)("\n\tExceeded queue capacity! Detected " + size + " mail access(es) for " + key + '\n'));
                    } else if (size == this.queueCapacity) {
                        LOG.debug((Object)("\n\tReached queue capacity! Queued " + size + " mail access(es) for " + key + '\n'));
                    } else {
                        LOG.debug((Object)("Queued " + size + " mail access(es) for " + key));
                    }
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsMailAccess(Session session, int accountId) {
        MailAccessQueue accessQueue = (MailAccessQueue)this.map.get(EnqueueingMailAccessCache.keyFor(accountId, session));
        if (null == accessQueue) {
            return false;
        }
        MailAccessQueue mailAccessQueue = accessQueue;
        synchronized (mailAccessQueue) {
            return !accessQueue.isDeprecated() && !accessQueue.isEmpty();
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    protected void dispose() {
        this.timerTask.cancel(false);
        for (Key key : new HashSet(this.map.keySet())) {
            this.orderlyClearQueue(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void orderlyClearQueue(Key key) {
        MailAccessQueue accessQueue = (MailAccessQueue)this.map.remove(key);
        if (null == accessQueue) {
            return;
        }
        MailAccessQueue mailAccessQueue = accessQueue;
        synchronized (mailAccessQueue) {
            PooledMailAccess pooledMailAccess;
            accessQueue.markDeprecated();
            while (null != (pooledMailAccess = (PooledMailAccess)accessQueue.poll())) {
                MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = pooledMailAccess.getMailAccess();
                if (DEBUG) {
                    LOG.debug((Object)("Dropping: " + mailAccess));
                }
                mailAccess.setCached(false);
                mailAccess.close(false);
            }
        }
    }

    @Override
    public void clearUserEntries(Session session) throws OXException {
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        int user = session.getUserId();
        int cid = session.getContextId();
        if (null == service || null == service.getAnyActiveSessionForUser(user, cid)) {
            MailAccount[] accounts;
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            for (MailAccount mailAccount : accounts = storageService.getUserMailAccounts(user, cid)) {
                this.orderlyClearQueue(EnqueueingMailAccessCache.keyFor(mailAccount.getId(), session));
            }
        }
    }

    private static Key keyFor(int accountId, Session session) {
        return new Key(accountId, session.getUserId(), session.getContextId());
    }

    private static final class Key {
        private final int user;
        private final int context;
        private final int accountId;
        private final int hash;

        protected Key(int accountId, int user, int context) {
            this.user = user;
            this.context = context;
            this.accountId = accountId;
            this.hash = this.hashCode0();
        }

        private int hashCode0() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.accountId;
            result = 31 * result + this.context;
            result = 31 * result + this.user;
            return result;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.accountId != other.accountId) {
                return false;
            }
            if (this.context != other.context) {
                return false;
            }
            return this.user == other.user;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(16);
            builder.append("{ Key [accountId=").append(this.accountId).append(", user=").append(this.user).append(", context=").append(this.context).append("] }");
            return builder.toString();
        }
    }

    private static final class PurgeExpiredRunnable
    implements Runnable {
        private final ConcurrentMap<Key, MailAccessQueue> map;

        protected PurgeExpiredRunnable(ConcurrentMap<Key, MailAccessQueue> map) {
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                boolean dropQueue = this.isDropQueue();
                Iterator iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    MailAccessQueue accessQueue;
                    Map.Entry entry = iterator.next();
                    MailAccessQueue mailAccessQueue = accessQueue = (MailAccessQueue)entry.getValue();
                    synchronized (mailAccessQueue) {
                        PooledMailAccess pooledMailAccess;
                        while (null != (pooledMailAccess = accessQueue.pollDelayed())) {
                            MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = pooledMailAccess.getMailAccess();
                            mailAccess.setCached(false);
                            if (DEBUG) {
                                LOG.debug((Object)("Timed-out mail access for " + entry.getKey()));
                            }
                            mailAccess.close(false);
                        }
                        if (dropQueue && accessQueue.isEmpty()) {
                            accessQueue.markDeprecated();
                            if (DEBUG) {
                                LOG.debug((Object)("Dropped queue for " + entry.getKey()));
                            }
                            iterator.remove();
                        }
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                LOG.warn((Object)("Purge-expired run failed: " + e.getMessage()), (Throwable)e);
            }
        }

        private boolean isDropQueue() {
            return false;
        }
    }
}

