/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.Quota;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.utils.MailFolderUtility;
import java.util.ArrayList;

public abstract class MailFolderStorage
implements IMailFolderStorage {
    private static final Quota.Type[] STORAGE = new Quota.Type[]{Quota.Type.STORAGE};
    private static final Quota.Type[] MESSAGE = new Quota.Type[]{Quota.Type.MESSAGE};

    @Override
    public abstract boolean exists(String var1) throws OXException;

    @Override
    public abstract MailFolder getFolder(String var1) throws OXException;

    @Override
    public abstract MailFolder[] getSubfolders(String var1, boolean var2) throws OXException;

    @Override
    public MailFolder getRootFolder() throws OXException {
        return this.getFolder("default");
    }

    @Override
    public abstract void checkDefaultFolders() throws OXException;

    @Override
    public abstract String createFolder(MailFolderDescription var1) throws OXException;

    @Override
    public abstract String updateFolder(String var1, MailFolderDescription var2) throws OXException;

    @Override
    public abstract String moveFolder(String var1, String var2) throws OXException;

    @Override
    public String renameFolder(String fullName, String newName) throws OXException {
        MailFolder folder = this.getFolder(fullName);
        if (MailFolderUtility.isEmpty(newName)) {
            throw MailExceptionCode.INVALID_FOLDER_NAME_EMPTY.create();
        }
        if (newName.indexOf(folder.getSeparator()) != -1) {
            throw MailExceptionCode.INVALID_FOLDER_NAME2.create(newName);
        }
        String newPath = "default".equals(folder.getParentFullname()) ? newName : folder.getParentFullname() + folder.getSeparator() + newName;
        return this.moveFolder(fullName, newPath);
    }

    @Override
    public String deleteFolder(String fullName) throws OXException {
        return this.deleteFolder(fullName, false);
    }

    @Override
    public abstract String deleteFolder(String var1, boolean var2) throws OXException;

    @Override
    public void clearFolder(String fullName) throws OXException {
        this.clearFolder(fullName, false);
    }

    @Override
    public abstract void clearFolder(String var1, boolean var2) throws OXException;

    @Override
    public MailFolder[] getPath2DefaultFolder(String fullName) throws OXException {
        if (fullName.equals("default")) {
            return new MailFolder[0];
        }
        MailFolder f = this.getFolder(fullName);
        ArrayList<MailFolder> list = new ArrayList<MailFolder>();
        do {
            list.add(f);
        } while (!(f = this.getFolder(f.getParentFullname())).getFullname().equals("default"));
        return list.toArray(new MailFolder[list.size()]);
    }

    @Override
    public Quota getStorageQuota(String fullName) throws OXException {
        return this.getQuotas(fullName, STORAGE)[0];
    }

    @Override
    public Quota getMessageQuota(String fullName) throws OXException {
        return this.getQuotas(fullName, MESSAGE)[0];
    }

    @Override
    public abstract Quota[] getQuotas(String var1, Quota.Type[] var2) throws OXException;

    @Override
    public String getDefaultFolderPrefix() throws OXException {
        this.checkDefaultFolders();
        String trashFullName = this.getTrashFolder();
        char separator = this.getFolder(trashFullName).getSeparator();
        int pos = trashFullName.lastIndexOf(separator);
        return pos < 0 ? "" : trashFullName.substring(0, pos + 1);
    }

    @Override
    public abstract String getConfirmedHamFolder() throws OXException;

    @Override
    public abstract String getConfirmedSpamFolder() throws OXException;

    @Override
    public abstract String getDraftsFolder() throws OXException;

    @Override
    public abstract String getSpamFolder() throws OXException;

    @Override
    public abstract String getSentFolder() throws OXException;

    @Override
    public abstract String getTrashFolder() throws OXException;

    @Override
    public abstract void releaseResources() throws OXException;
}

