/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.mail.MailField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public final class MailFields {
    private static final MailField[] VALUES = MailField.values();
    private final boolean[] arr = new boolean[VALUES.length];

    public MailFields() {
        Arrays.fill(this.arr, false);
    }

    public MailFields(boolean initValue) {
        Arrays.fill(this.arr, initValue);
    }

    public MailFields(MailField mailField, MailField ... mailFields) {
        this();
        this.arr[mailField.ordinal()] = true;
        for (MailField mf : mailFields) {
            this.arr[mf.ordinal()] = true;
        }
    }

    public MailFields(MailField[] mailFields) {
        this();
        for (MailField mailField : mailFields) {
            this.arr[mailField.ordinal()] = true;
        }
    }

    public MailFields(Collection<MailField> mailFields) {
        this();
        for (MailField mailField : mailFields) {
            this.arr[mailField.ordinal()] = true;
        }
    }

    public MailFields(MailFields mailFields) {
        System.arraycopy(mailFields.arr, 0, this.arr, 0, this.arr.length);
    }

    public int size() {
        int size = 0;
        for (boolean field : this.arr) {
            if (!field) continue;
            ++size;
        }
        return size;
    }

    public MailFields add(MailField mailField) {
        this.arr[mailField.ordinal()] = true;
        return this;
    }

    public void addAll(MailField[] mailFields) {
        for (MailField mailField : mailFields) {
            this.arr[mailField.ordinal()] = true;
        }
    }

    public void addAll(Collection<MailField> mailFields) {
        for (MailField mailField : mailFields) {
            this.arr[mailField.ordinal()] = true;
        }
    }

    public void removeMailField(MailField mailField) {
        this.arr[mailField.ordinal()] = false;
    }

    public void removeMailFields(MailField[] mailFields) {
        for (MailField mailField : mailFields) {
            this.arr[mailField.ordinal()] = false;
        }
    }

    public boolean contains(MailField mailField) {
        return this.arr[mailField.ordinal()];
    }

    public boolean containsAny(MailFields mailFields) {
        boolean[] otherArr = mailFields.arr;
        for (int i = 0; i < otherArr.length; ++i) {
            if (!otherArr[i] || !this.arr[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(MailFields mailFields) {
        boolean[] otherArr = mailFields.arr;
        for (int i = 0; i < otherArr.length; ++i) {
            if (!otherArr[i] || this.arr[i]) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(MailFields otherFields) {
        boolean[] otherArr = otherFields.arr;
        boolean retval = false;
        for (int i = 0; i < otherArr.length; ++i) {
            if (!otherArr[i] || !this.arr[i]) continue;
            this.arr[i] = false;
            retval = true;
        }
        return retval;
    }

    public boolean retainAll(MailFields otherFields) {
        boolean[] otherArr = otherFields.arr;
        boolean retval = false;
        for (int i = 0; i < otherArr.length; ++i) {
            if (otherArr[i] || !this.arr[i]) continue;
            this.arr[i] = false;
            retval = true;
        }
        return retval;
    }

    public boolean isEmpty() {
        boolean retval = true;
        for (int i = 0; retval && i < this.arr.length; ++i) {
            retval = !this.arr[i];
        }
        return retval;
    }

    public MailField[] toArray() {
        ArrayList<MailField> l = new ArrayList<MailField>(this.arr.length);
        for (int i = 0; i < this.arr.length; ++i) {
            if (!this.arr[i]) continue;
            l.add(VALUES[i]);
        }
        return l.toArray(new MailField[l.size()]);
    }

    public Set<MailField> toSet() {
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        for (int i = 0; i < this.arr.length; ++i) {
            if (!this.arr[i]) continue;
            set.add(VALUES[i]);
        }
        return set;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arr);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailFields)) {
            return false;
        }
        MailFields other = (MailFields)obj;
        return Arrays.equals(this.arr, other.arr);
    }
}

