/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.Arrays;

public final class UserConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8277899698366715803L;
    private static final transient org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UserConfiguration.class));
    public static final int WEBMAIL = 1;
    public static final int CALENDAR = 2;
    public static final int CONTACTS = 4;
    public static final int TASKS = 8;
    public static final int INFOSTORE = 16;
    public static final int PROJECTS = 32;
    public static final int FORUM = 64;
    public static final int PINBOARD_WRITE_ACCESS = 128;
    public static final int WEBDAV_XML = 256;
    public static final int WEBDAV = 512;
    public static final int ICAL = 1024;
    public static final int VCARD = 2048;
    public static final int RSS_BOOKMARKS = 4096;
    public static final int RSS_PORTAL = 8192;
    public static final int MOBILITY = 16384;
    public static final int EDIT_PUBLIC_FOLDERS = 32768;
    public static final int READ_CREATE_SHARED_FOLDERS = 65536;
    public static final int DELEGATE_TASKS = 131072;
    public static final int EDIT_GROUP = 262144;
    public static final int EDIT_RESOURCE = 524288;
    public static final int EDIT_PASSWORD = 0x100000;
    public static final int COLLECT_EMAIL_ADDRESSES = 0x200000;
    public static final int MULTIPLE_MAIL_ACCOUNTS = 0x400000;
    public static final int SUBSCRIPTION = 0x800000;
    public static final int PUBLICATION = 0x1000000;
    public static final int ACTIVE_SYNC = 0x2000000;
    public static final int USM = 0x4000000;
    public static final int OLOX20 = 0x8000000;
    public static final int DENIED_PORTAL = 0x10000000;
    public static final int CALDAV = 0x20000000;
    public static final int CARDDAV = 0x40000000;
    private int permissionBits;
    private final int userId;
    private int[] groups;
    private final Context ctx;
    private int[] accessibleModules;
    private volatile boolean accessibleModulesComputed;

    public UserConfiguration(int permissionBits, int userId, int[] groups, Context ctx) {
        this.permissionBits = permissionBits;
        this.userId = userId;
        if (null == groups) {
            this.groups = null;
        } else {
            this.groups = new int[groups.length];
            System.arraycopy(groups, 0, this.groups, 0, groups.length);
        }
        this.ctx = ctx;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof UserConfiguration)) {
            return false;
        }
        UserConfiguration uc = (UserConfiguration)other;
        if (this.userId != uc.userId || this.permissionBits != uc.permissionBits) {
            return false;
        }
        if (null != this.groups) {
            if (null == uc.groups) {
                return false;
            }
            Arrays.sort(this.groups);
            Arrays.sort(uc.groups);
            if (!Arrays.equals(this.groups, uc.groups)) {
                return false;
            }
        }
        if (null != uc.groups) {
            return false;
        }
        if (null != this.ctx) {
            if (null == uc.ctx) {
                return false;
            }
            return this.ctx.getContextId() == uc.ctx.getContextId();
        }
        return null == uc.ctx;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.userId;
        hash = 31 * hash + this.permissionBits;
        if (null != this.groups) {
            Arrays.sort(this.groups);
            for (int i = 0; i < this.groups.length; ++i) {
                hash = 31 * hash + this.groups[i];
            }
        }
        if (null != this.ctx) {
            hash = 31 * hash + this.ctx.getContextId();
        }
        return hash;
    }

    public Object clone() {
        try {
            UserConfiguration clone = (UserConfiguration)super.clone();
            if (this.groups != null) {
                clone.groups = new int[this.groups.length];
                System.arraycopy(this.groups, 0, clone.groups, 0, this.groups.length);
            }
            if (this.accessibleModules != null) {
                clone.accessibleModules = new int[this.accessibleModules.length];
                System.arraycopy(this.accessibleModules, 0, clone.accessibleModules, 0, this.accessibleModules.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new InternalError(e.getMessage());
        }
    }

    public int getPermissionBits() {
        return this.permissionBits;
    }

    public void setPermissionBits(int permissionBits) {
        this.permissionBits = permissionBits;
        this.accessibleModulesComputed = false;
    }

    public boolean hasWebMail() {
        return this.hasPermission(1);
    }

    public void setWebMail(boolean enableWebMail) {
        this.setPermission(enableWebMail, 1);
        this.accessibleModulesComputed = false;
    }

    public boolean hasCalendar() {
        return this.hasPermission(2);
    }

    public void setCalendar(boolean enableCalender) {
        this.setPermission(enableCalender, 2);
        this.accessibleModulesComputed = false;
    }

    public boolean hasContact() {
        return this.hasPermission(4);
    }

    public void setContact(boolean enableContact) {
        this.setPermission(enableContact, 4);
        this.accessibleModulesComputed = false;
    }

    public boolean hasTask() {
        return this.hasPermission(8);
    }

    public void setTask(boolean enableTask) {
        this.setPermission(enableTask, 8);
        this.accessibleModulesComputed = false;
    }

    public boolean hasInfostore() {
        return this.hasPermission(16);
    }

    public void setInfostore(boolean enableInfostore) {
        this.setPermission(enableInfostore, 16);
        this.accessibleModulesComputed = false;
    }

    public boolean hasProject() {
        return this.hasPermission(32);
    }

    public void setProject(boolean enableProject) {
        this.setPermission(enableProject, 32);
        this.accessibleModulesComputed = false;
    }

    public boolean hasForum() {
        return this.hasPermission(64);
    }

    public void setForum(boolean enableForum) {
        this.setPermission(enableForum, 64);
    }

    public boolean hasPinboardWriteAccess() {
        return this.hasPermission(128);
    }

    public void setPinboardWriteAccess(boolean enablePinboardWriteAccess) {
        this.setPermission(enablePinboardWriteAccess, 128);
    }

    public boolean hasWebDAVXML() {
        return this.hasPermission(256);
    }

    public void setWebDAVXML(boolean enableWebDAVXML) {
        this.setPermission(enableWebDAVXML, 256);
    }

    public boolean hasWebDAV() {
        return this.hasPermission(512);
    }

    public void setWebDAV(boolean enableWebDAV) {
        this.setPermission(enableWebDAV, 512);
    }

    public boolean hasICal() {
        return this.hasPermission(1024);
    }

    public void setICal(boolean enableICal) {
        this.setPermission(enableICal, 1024);
    }

    public boolean hasVCard() {
        return this.hasPermission(2048);
    }

    public void setVCard(boolean enableVCard) {
        this.setPermission(enableVCard, 2048);
    }

    public boolean hasRSSBookmarks() {
        return this.hasPermission(4096);
    }

    public void setRSSBookmarks(boolean enableRSSBookmarks) {
        this.setPermission(enableRSSBookmarks, 4096);
    }

    public boolean hasRSSPortal() {
        return this.hasPermission(8192);
    }

    public void setRSSPortal(boolean enableRSSPortal) {
        this.setPermission(enableRSSPortal, 8192);
    }

    public boolean hasSyncML() {
        return this.hasPermission(16384);
    }

    public void setSyncML(boolean enableSyncML) {
        this.setPermission(enableSyncML, 16384);
    }

    public boolean hasPIM() {
        return this.hasCalendar() && this.hasContact() && this.hasTask();
    }

    public boolean hasTeamView() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasFreeBusy() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasConflictHandling() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasParticipantsDialog() {
        return this.hasConflictHandling();
    }

    public boolean hasPortal() {
        return !this.hasPermission(0x10000000);
    }

    public void setDeniedPortal(boolean deniedPortal) {
        this.setPermission(deniedPortal, 0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAccessibleModules() {
        if (this.accessibleModulesComputed) {
            return this.cloneAccessibleModules();
        }
        UserConfiguration userConfiguration = this;
        synchronized (userConfiguration) {
            if (this.accessibleModulesComputed) {
                return this.cloneAccessibleModules();
            }
            TIntArrayList array = new TIntArrayList(10);
            if (this.hasTask()) {
                array.add(1);
            }
            if (this.hasCalendar()) {
                array.add(2);
            }
            if (this.hasContact()) {
                array.add(3);
            }
            if (this.hasProject()) {
                array.add(6);
            }
            if (this.hasInfostore()) {
                array.add(8);
            }
            if (this.hasWebMail()) {
                array.add(7);
            }
            array.add(5);
            array.add(4);
            array.add(13);
            array.add(14);
            this.accessibleModules = array.toArray();
            Arrays.sort(this.accessibleModules);
            this.accessibleModulesComputed = true;
            return this.cloneAccessibleModules();
        }
    }

    public boolean hasModuleAccess(int module) {
        return Arrays.binarySearch(this.getAccessibleModules(), module) >= 0;
    }

    private int[] cloneAccessibleModules() {
        int[] clone = new int[this.accessibleModules.length];
        System.arraycopy(this.accessibleModules, 0, clone, 0, clone.length);
        return clone;
    }

    public boolean hasFullPublicFolderAccess() {
        return this.hasPermission(32768);
    }

    public void setFullPublicFolderAccess(boolean enableFullPublicFolderAccess) {
        this.setPermission(enableFullPublicFolderAccess, 32768);
    }

    public boolean hasFullSharedFolderAccess() {
        return this.hasPermission(65536);
    }

    public void setFullSharedFolderAccess(boolean enableFullSharedFolderAccess) {
        this.setPermission(enableFullSharedFolderAccess, 65536);
    }

    public boolean canDelegateTasks() {
        return this.hasPermission(131072);
    }

    public void setDelegateTasks(boolean enableDelegateTasks) {
        this.setPermission(enableDelegateTasks, 131072);
    }

    public boolean isCollectEmailAddresses() {
        return this.hasPermission(0x200000);
    }

    public void setCollectEmailAddresses(boolean collectEmailAddresses) {
        this.setPermission(collectEmailAddresses, 0x200000);
    }

    public boolean isMultipleMailAccounts() {
        return this.hasPermission(0x400000);
    }

    public void setMultipleMailAccounts(boolean multipleMailAccounts) {
        this.setPermission(multipleMailAccounts, 0x400000);
    }

    public boolean isSubscription() {
        return this.hasPermission(0x800000);
    }

    public void setSubscription(boolean subscription) {
        this.setPermission(subscription, 0x800000);
    }

    public boolean isPublication() {
        return this.hasPermission(0x1000000);
    }

    public void setPublication(boolean publication) {
        this.setPermission(publication, 0x1000000);
    }

    public boolean hasActiveSync() {
        return this.hasPermission(0x2000000);
    }

    public void setActiveSync(boolean eas) {
        this.setPermission(eas, 0x2000000);
    }

    public boolean hasUSM() {
        return this.hasPermission(0x4000000);
    }

    public void setUSM(boolean usm) {
        this.setPermission(usm, 0x4000000);
    }

    public boolean hasOLOX20() {
        return this.hasPermission(0x8000000);
    }

    public void setOLOX20(boolean olox20) {
        this.setPermission(olox20, 0x8000000);
    }

    public boolean isEditGroup() {
        return this.hasPermission(262144);
    }

    public void setEditGroup(boolean editGroup) {
        this.setPermission(editGroup, 262144);
    }

    public boolean isEditResource() {
        return this.hasPermission(524288);
    }

    public void setEditResource(boolean editResource) {
        this.setPermission(editResource, 524288);
    }

    public boolean isEditPassword() {
        return this.hasPermission(0x100000);
    }

    public void setEditPassword(boolean editPassword) {
        this.setPermission(editPassword, 0x100000);
    }

    public boolean hasPermission(int permission) {
        return (this.permissionBits & permission) == permission;
    }

    private void setPermission(boolean enable, int permission) {
        this.permissionBits = enable ? this.permissionBits | permission : this.permissionBits & ~permission;
    }

    public int getUserId() {
        return this.userId;
    }

    public int[] getGroups() {
        if (null == this.groups) {
            return null;
        }
        int[] clone = new int[this.groups.length];
        System.arraycopy(this.groups, 0, clone, 0, clone.length);
        return clone;
    }

    public Context getContext() {
        return this.ctx;
    }

    public String toString() {
        return new StringBuilder(32).append("UserConfiguration_").append(this.userId).append('@').append(Integer.toBinaryString(this.permissionBits)).toString();
    }
}

