/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InfostoreLongerURLFieldTask
implements UpdateTask {
    private final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreLongerURLFieldTask.class));

    @Override
    public int addedWithVersion() {
        return 12;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection writeCon = null;
        Statement stmt = null;
        Object checkAvailable = null;
        ResultSet rs = null;
        try {
            writeCon = Database.get(contextId, true);
            writeCon.setAutoCommit(false);
            stmt = writeCon.prepareStatement("ALTER TABLE infostore_document MODIFY url varchar(256)");
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement("ALTER TABLE del_infostore_document MODIFY url varchar(256)");
            stmt.executeUpdate();
            writeCon.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(writeCon);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException x) {
                    this.LOG.warn((Object)"Couldn't close statement", (Throwable)x);
                }
            }
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException x) {
                    this.LOG.warn((Object)"Couldn't close result set", (Throwable)x);
                }
            }
            if (writeCon != null) {
                try {
                    writeCon.setAutoCommit(true);
                }
                catch (SQLException x) {
                    this.LOG.warn((Object)"Can't reset auto commit", (Throwable)x);
                }
                if (writeCon != null) {
                    Database.back(contextId, true, writeCon);
                }
            }
        }
    }
}

