/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.RdbContextStorage;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class DropIndividualUserPermissionsOnPublicFolderTask
extends UpdateTaskAdapter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DropIndividualUserPermissionsOnPublicFolderTask.class));

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.GlobalAddressBookPermissionsResolverTask"};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(ctxId, true);
        try {
            DBUtils.startTransaction(con);
            SQLException re = null;
            int[] contextIds = Database.getContextsInSameSchema(ctxId);
            progress.setTotal(contextIds.length);
            int pos = 0;
            for (int contextId : contextIds) {
                progress.setState(pos++);
                try {
                    List<OCLPermission> permissions = this.getPermissions(con, contextId);
                    int contextAdminId = RdbContextStorage.getAdmin(con, contextId);
                    this.correctGroupZero(con, contextId, permissions);
                    this.correctContextAdmin(con, contextId, permissions, contextAdminId);
                    this.dropAllOtherPermissions(con, contextId, this.isContained(permissions, contextAdminId), contextAdminId);
                }
                catch (SQLException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    if (null != re) continue;
                    re = e;
                }
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    private void correctGroupZero(Connection con, int ctxId, List<OCLPermission> permissions) throws SQLException {
        if (this.isGroupZeroCorrect(permissions)) {
            return;
        }
        this.correctPermission(con, ctxId, permissions, 0, false, true);
    }

    private boolean isGroupZeroCorrect(List<OCLPermission> permissions) {
        for (OCLPermission permission : permissions) {
            if (0 != permission.getEntity()) continue;
            return !permission.isFolderAdmin() && 8 == permission.getFolderPermission() && 0 == permission.getReadPermission() && 0 == permission.getWritePermission() && 0 == permission.getDeletePermission();
        }
        return false;
    }

    private void correctContextAdmin(Connection con, int ctxId, List<OCLPermission> permissions, int contextAdminId) throws SQLException {
        if (!this.isContextAdminWrong(permissions, contextAdminId)) {
            return;
        }
        this.correctPermission(con, ctxId, permissions, contextAdminId, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctPermission(Connection con, int ctxId, List<OCLPermission> permissions, int permId, boolean admin, boolean group) throws SQLException {
        PreparedStatement stmt = null;
        try {
            boolean update = this.isContained(permissions, permId);
            String sql = update ? "UPDATE oxfolder_permissions SET fp=?,orp=?,owp=?,odp=?,admin_flag=?,system=? WHERE cid=? AND fuid=? AND permission_id=?" : "INSERT INTO oxfolder_permissions (fp,orp,owp,odp,admin_flag,system,cid,fuid,permission_id,group_flag) VALUE (?,?,?,?,?,?,?,?,?,?)";
            stmt = con.prepareStatement(sql);
            int pos = 1;
            stmt.setInt(pos++, 8);
            stmt.setInt(pos++, 0);
            stmt.setInt(pos++, 0);
            stmt.setInt(pos++, 0);
            stmt.setBoolean(pos++, admin);
            stmt.setBoolean(pos++, false);
            stmt.setInt(pos++, ctxId);
            stmt.setInt(pos++, 2);
            stmt.setInt(pos++, permId);
            if (!update) {
                stmt.setBoolean(pos++, group);
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
    }

    private boolean isContained(List<OCLPermission> permissions, int adminId) {
        for (OCLPermission permission : permissions) {
            if (adminId != permission.getEntity()) continue;
            return true;
        }
        return false;
    }

    private boolean isContextAdminWrong(List<OCLPermission> permissions, int adminId) {
        for (OCLPermission permission : permissions) {
            if (adminId == permission.getEntity()) {
                return !permission.isFolderAdmin();
            }
            if (adminId == permission.getEntity() || permission.isGroupPermission() || !permission.isFolderAdmin()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAllOtherPermissions(Connection con, int ctxId, boolean addedAdmin, int adminId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String sql = "DELETE FROM oxfolder_permissions WHERE cid=? AND fuid=? AND permission_id!=?";
            if (addedAdmin) {
                sql = sql + " AND permission_id!=?";
            }
            stmt = con.prepareStatement(sql);
            int pos = 1;
            stmt.setInt(pos++, ctxId);
            stmt.setInt(pos++, 2);
            stmt.setInt(pos++, 0);
            if (addedAdmin) {
                stmt.setInt(pos++, adminId);
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OCLPermission> getPermissions(Connection con, int ctxId) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<OCLPermission> retval = new ArrayList<OCLPermission>();
        try {
            stmt = con.prepareStatement("SELECT permission_id,fp,orp,owp,odp,admin_flag,group_flag,system FROM oxfolder_permissions WHERE cid=? AND fuid=?");
            stmt.setInt(1, ctxId);
            stmt.setInt(2, 2);
            result = stmt.executeQuery();
            while (result.next()) {
                OCLPermission p = new OCLPermission();
                p.setEntity(result.getInt(1));
                p.setAllPermission(result.getInt(2), result.getInt(3), result.getInt(4), result.getInt(5));
                p.setFolderAdmin(result.getInt(6) > 0);
                p.setGroupPermission(result.getInt(7) > 0);
                p.setSystem(result.getInt(8));
                retval.add(p);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }
}

