/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MailAccountCreateTablesTask;
import com.openexchange.groupware.update.tasks.POP3CreateTableTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DropFKTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{MailAccountCreateTablesTask.class.getName(), POP3CreateTableTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            con.setAutoCommit(false);
            con.setAutoCommit(false);
            List<String> tables = Arrays.asList("pop3_storage_deleted", "pop3_storage_ids", "user_mail_account_properties", "user_mail_account", "user_transport_account_properties", "user_transport_account", "virtualBackupPermission", "virtualBackupSubscription", "virtualBackupTree", "virtualPermission", "virtualSubscription", "virtualTree");
            for (String table : tables) {
                this.dropForeignKeysFrom(table, con);
            }
            LinkedHashMap indexes = new LinkedHashMap();
            ArrayList<List<String>> indexList = new ArrayList<List<String>>(4);
            indexList.add(Arrays.asList("cid", "tree", "user", "parentId"));
            indexList.add(Arrays.asList("cid", "tree", "user", "shadow"));
            indexList.add(Arrays.asList("cid", "user"));
            indexList.add(Arrays.asList("cid", "modifiedBy"));
            indexes.put("virtualTree", indexList);
            indexList = new ArrayList(1);
            indexList.add(Arrays.asList("cid", "tree", "user", "folderId"));
            indexes.put("virtualPermission", indexList);
            indexList = new ArrayList(4);
            indexList.add(Arrays.asList("cid", "tree", "user", "parentId"));
            indexList.add(Arrays.asList("cid", "tree", "user", "shadow"));
            indexList.add(Arrays.asList("cid", "user"));
            indexList.add(Arrays.asList("cid", "modifiedBy"));
            indexes.put("virtualTree", indexList);
            indexList = new ArrayList(1);
            indexList.add(Arrays.asList("cid", "tree", "user", "folderId"));
            indexes.put("virtualPermission", indexList);
            indexList = new ArrayList(2);
            indexList.add(Arrays.asList("cid", "user"));
            indexList.add(Arrays.asList("cid", "user", "id"));
            indexes.put("pop3_storage_ids", indexList);
            indexList = new ArrayList(2);
            indexList.add(Arrays.asList("cid", "user"));
            indexList.add(Arrays.asList("cid", "user", "id"));
            indexes.put("pop3_storage_deleted", indexList);
            for (Map.Entry entry : indexes.entrySet()) {
                String table = (String)entry.getKey();
                for (List cols : (List)entry.getValue()) {
                    this.checkIndex(table, cols.toArray(new String[cols.size()]), null, con);
                }
            }
            con.commit();
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropForeignKeysFrom(String table, Connection con) throws SQLException {
        List<String> keyNames = Tools.allForeignKey(con, table);
        Statement stmt = null;
        for (String keyName : keyNames) {
            try {
                stmt = con.createStatement();
                stmt.execute("ALTER TABLE " + table + " DROP FOREIGN KEY " + keyName);
            }
            finally {
                DBUtils.closeSQLStuff(null, stmt);
            }
        }
    }

    private void checkIndex(String table, String[] columns, String optName, Connection con) throws SQLException {
        if (null == Tools.existsIndex(con, table, columns)) {
            Tools.createIndex(con, table, optName, columns, false);
        }
    }
}

