/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public final class ContactsFieldSizeUpdateTask
implements UpdateTask {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContactsFieldSizeUpdateTask.class));
    private static final String STR_INFO = "Performing update task 'ContactsFieldSizeUpdateTask'";

    @Override
    public int addedWithVersion() {
        return 15;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)STR_INFO);
        }
        this.correctTable("prg_contacts", contextId);
        this.correctTable("del_contacts", contextId);
    }

    private void correctTable(String sqltable, int contextId) throws OXException {
        Result result = this.determineResult(sqltable, contextId);
        this.dropColumns(result.toDelete, sqltable, contextId);
        this.changeColumns(result.toChange, sqltable, contextId);
    }

    private Result determineResult(String sqltable, int contextId) throws OXException {
        Result result;
        Connection writeCon;
        HashMap<String, Integer> columnRefer = new HashMap<String, Integer>(100);
        columnRefer.put("field01", 320);
        columnRefer.put("field02", 128);
        columnRefer.put("field03", 128);
        columnRefer.put("field04", 128);
        columnRefer.put("field05", 64);
        columnRefer.put("field06", 64);
        columnRefer.put("field07", 256);
        columnRefer.put("field08", 64);
        columnRefer.put("field09", 64);
        columnRefer.put("field10", 64);
        columnRefer.put("field11", 64);
        columnRefer.put("field12", 64);
        columnRefer.put("field13", 64);
        columnRefer.put("field14", 64);
        columnRefer.put("field15", 64);
        columnRefer.put("field16", 64);
        columnRefer.put("field17", 5680);
        columnRefer.put("field18", 512);
        columnRefer.put("field19", 128);
        columnRefer.put("field20", 128);
        columnRefer.put("field21", 64);
        columnRefer.put("field22", 64);
        columnRefer.put("field23", 256);
        columnRefer.put("field24", 64);
        columnRefer.put("field25", 128);
        columnRefer.put("field26", 64);
        columnRefer.put("field27", 64);
        columnRefer.put("field28", 64);
        columnRefer.put("field29", 64);
        columnRefer.put("field30", 128);
        columnRefer.put("field31", 64);
        columnRefer.put("field32", 64);
        columnRefer.put("field33", 64);
        columnRefer.put("field34", 5192);
        columnRefer.put("field35", 64);
        columnRefer.put("field36", 64);
        columnRefer.put("field37", 256);
        columnRefer.put("field38", 64);
        columnRefer.put("field39", 64);
        columnRefer.put("field40", 64);
        columnRefer.put("field41", 64);
        columnRefer.put("field42", 64);
        columnRefer.put("field43", 64);
        columnRefer.put("field44", 128);
        columnRefer.put("field45", 64);
        columnRefer.put("field46", 64);
        columnRefer.put("field47", 64);
        columnRefer.put("field48", 64);
        columnRefer.put("field49", 64);
        columnRefer.put("field50", 64);
        columnRefer.put("field51", 64);
        columnRefer.put("field52", 64);
        columnRefer.put("field53", 64);
        columnRefer.put("field54", 64);
        columnRefer.put("field55", 64);
        columnRefer.put("field56", 64);
        columnRefer.put("field57", 64);
        columnRefer.put("field58", 64);
        columnRefer.put("field59", 64);
        columnRefer.put("field60", 64);
        columnRefer.put("field61", 64);
        columnRefer.put("field62", 64);
        columnRefer.put("field63", 64);
        columnRefer.put("field64", 64);
        columnRefer.put("field65", 256);
        columnRefer.put("field66", 256);
        columnRefer.put("field67", 256);
        columnRefer.put("field68", 128);
        columnRefer.put("field69", 1024);
        columnRefer.put("field70", 64);
        columnRefer.put("field71", 64);
        columnRefer.put("field72", 64);
        columnRefer.put("field73", 64);
        columnRefer.put("field74", 64);
        columnRefer.put("field75", 64);
        columnRefer.put("field76", 64);
        columnRefer.put("field77", 64);
        columnRefer.put("field78", 64);
        columnRefer.put("field79", 64);
        columnRefer.put("field80", 64);
        columnRefer.put("field81", 64);
        columnRefer.put("field82", 64);
        columnRefer.put("field83", 64);
        columnRefer.put("field84", 64);
        columnRefer.put("field85", 64);
        columnRefer.put("field86", 64);
        columnRefer.put("field87", 64);
        columnRefer.put("field88", 64);
        columnRefer.put("field89", 64);
        columnRefer.put("field90", 320);
        HashSet<String> columnDelete = new HashSet<String>(Arrays.asList("field91", "field92", "field93", "field94", "field95", "field96", "field97", "field98", "field99"));
        try {
            writeCon = Database.get(contextId, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData metadata = writeCon.getMetaData();
            rs = metadata.getColumns(null, null, sqltable, null);
            HashMap<String, Integer> toChange = new HashMap<String, Integer>(100);
            HashSet<String> toDelete = new HashSet<String>(10);
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                if (columnDelete.contains(name)) {
                    toDelete.add(name);
                    continue;
                }
                if (!columnRefer.containsKey(name)) continue;
                int size = rs.getInt("COLUMN_SIZE");
                Integer desiredSize = (Integer)columnRefer.get(name);
                if (desiredSize == size) {
                    LOG.info((Object)("FIELD " + sqltable + '.' + name + " WITH SIZE " + size + " IS CORRECT " + desiredSize));
                    continue;
                }
                LOG.warn((Object)("CHANGE FIELD " + sqltable + '.' + name + " WITH SIZE " + size + " TO NEW SIZE " + desiredSize));
                toChange.put(name, desiredSize);
            }
            result = new Result(toChange, toDelete);
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs);
                Database.back(contextId, true, writeCon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs);
        Database.back(contextId, true, writeCon);
        return result;
    }

    private void dropColumns(Set<String> toDelete, String sqltable, int contextId) throws OXException {
        if (toDelete.isEmpty()) {
            return;
        }
        int size = toDelete.size();
        StringBuilder alterBuilder = new StringBuilder(size + 1 << 5);
        alterBuilder.append("ALTER TABLE ").append(sqltable).append(' ');
        Iterator<String> iter = toDelete.iterator();
        alterBuilder.append("DROP COLUMN ").append(iter.next());
        for (int i = 1; i < size; ++i) {
            alterBuilder.append(", DROP COLUMN ").append(iter.next());
        }
        String alterCommand = alterBuilder.toString();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DROPPING SQL FIELDS: " + alterCommand));
        }
        this.executeAlterCommand(alterCommand, contextId);
    }

    private void changeColumns(Map<String, Integer> toChange, String sqltable, int contextId) throws OXException {
        if (toChange.isEmpty()) {
            return;
        }
        int size = toChange.size();
        StringBuilder alterBuilder = new StringBuilder(size + 1 << 5);
        alterBuilder.append("ALTER TABLE ").append(sqltable).append(' ');
        Iterator<Map.Entry<String, Integer>> iter = toChange.entrySet().iterator();
        Map.Entry<String, Integer> entry = iter.next();
        alterBuilder.append("MODIFY ").append(entry.getKey()).append(" VARCHAR(").append(entry.getValue()).append(')');
        for (int i = 1; i < size; ++i) {
            Map.Entry<String, Integer> entry2 = iter.next();
            alterBuilder.append(", MODIFY ").append(entry2.getKey()).append(" VARCHAR(").append(entry2.getValue()).append(')');
        }
        String alterCommand = alterBuilder.toString();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("CHANGING SQL FIELDS' SIZE: " + alterCommand));
        }
        this.executeAlterCommand(alterCommand, contextId);
    }

    private void executeAlterCommand(String alterCommand, int contextId) throws OXException {
        Connection writeCon;
        try {
            writeCon = Database.get(contextId, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        Statement st = null;
        try {
            st = writeCon.createStatement();
            st.executeUpdate(alterCommand);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, st);
            Database.back(contextId, true, writeCon);
        }
    }

    private final class Result {
        final Map<String, Integer> toChange;
        final Set<String> toDelete;

        public Result(Map<String, Integer> toChange, Set<String> toDelete) {
            this.toChange = toChange;
            this.toDelete = toDelete;
        }
    }
}

