/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.groupware.tasks.Task;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.search.SearchAttributeFetcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TaskAttributeFetcher
implements SearchAttributeFetcher<Task> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AttributeGetter.class));
    private static final Map<String, AttributeGetter> GETTERS;
    private static final TaskAttributeFetcher instance;

    public static TaskAttributeFetcher getInstance() {
        return instance;
    }

    private TaskAttributeFetcher() {
    }

    @Override
    public <T> T getAttribute(String attributeName, Task candidate) {
        AttributeGetter getter = GETTERS.get(attributeName);
        if (null == getter) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No getter for field: " + attributeName));
            }
            return null;
        }
        return (T)getter.getObject(candidate);
    }

    static {
        HashMap<String, AttributeGetter> m = new HashMap<String, AttributeGetter>(25);
        m.put("actual_costs", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return Float.valueOf(candidate.getActualCosts().floatValue());
            }
        });
        m.put("actual_duration", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return (long)candidate.getActualDuration();
            }
        });
        m.put("after_complete", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getAfterComplete();
            }
        });
        m.put("billing_information", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getBillingInformation();
            }
        });
        m.put("companies", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getCompanies();
            }
        });
        m.put("currency", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getCurrency();
            }
        });
        m.put("date_completed", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getDateCompleted();
            }
        });
        m.put("percent_completed", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getPercentComplete();
            }
        });
        m.put("priority", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getPriority();
            }
        });
        m.put("project_id", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getProjectID();
            }
        });
        m.put("status", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getStatus();
            }
        });
        m.put("target_costs", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return Float.valueOf(candidate.getTargetCosts().floatValue());
            }
        });
        m.put("target_duration", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return (long)candidate.getTargetDuration();
            }
        });
        m.put("trip_meter", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getTripMeter();
            }
        });
        m.put("alarm", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getAlarm();
            }
        });
        m.put("change_exceptions", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getChangeException();
            }
        });
        m.put("confirmmessage", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getConfirmMessage();
            }
        });
        m.put("confirmation", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getConfirm();
            }
        });
        m.put("day_in_month", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getDayInMonth();
            }
        });
        m.put("days", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getDays();
            }
        });
        m.put("delete_exceptions", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getDeleteException();
            }
        });
        m.put("end_date", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getEndDate();
            }
        });
        m.put("interval", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getInterval();
            }
        });
        m.put("month", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getMonth();
            }
        });
        m.put("note", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getNote();
            }
        });
        m.put("notification", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getNotification();
            }
        });
        m.put("occurrences", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getOccurrence();
            }
        });
        m.put("participants", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getParticipants();
            }
        });
        m.put("recurrence_calculator", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getRecurrenceCalculator();
            }
        });
        m.put("recurrence_date_position", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getRecurrenceDatePosition();
            }
        });
        m.put("recurrence_id", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getRecurrenceID();
            }
        });
        m.put("recurrence_position", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getRecurrencePosition();
            }
        });
        m.put("recurrence_start", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getStartDate();
            }
        });
        m.put("recurrence_type", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getRecurrenceType();
            }
        });
        m.put("start_date", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getStartDate();
            }
        });
        m.put("title", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getTitle();
            }
        });
        m.put("until", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getUntil();
            }
        });
        m.put("users", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getUsers();
            }
        });
        m.put("categories", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getCategories();
            }
        });
        m.put("color_label", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getLabel();
            }
        });
        m.put("created_by", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getCreatedBy();
            }
        });
        m.put("creation_date", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getCreationDate();
            }
        });
        m.put("folder_id", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getParentFolderID();
            }
        });
        m.put("id", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getObjectID();
            }
        });
        m.put("last_modified", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getLastModified();
            }
        });
        m.put("modified_by", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getModifiedBy();
            }
        });
        m.put("private_flag", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getPrivateFlag();
            }
        });
        m.put("extended_properties", new AttributeGetter(){

            @Override
            public Object getObject(Task candidate) {
                return candidate.getExtendedProperties();
            }
        });
        GETTERS = Collections.unmodifiableMap(m);
        instance = new TaskAttributeFetcher();
    }

    private static interface AttributeGetter {
        public Object getObject(Task var1);
    }
}

