/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.impl.AbstractMailFuncs;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;

public class UnifiedInboxEnablement
implements PreferencesItemService {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UnifiedInboxEnablement.class));

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "unifiedinbox"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new AbstractMailFuncs(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            protected Boolean isSet(UserSettingMail settings) {
                UnifiedInboxManagement management;
                try {
                    management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class, true);
                }
                catch (OXException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    return Boolean.FALSE;
                }
                try {
                    return management.getUnifiedINBOXAccountID(settings.getUserId(), settings.getCid()) >= 0;
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    return Boolean.FALSE;
                }
            }

            @Override
            protected void setValue(UserSettingMail settings, String value) {
                UnifiedInboxManagement management;
                boolean enable = Boolean.parseBoolean(value);
                try {
                    management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class, true);
                }
                catch (OXException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)new StringBuilder().append(enable ? "Enabling" : "Disabling").append(" of Unified Mail for user ").append(settings.getUserId()).append(" in context ").append(settings.getCid()).append(" aborted: ").append(e.getMessage()), (Throwable)e);
                    }
                    return;
                }
                try {
                    int userId = settings.getUserId();
                    int cid = settings.getCid();
                    if (enable) {
                        if (management.getUnifiedINBOXAccountID(userId, cid) < 0) {
                            management.createUnifiedINBOX(userId, cid);
                        }
                    } else {
                        management.deleteUnifiedINBOX(userId, cid);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
    }
}

