/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.groupware.notify.State;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.tools.session.ServerSession;
import java.util.Locale;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class PooledNotification
implements Delayed {
    private static final long MSEC_DELAY = 120000L;
    private final AtomicLong stamp = new AtomicLong(System.currentTimeMillis());
    private final EmailableParticipant p;
    private State state;
    private Locale locale;
    private final ServerSession session;
    private final CalendarObject obj;
    private final RenderMap renderMap;
    private final int hash;
    private String title;

    public PooledNotification(EmailableParticipant p, String title, State state, Locale locale, RenderMap renderMap, ServerSession session, CalendarObject obj) {
        this.p = p;
        this.state = state;
        this.locale = locale;
        this.renderMap = renderMap;
        this.title = title;
        this.session = session;
        this.obj = obj;
        this.hash = this._hashCode();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(120000L - (System.currentTimeMillis() - this.stamp.get()), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long otherStamp;
        long thisStamp = this.stamp.get();
        return thisStamp < (otherStamp = ((PooledNotification)o).stamp.get()) ? -1 : (thisStamp == otherStamp ? 0 : 1);
    }

    public void touch() {
        this.stamp.set(System.currentTimeMillis());
    }

    public void merge(PooledNotification other) {
        this.title = other.title;
        this.locale = other.locale;
        this.state = other.state;
        this.renderMap.merge(other.renderMap);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setState(State state) {
        this.state = state;
    }

    public EmailableParticipant getParticipant() {
        return this.p;
    }

    public State getState() {
        return this.state;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public RenderMap getRenderMap() {
        return this.renderMap;
    }

    public String getTitle() {
        return this.title;
    }

    public ServerSession getSession() {
        return this.session;
    }

    public CalendarObject getCalendarObject() {
        return this.obj;
    }

    public long lastAccessed() {
        return this.stamp.get();
    }

    public boolean equalsByObject(int objectId, int contextId) {
        return this.obj.getObjectID() == objectId && this.session.getContextId() == contextId;
    }

    public int hashCode() {
        return this.hash;
    }

    private int _hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.session.getContextId();
        result = 31 * result + this.session.getUserId();
        result = 31 * result + this.obj.getObjectID();
        result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PooledNotification other = (PooledNotification)obj;
        if (this.session.getContextId() != other.session.getContextId()) {
            return false;
        }
        if (this.session.getUserId() != other.session.getUserId()) {
            return false;
        }
        if (this.obj.getObjectID() != other.obj.getObjectID()) {
            return false;
        }
        return !(this.p == null ? other.p != null : !this.p.equals(other.p));
    }
}

