/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.ReuseReadConProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.index.Attachment;
import com.openexchange.groupware.attach.index.AttachmentUUID;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreTimedResult;
import com.openexchange.groupware.infostore.database.InfostoreFilenameReservation;
import com.openexchange.groupware.infostore.database.InfostoreFilenameReserver;
import com.openexchange.groupware.infostore.database.impl.CheckSizeSwitch;
import com.openexchange.groupware.infostore.database.impl.CreateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.CreateVersionAction;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.infostore.database.impl.DeleteDocumentAction;
import com.openexchange.groupware.infostore.database.impl.DeleteVersionAction;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreIterator;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.database.impl.InsertDocumentIntoDelTableAction;
import com.openexchange.groupware.infostore.database.impl.SelectForUpdateFilenameReserver;
import com.openexchange.groupware.infostore.database.impl.UpdateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.UpdateVersionAction;
import com.openexchange.groupware.infostore.index.InfostoreUUID;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.groupware.infostore.validation.FilenamesMayNotContainSlashesValidator;
import com.openexchange.groupware.infostore.validation.InvalidCharactersValidator;
import com.openexchange.groupware.infostore.validation.ValidationChain;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.infostore.webdav.TouchInfoitemsWithExpiredLocksListener;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.index.IndexAccess;
import com.openexchange.index.IndexDocument;
import com.openexchange.index.IndexFacadeService;
import com.openexchange.index.StandardIndexDocument;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.SaveFileWithQuotaAction;
import com.openexchange.tools.iterator.CombinedSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SessionHolder;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InfostoreFacadeImpl
extends DBService
implements InfostoreFacade {
    private static final ValidationChain VALIDATION = new ValidationChain();
    private static final InfostoreFilenameReserver filenameReserver;
    static final org.apache.commons.logging.Log LOG;
    public static final InfostoreQueryCatalog QUERIES;
    private final DatabaseImpl db = new DatabaseImpl();
    private InfostoreSecurity security = new InfostoreSecurityImpl();
    private final EntityLockManager lockManager = new EntityLockManagerImpl("infostore_lock");
    private final ThreadLocal<List<String>> fileIdRemoveList = new ThreadLocal();
    private final ThreadLocal<Context> ctxHolder = new ThreadLocal();
    private final TouchInfoitemsWithExpiredLocksListener expiredLocksListener = new TouchInfoitemsWithExpiredLocksListener(null, this);
    private static final Pattern IS_NUMBERED_WITH_EXTENSION;
    private static final Pattern IS_NUMBERED;

    public InfostoreFacadeImpl() {
        this.lockManager.addExpiryListener(this.expiredLocksListener);
    }

    public InfostoreFacadeImpl(DBProvider provider) {
        this();
        this.setProvider(provider);
    }

    public void setSecurity(InfostoreSecurity security) {
        this.security = security;
        if (null != this.getProvider()) {
            this.setProvider(this.getProvider());
        }
    }

    @Override
    public boolean exists(int id, int version2, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        try {
            return this.security.getInfostorePermission(id, ctx, user, userConfig).canReadObject();
        }
        catch (OXException x) {
            if (InfostoreExceptionCodes.NOT_EXIST.equals(x)) {
                return false;
            }
            throw x;
        }
    }

    @Override
    public DocumentMetadata getDocumentMetadata(int id, int version2, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, ctx, user, userConfig);
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        List<Lock> locks = this.lockManager.findLocks(id, ctx, user, userConfig);
        HashMap<Integer, List<Lock>> allLocks = new HashMap<Integer, List<Lock>>();
        allLocks.put(id, locks);
        return this.addNumberOfVersions(this.addLocked(this.load(id, version2, ctx), allLocks, ctx, user, userConfig), ctx);
    }

    private DocumentMetadata load(int id, int version2, Context ctx) throws OXException {
        InfostoreIterator iter = InfostoreIterator.loadDocumentIterator(id, version2, this.getProvider(), ctx);
        if (!iter.hasNext()) {
            throw InfostoreExceptionCodes.DOCUMENT_NOT_EXIST.create();
        }
        DocumentMetadata dm = iter.next();
        iter.close();
        return dm;
    }

    @Override
    public void saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, ServerSession sessionObj) throws OXException {
        this.saveDocument(document, null, sequenceNumber, sessionObj);
    }

    @Override
    public void saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, Metadata[] modifiedColumns, ServerSession sessionObj) throws OXException {
        this.saveDocument(document, null, sequenceNumber, modifiedColumns, sessionObj);
    }

    @Override
    public InputStream getDocument(int id, int version2, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, ctx, user, userConfig);
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        DocumentMetadata dm = this.load(id, version2, ctx);
        QuotaFileStorage fs = this.getFileStorage(ctx);
        if (dm.getFilestoreLocation() != null) {
            return ((FileStorage)fs).getFile(dm.getFilestoreLocation());
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public void lock(int id, long diff, ServerSession sessionObj) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.WRITE_PERMS_FOR_LOCK_MISSING.create();
        }
        this.checkWriteLock(id, sessionObj);
        long timeout = 0L;
        timeout = timeout == -1L ? -1L : System.currentTimeMillis() + diff;
        this.lockManager.lock(id, timeout, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, sessionObj.getUserlogin(), sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        this.touch(id, sessionObj);
    }

    @Override
    public void unlock(int id, ServerSession sessionObj) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.WRITE_PERMS_FOR_UNLOCK_MISSING.create();
        }
        this.checkMayUnlock(id, sessionObj);
        this.lockManager.removeAll(id, sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        this.touch(id, sessionObj);
    }

    @Override
    public void touch(int id, ServerSession sessionObj) throws OXException {
        try {
            DocumentMetadata oldDocument = this.load(id, -1, sessionObj.getContext());
            DocumentMetadataImpl document = new DocumentMetadataImpl(oldDocument);
            document.setLastModified(new Date());
            document.setModifiedBy(sessionObj.getUserId());
            UpdateDocumentAction updateDocument = new UpdateDocumentAction();
            updateDocument.setContext(sessionObj.getContext());
            updateDocument.setDocuments(Arrays.asList(document));
            updateDocument.setModified(Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL);
            updateDocument.setOldDocuments(Arrays.asList(oldDocument));
            updateDocument.setProvider(this);
            updateDocument.setQueryCatalog(QUERIES);
            updateDocument.setTimestamp(oldDocument.getSequenceNumber());
            this.perform(updateDocument, true);
            UpdateVersionAction updateVersion = new UpdateVersionAction();
            updateVersion.setContext(sessionObj.getContext());
            updateVersion.setDocuments(Arrays.asList(document));
            updateVersion.setModified(Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL);
            updateVersion.setOldDocuments(Arrays.asList(oldDocument));
            updateVersion.setProvider(this);
            updateVersion.setQueryCatalog(QUERIES);
            updateVersion.setTimestamp(oldDocument.getSequenceNumber());
            this.perform(updateVersion, true);
        }
        catch (OXException x) {
            throw x;
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private Delta<DocumentMetadata> addLocked(Delta<DocumentMetadata> delta, Map<Integer, List<Lock>> locks, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        try {
            return new LockDelta(delta, locks, ctx, user, userConfig);
        }
        catch (OXException e) {
            throw InfostoreExceptionCodes.ITERATE_FAILED.create(e, new Object[0]);
        }
    }

    private Delta<DocumentMetadata> addNumberOfVersions(Delta<DocumentMetadata> delta, Context ctx) throws OXException {
        try {
            return new NumberOfVersionsDelta(delta, ctx);
        }
        catch (OXException e) {
            throw InfostoreExceptionCodes.ITERATE_FAILED.create(e, new Object[0]);
        }
    }

    private TimedResult<DocumentMetadata> addNumberOfVersions(TimedResult<DocumentMetadata> tr, Context ctx) throws OXException {
        return new NumberOfVersionsTimedResult(tr, ctx);
    }

    private TimedResult<DocumentMetadata> addLocked(TimedResult<DocumentMetadata> tr, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        try {
            return new LockTimedResult(tr, ctx, user, userConfig);
        }
        catch (OXException e) {
            throw InfostoreExceptionCodes.ITERATE_FAILED.create(e, new Object[0]);
        }
    }

    private DocumentMetadata addNumberOfVersions(final DocumentMetadata document, Context ctx) throws OXException {
        try {
            return this.performQuery(ctx, QUERIES.getNumberOfVersionsQueryForOneDocument(), new ResultProcessor<DocumentMetadata>(){

                @Override
                public DocumentMetadata process(ResultSet rs) throws SQLException {
                    if (!rs.next()) {
                        LOG.error((Object)"Infoitem disappeared when trying to count versions");
                        return document;
                    }
                    int numberOfVersions = rs.getInt(1);
                    document.setNumberOfVersions(--numberOfVersions);
                    return document;
                }
            }, document.getId(), ctx.getContextId());
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw InfostoreExceptionCodes.NUMBER_OF_VERSIONS_FAILED.create(e, Autoboxing.I((int)document.getId()), Autoboxing.I((int)ctx.getContextId()), QUERIES.getNumberOfVersionsQueryForOneDocument());
        }
    }

    private DocumentMetadata addLocked(DocumentMetadata document, Map<Integer, List<Lock>> allLocks, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        List<Lock> locks = null;
        locks = allLocks != null ? allLocks.get(document.getId()) : this.lockManager.findLocks(document.getId(), ctx, user, userConfig);
        if (locks == null) {
            locks = Collections.emptyList();
        }
        long max = 0L;
        for (Lock l : locks) {
            if (l.getTimeout() <= max) continue;
            max = l.getTimeout();
        }
        if (max > 0L) {
            document.setLockedUntil(new Date(System.currentTimeMillis() + max));
        }
        return document;
    }

    SearchIterator<DocumentMetadata> numberOfVersionsIterator(SearchIterator<?> iter, Context ctx) throws OXException {
        ArrayList<DocumentMetadata> list = new ArrayList<DocumentMetadata>();
        while (iter.hasNext()) {
            DocumentMetadata m = (DocumentMetadata)iter.next();
            list.add(m);
        }
        for (DocumentMetadata m : list) {
            this.addNumberOfVersions(m, ctx);
        }
        return new SearchIteratorAdapter(list.iterator());
    }

    SearchIterator<DocumentMetadata> lockedUntilIterator(SearchIterator<?> iter, Map<Integer, List<Lock>> locks, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        ArrayList<DocumentMetadata> list = new ArrayList<DocumentMetadata>();
        while (iter.hasNext()) {
            DocumentMetadata m = (DocumentMetadata)iter.next();
            list.add(m);
        }
        for (DocumentMetadata m : list) {
            this.addLocked(m, locks, ctx, user, userConfig);
        }
        return new SearchIteratorAdapter(list.iterator());
    }

    private DocumentMetadata checkWriteLock(int id, ServerSession sessionObj) throws OXException {
        DocumentMetadata document = this.load(id, -1, sessionObj.getContext());
        this.checkWriteLock(document, sessionObj);
        return document;
    }

    private void checkWriteLock(DocumentMetadata document, ServerSession sessionObj) throws OXException {
        if (document.getModifiedBy() == sessionObj.getUserId()) {
            return;
        }
        if (this.lockManager.isLocked(document.getId(), sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj))) {
            throw InfostoreExceptionCodes.ALREADY_LOCKED.create();
        }
    }

    private void checkMayUnlock(int id, ServerSession sessionObj) throws OXException {
        DocumentMetadata document = this.load(id, -1, sessionObj.getContext());
        if (document.getCreatedBy() == sessionObj.getUserId() || document.getModifiedBy() == sessionObj.getUserId()) {
            return;
        }
        List<Lock> locks = this.lockManager.findLocks(id, sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        if (locks.size() > 0) {
            throw InfostoreExceptionCodes.LOCKED_BY_ANOTHER.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, ServerSession sessionObj) throws OXException {
        this.security.checkFolderId(document.getFolderId(), sessionObj.getContext());
        boolean wasCreation = false;
        if (document.getId() == -1) {
            wasCreation = true;
            EffectivePermission isperm = this.security.getFolderPermission(document.getFolderId(), sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
            if (!isperm.canCreateObjects()) {
                throw InfostoreExceptionCodes.NO_CREATE_PERMISSION.create();
            }
            this.setDefaults(document);
            VALIDATION.validate(document);
            CheckSizeSwitch.checkSizes(document, this.getProvider(), sessionObj.getContext());
            boolean titleAlso = document.getFileName() != null && document.getTitle() != null && document.getFileName().equals(document.getTitle());
            InfostoreFilenameReservation reservation = this.reserve(document.getFileName(), document.getFolderId(), document.getId(), sessionObj.getContext(), true);
            document.setFileName(reservation.getFilename());
            if (titleAlso) {
                document.setTitle(reservation.getFilename());
            }
            try {
                Connection writeCon = null;
                try {
                    this.startDBTransaction();
                    writeCon = this.getWriteConnection(sessionObj.getContext());
                    document.setId(this.getId(sessionObj.getContext(), writeCon));
                    this.commitDBTransaction();
                }
                catch (SQLException e) {
                    throw InfostoreExceptionCodes.NEW_ID_FAILED.create(e, new Object[0]);
                }
                finally {
                    this.releaseWriteConnection(sessionObj.getContext(), writeCon);
                    try {
                        this.finishDBTransaction();
                    }
                    catch (OXException e) {
                        throw new OXException(e);
                    }
                }
                document.setCreationDate(new Date(System.currentTimeMillis()));
                document.setLastModified(document.getCreationDate());
                document.setCreatedBy(sessionObj.getUserId());
                document.setModifiedBy(sessionObj.getUserId());
                if (null != data) {
                    document.setVersion(1);
                } else {
                    document.setVersion(0);
                }
                CreateDocumentAction createAction = new CreateDocumentAction();
                createAction.setContext(sessionObj.getContext());
                createAction.setDocuments(Arrays.asList(document));
                createAction.setProvider(this);
                createAction.setQueryCatalog(QUERIES);
                this.perform(createAction, true);
                DocumentMetadataImpl version0 = new DocumentMetadataImpl(document);
                version0.setFileName(null);
                version0.setFileSize(0L);
                version0.setFileMD5Sum(null);
                version0.setFileMIMEType(null);
                version0.setVersion(0);
                version0.setFilestoreLocation(null);
                CreateVersionAction createVersionAction = new CreateVersionAction();
                createVersionAction.setContext(sessionObj.getContext());
                createVersionAction.setDocuments(Arrays.asList(version0));
                createVersionAction.setProvider(this);
                createVersionAction.setQueryCatalog(QUERIES);
                this.perform(createVersionAction, true);
                if (data != null) {
                    SaveFileWithQuotaAction saveFile = new SaveFileWithQuotaAction();
                    QuotaFileStorage qfs = this.getFileStorage(sessionObj.getContext());
                    saveFile.setStorage(qfs);
                    saveFile.setSizeHint(document.getFileSize());
                    saveFile.setIn(data);
                    this.perform(saveFile, false);
                    document.setVersion(1);
                    document.setFilestoreLocation(saveFile.getId());
                    if (document.getFileSize() == 0L) {
                        document.setFileSize(qfs.getFileSize(saveFile.getId()));
                    }
                    createVersionAction = new CreateVersionAction();
                    createVersionAction.setContext(sessionObj.getContext());
                    createVersionAction.setDocuments(Arrays.asList(document));
                    createVersionAction.setProvider(this);
                    createVersionAction.setQueryCatalog(QUERIES);
                    this.perform(createVersionAction, true);
                }
                this.indexDocument(sessionObj.getContext(), sessionObj.getUserId(), document.getId(), -1L, wasCreation);
            }
            finally {
                if (reservation != null) {
                    reservation.destroySilently();
                }
            }
        }
        this.saveDocument(document, data, sequenceNumber, this.nonNull(document), sessionObj);
    }

    private void setDefaults(DocumentMetadata document) {
        if (document.getTitle() == null || "".equals(document.getTitle())) {
            document.setTitle(document.getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T performQuery(Context ctx, String query, ResultProcessor<T> rsp, Object ... args) throws SQLException, OXException {
        T t;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            rs = stmt.executeQuery();
            t = rsp.process(rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            if (readCon != null) {
                this.releaseReadConnection(ctx, readCon);
            }
            throw throwable;
        }
        this.close(stmt, rs);
        if (readCon != null) {
            this.releaseReadConnection(ctx, readCon);
        }
        return t;
    }

    private int getNextVersionNumberForInfostoreObject(int cid, int infostore_id, Connection con) throws SQLException {
        int delVersion;
        int retval = 0;
        PreparedStatement stmt = con.prepareStatement("SELECT MAX(version_number) FROM infostore_document WHERE cid=? AND infostore_id=?");
        stmt.setInt(1, cid);
        stmt.setInt(2, infostore_id);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            retval = result.getInt(1);
        }
        result.close();
        stmt.close();
        stmt = con.prepareStatement("SELECT MAX(version_number) FROM del_infostore_document WHERE cid=? AND infostore_id=?");
        stmt.setInt(1, cid);
        stmt.setInt(2, infostore_id);
        result = stmt.executeQuery();
        if (result.next() && (delVersion = result.getInt(1)) > retval) {
            retval = delVersion;
        }
        result.close();
        stmt.close();
        return retval + 1;
    }

    private InfostoreFilenameReservation reserve(String filename, long folderId, int id, Context ctx, boolean adjust) throws OXException {
        return this.reserve(filename, folderId, id, ctx, adjust ? 0 : -1);
    }

    private InfostoreFilenameReservation reserve(String filename, long folderId, int id, Context ctx, int count) throws OXException {
        InfostoreFilenameReservation reservation = null;
        try {
            reservation = filenameReserver.reserveFilename(filename, folderId, id, ctx, this);
            if (reservation == null) {
                if (count == -1) {
                    throw InfostoreExceptionCodes.FILENAME_NOT_UNIQUE.create(filename, "");
                }
                InfostoreFilenameReservation r = this.reserve(this.enhance(filename, ++count), folderId, id, ctx, count);
                r.setWasAdjusted(true);
                return r;
            }
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, "");
        }
        return reservation;
    }

    private String enhance(String filename, int c) {
        StringBuilder stringBuilder = new StringBuilder(filename);
        Matcher matcher = IS_NUMBERED_WITH_EXTENSION.matcher(filename);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            stringBuilder.replace(start, end - 1, "(" + c + ")");
            return stringBuilder.toString();
        }
        matcher = IS_NUMBERED.matcher(filename);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            stringBuilder.replace(start, end, "(" + c + ")");
            return stringBuilder.toString();
        }
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            index = filename.length();
        }
        stringBuilder.insert(index, "(" + c + ")");
        return stringBuilder.toString();
    }

    protected QuotaFileStorage getFileStorage(Context ctx) throws OXException {
        return QuotaFileStorage.getInstance(FilestoreStorage.createURI(ctx), ctx);
    }

    private Metadata[] nonNull(DocumentMetadata document) {
        ArrayList<Metadata> nonNull = new ArrayList<Metadata>();
        GetSwitch get = new GetSwitch(document);
        for (Metadata metadata : Metadata.HTTPAPI_VALUES) {
            if (null == metadata.doSwitch(get)) continue;
            nonNull.add(metadata);
        }
        return nonNull.toArray(new Metadata[nonNull.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, ServerSession sessionObj) throws OXException {
        if (document.getId() == -1) {
            this.saveDocument(document, data, sequenceNumber, sessionObj);
            this.indexDocument(sessionObj.getContext(), sessionObj.getContextId(), document.getId(), -1L, true);
            return;
        }
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(document.getId(), sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.NO_WRITE_PERMISSION.create();
        }
        if (Arrays.asList(modifiedColumns).contains(Metadata.FOLDER_ID_LITERAL) && document.getFolderId() != -1L && infoPerm.getObject().getFolderId() != document.getFolderId()) {
            this.security.checkFolderId(document.getFolderId(), sessionObj.getContext());
            EffectivePermission isperm = this.security.getFolderPermission(document.getFolderId(), sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
            if (!isperm.canCreateObjects()) {
                throw InfostoreExceptionCodes.NO_TARGET_CREATE_PERMISSION.create();
            }
            if (!infoPerm.canDeleteObject()) {
                throw InfostoreExceptionCodes.NO_SOURCE_DELETE_PERMISSION.create();
            }
        }
        CheckSizeSwitch.checkSizes(document, this.getProvider(), sessionObj.getContext());
        DocumentMetadata oldDocument = this.checkWriteLock(document.getId(), sessionObj);
        HashSet<Metadata> updatedCols = new HashSet<Metadata>(Arrays.asList(modifiedColumns));
        if (!updatedCols.contains(Metadata.LAST_MODIFIED_LITERAL)) {
            document.setLastModified(new Date());
        }
        document.setModifiedBy(sessionObj.getUserId());
        VALIDATION.validate(document);
        updatedCols.add(Metadata.LAST_MODIFIED_LITERAL);
        updatedCols.add(Metadata.MODIFIED_BY_LITERAL);
        ArrayList<InfostoreFilenameReservation> reservations = new ArrayList<InfostoreFilenameReservation>(2);
        try {
            if (updatedCols.contains(Metadata.VERSION_LITERAL)) {
                String fname = this.load(document.getId(), document.getVersion(), sessionObj.getContext()).getFileName();
                if (!updatedCols.contains(Metadata.FILENAME_LITERAL)) {
                    updatedCols.add(Metadata.FILENAME_LITERAL);
                    document.setFileName(fname);
                }
            }
            String oldFileName = oldDocument.getFileName();
            if (document.getFileName() != null && !document.getFileName().equals(oldFileName)) {
                InfostoreFilenameReservation reservation = this.reserve(document.getFileName(), oldDocument.getFolderId(), oldDocument.getId(), sessionObj.getContext(), true);
                reservations.add(reservation);
                document.setFileName(reservation.getFilename());
                updatedCols.add(Metadata.FILENAME_LITERAL);
            }
            String oldTitle = oldDocument.getTitle();
            if (!updatedCols.contains(Metadata.TITLE_LITERAL) && oldFileName != null && oldTitle != null && oldFileName.equals(oldTitle)) {
                String fileName = document.getFileName();
                if (null == fileName) {
                    document.setTitle(oldFileName);
                    document.setFileName(oldFileName);
                    updatedCols.add(Metadata.FILENAME_LITERAL);
                } else {
                    document.setTitle(fileName);
                }
                updatedCols.add(Metadata.TITLE_LITERAL);
            }
            modifiedColumns = updatedCols.toArray(new Metadata[updatedCols.size()]);
            if (data != null) {
                SaveFileWithQuotaAction saveFile = new SaveFileWithQuotaAction();
                QuotaFileStorage qfs = this.getFileStorage(sessionObj.getContext());
                saveFile.setStorage(qfs);
                saveFile.setSizeHint(document.getFileSize());
                saveFile.setIn(data);
                this.perform(saveFile, false);
                document.setFilestoreLocation(saveFile.getId());
                if (document.getFileSize() == 0L) {
                    document.setFileSize(qfs.getFileSize(saveFile.getId()));
                }
                GetSwitch get = new GetSwitch(oldDocument);
                SetSwitch set = new SetSwitch(document);
                HashSet<Metadata> alreadySet = new HashSet<Metadata>(Arrays.asList(modifiedColumns));
                for (Metadata m : Arrays.asList(Metadata.DESCRIPTION_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL)) {
                    if (alreadySet.contains(m)) continue;
                    set.setValue(m.doSwitch(get));
                    m.doSwitch(set);
                }
                document.setCreatedBy(sessionObj.getUserId());
                document.setCreationDate(new Date());
                Connection con = null;
                try {
                    con = this.getReadConnection(sessionObj.getContext());
                    document.setVersion(this.getNextVersionNumberForInfostoreObject(sessionObj.getContext().getContextId(), document.getId(), con));
                    updatedCols.add(Metadata.VERSION_LITERAL);
                }
                catch (SQLException e) {
                    LOG.error((Object)"SQLException: ", (Throwable)e);
                }
                finally {
                    this.releaseReadConnection(sessionObj.getContext(), con);
                }
                CreateVersionAction createVersionAction = new CreateVersionAction();
                createVersionAction.setContext(sessionObj.getContext());
                createVersionAction.setDocuments(Arrays.asList(document));
                createVersionAction.setProvider(this);
                createVersionAction.setQueryCatalog(QUERIES);
                this.perform(createVersionAction, true);
            } else if (QUERIES.updateVersion(modifiedColumns)) {
                if (!updatedCols.contains(Metadata.VERSION_LITERAL)) {
                    document.setVersion(oldDocument.getVersion());
                }
                UpdateVersionAction updateVersionAction = new UpdateVersionAction();
                updateVersionAction.setContext(sessionObj.getContext());
                updateVersionAction.setDocuments(Arrays.asList(document));
                updateVersionAction.setOldDocuments(Arrays.asList(oldDocument));
                updateVersionAction.setProvider(this);
                updateVersionAction.setQueryCatalog(QUERIES);
                updateVersionAction.setModified(modifiedColumns);
                updateVersionAction.setTimestamp(sequenceNumber);
                this.perform(updateVersionAction, true);
            }
            modifiedColumns = updatedCols.toArray(new Metadata[updatedCols.size()]);
            if (QUERIES.updateDocument(modifiedColumns)) {
                UpdateDocumentAction updateAction = new UpdateDocumentAction();
                updateAction.setContext(sessionObj.getContext());
                updateAction.setDocuments(Arrays.asList(document));
                updateAction.setOldDocuments(Arrays.asList(oldDocument));
                updateAction.setProvider(this);
                updateAction.setQueryCatalog(QUERIES);
                updateAction.setModified(modifiedColumns);
                updateAction.setTimestamp(Long.MAX_VALUE);
                this.perform(updateAction, true);
            }
            long indexFolderId = document.getFolderId() == oldDocument.getFolderId() ? -1L : oldDocument.getFolderId();
            this.indexDocument(sessionObj.getContext(), sessionObj.getUserId(), oldDocument.getId(), indexFolderId, false);
        }
        finally {
            for (InfostoreFilenameReservation infostoreFilenameReservation : reservations) {
                infostoreFilenameReservation.destroySilently();
            }
        }
    }

    @Override
    public void removeDocument(long folderId, long date, ServerSession sessionObj) throws OXException {
        ReuseReadConProvider reuseProvider = new ReuseReadConProvider(this.getProvider());
        try {
            List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere("infostore.folder_id = " + folderId, Metadata.VALUES_ARRAY, reuseProvider, sessionObj.getContext()).asList();
            List<DocumentMetadata> allDocuments = InfostoreIterator.allDocumentsWhere("infostore.folder_id = " + folderId, Metadata.VALUES_ARRAY, reuseProvider, sessionObj.getContext()).asList();
            this.removeDocuments(allDocuments, allVersions, date, sessionObj, null);
        }
        catch (OXException x) {
            throw new OXException(x);
        }
    }

    private void removeDocuments(List<DocumentMetadata> allDocuments, List<DocumentMetadata> allVersions, long date, ServerSession sessionObj, List<DocumentMetadata> rejected) throws OXException {
        ArrayList<DocumentMetadata> delDocs = new ArrayList<DocumentMetadata>();
        ArrayList<DocumentMetadata> delVers = new ArrayList<DocumentMetadata>();
        HashSet<Integer> rejectedIds = new HashSet<Integer>();
        Date now = new Date();
        for (DocumentMetadata m : allDocuments) {
            if (m.getSequenceNumber() > date) {
                if (rejected == null) {
                    throw InfostoreExceptionCodes.NOT_ALL_DELETED.create();
                }
                rejected.add(m);
                rejectedIds.add(m.getId());
                continue;
            }
            this.checkWriteLock(m, sessionObj);
            m.setLastModified(now);
            delDocs.add(m);
        }
        InsertDocumentIntoDelTableAction insertIntoDel = new InsertDocumentIntoDelTableAction();
        insertIntoDel.setContext(sessionObj.getContext());
        insertIntoDel.setDocuments(delDocs);
        insertIntoDel.setProvider(this);
        insertIntoDel.setQueryCatalog(QUERIES);
        this.perform(insertIntoDel, true);
        for (DocumentMetadata m : allVersions) {
            if (rejectedIds.contains(m.getId())) continue;
            delVers.add(m);
            m.setLastModified(now);
            this.removeFile(sessionObj.getContext(), m.getFilestoreLocation());
        }
        DeleteVersionAction deleteVersion = new DeleteVersionAction();
        deleteVersion.setContext(sessionObj.getContext());
        deleteVersion.setDocuments(delVers);
        deleteVersion.setProvider(this);
        deleteVersion.setQueryCatalog(QUERIES);
        this.perform(deleteVersion, true);
        DeleteDocumentAction deleteDocument = new DeleteDocumentAction();
        deleteDocument.setContext(sessionObj.getContext());
        deleteDocument.setDocuments(delDocs);
        deleteDocument.setProvider(this);
        deleteDocument.setQueryCatalog(QUERIES);
        this.perform(deleteDocument, true);
        this.removeFromIndex(sessionObj.getContext(), sessionObj.getUserId(), delDocs);
        this.removeFromIndex(sessionObj.getContext(), sessionObj.getUserId(), delVers);
    }

    private void removeFile(Context context, String filestoreLocation) throws OXException {
        if (filestoreLocation == null) {
            return;
        }
        if (this.fileIdRemoveList.get() != null) {
            this.fileIdRemoveList.get().add(filestoreLocation);
            this.ctxHolder.set(context);
        } else {
            try {
                QuotaFileStorage qfs = this.getFileStorage(context);
                qfs.deleteFile(filestoreLocation);
            }
            catch (OXException x) {
                throw new OXException(x);
            }
        }
    }

    @Override
    public int[] removeDocument(int[] id, long date, ServerSession sessionObj) throws OXException {
        StringBuilder ids = new StringBuilder().append('(');
        for (int i : id) {
            ids.append(i).append(',');
        }
        ids.setLength(ids.length() - 1);
        ids.append(')');
        List<DocumentMetadata> allVersions = null;
        List<DocumentMetadata> allDocuments = null;
        ReuseReadConProvider reuseProvider = new ReuseReadConProvider(this.getProvider());
        try {
            allVersions = InfostoreIterator.allVersionsWhere("infostore.id IN " + ids.toString(), Metadata.VALUES_ARRAY, reuseProvider, sessionObj.getContext()).asList();
            allDocuments = InfostoreIterator.allDocumentsWhere("infostore.id IN " + ids.toString(), Metadata.VALUES_ARRAY, reuseProvider, sessionObj.getContext()).asList();
        }
        catch (OXException x) {
            throw new OXException(x);
        }
        catch (Throwable t) {
            LOG.error((Object)"Unexpected Error:", t);
        }
        ArrayList<DocumentMetadata> rejected = new ArrayList<DocumentMetadata>();
        HashSet rejectedIds = new HashSet();
        HashSet<Integer> idSet = new HashSet<Integer>();
        for (int i : id) {
            idSet.add(i);
        }
        TLongObjectHashMap perms = new TLongObjectHashMap();
        ArrayList<DocumentMetadata> toDeleteDocs = new ArrayList<DocumentMetadata>();
        ArrayList<DocumentMetadata> toDeleteVersions = new ArrayList<DocumentMetadata>();
        if (allDocuments != null) {
            for (DocumentMetadata m : allDocuments) {
                EffectiveInfostorePermission infoPerm;
                idSet.remove(m.getId());
                EffectivePermission p = (EffectivePermission)perms.get(m.getFolderId());
                if (p == null) {
                    p = this.security.getFolderPermission(m.getFolderId(), sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
                    perms.put(m.getFolderId(), (Object)p);
                }
                if (!(infoPerm = new EffectiveInfostorePermission(p, m, InfostoreFacadeImpl.getUser(sessionObj))).canDeleteObject()) {
                    throw InfostoreExceptionCodes.NO_DELETE_PERMISSION.create();
                }
                toDeleteDocs.add(m);
            }
        }
        if (allVersions != null) {
            for (DocumentMetadata m : allVersions) {
                if (rejectedIds.contains(m.getId())) continue;
                toDeleteVersions.add(m);
            }
        }
        this.removeDocuments(toDeleteDocs, toDeleteVersions, date, sessionObj, rejected);
        int[] nd = new int[rejected.size() + idSet.size()];
        int i = 0;
        for (DocumentMetadata rej : rejected) {
            nd[i++] = rej.getId();
        }
        Iterator i$ = idSet.iterator();
        while (i$.hasNext()) {
            int notFound = (Integer)i$.next();
            nd[i++] = notFound;
        }
        return nd;
    }

    @Override
    public int[] removeVersion(int id, int[] versionId, ServerSession sessionObj) throws OXException {
        if (versionId.length <= 0) {
            return versionId;
        }
        DocumentMetadata metadata = this.load(id, -1, sessionObj.getContext());
        try {
            this.checkWriteLock(metadata, sessionObj);
        }
        catch (OXException x) {
            return versionId;
        }
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(metadata, sessionObj.getContext(), InfostoreFacadeImpl.getUser(sessionObj), InfostoreFacadeImpl.getUserConfiguration(sessionObj));
        if (!infoPerm.canDeleteObject()) {
            throw InfostoreExceptionCodes.NO_DELETE_PERMISSION_FOR_VERSION.create();
        }
        StringBuilder versions = new StringBuilder().append('(');
        HashSet<Integer> versionSet = new HashSet<Integer>();
        for (int v : versionId) {
            versions.append(v).append(',');
            versionSet.add(v);
        }
        versions.setLength(versions.length() - 1);
        versions.append(')');
        List<DocumentMetadata> allVersions = null;
        allVersions = InfostoreIterator.allVersionsWhere("infostore_document.infostore_id = " + id + " AND infostore_document.version_number IN " + versions.toString() + " and infostore_document.version_number != 0 ", Metadata.VALUES_ARRAY, this, sessionObj.getContext()).asList();
        Date now = new Date();
        boolean removeCurrent = false;
        for (DocumentMetadata v : allVersions) {
            if (v.getVersion() == metadata.getVersion()) {
                removeCurrent = true;
            }
            versionSet.remove(v.getVersion());
            v.setLastModified(now);
            this.removeFile(sessionObj.getContext(), v.getFilestoreLocation());
        }
        DocumentMetadataImpl update = new DocumentMetadataImpl(metadata);
        update.setLastModified(now);
        update.setModifiedBy(sessionObj.getUserId());
        HashSet<Metadata> updatedFields = new HashSet<Metadata>();
        updatedFields.add(Metadata.LAST_MODIFIED_LITERAL);
        updatedFields.add(Metadata.MODIFIED_BY_LITERAL);
        if (removeCurrent) {
            DocumentMetadata oldVersion0 = this.load(id, 0, sessionObj.getContext());
            DocumentMetadataImpl version0 = new DocumentMetadataImpl(metadata);
            version0.setVersion(0);
            version0.setFileMIMEType("");
            UpdateVersionAction updateVersion = new UpdateVersionAction();
            updateVersion.setContext(sessionObj.getContext());
            updateVersion.setDocuments(Arrays.asList(version0));
            updateVersion.setModified(Metadata.DESCRIPTION_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.FILE_MIMETYPE_LITERAL);
            updateVersion.setOldDocuments(Arrays.asList(oldVersion0));
            updateVersion.setProvider(this);
            updateVersion.setQueryCatalog(QUERIES);
            updateVersion.setTimestamp(Long.MAX_VALUE);
            this.perform(updateVersion, true);
            update.setVersion(this.db.getMaxActiveVersion(metadata.getId(), sessionObj.getContext(), allVersions));
            updatedFields.add(Metadata.VERSION_LITERAL);
        }
        if (removeCurrent) {
            InfostoreFilenameReservation reservation = this.reserve((metadata = this.load(metadata.getId(), update.getVersion(), sessionObj.getContext())).getFileName(), metadata.getFolderId(), metadata.getId(), sessionObj.getContext(), true);
            if (reservation.wasAdjusted()) {
                update.setFileName(reservation.getFilename());
                updatedFields.add(Metadata.FILENAME_LITERAL);
            }
            if (metadata.getTitle().equals(metadata.getFileName())) {
                update.setTitle(update.getFileName());
                updatedFields.add(Metadata.TITLE_LITERAL);
            }
        }
        UpdateDocumentAction updateDocument = new UpdateDocumentAction();
        updateDocument.setContext(sessionObj.getContext());
        updateDocument.setDocuments(Arrays.asList(update));
        updateDocument.setModified(updatedFields.toArray(new Metadata[updatedFields.size()]));
        updateDocument.setOldDocuments(Arrays.asList(metadata));
        updateDocument.setProvider(this);
        updateDocument.setQueryCatalog(QUERIES);
        updateDocument.setTimestamp(Long.MAX_VALUE);
        this.perform(updateDocument, true);
        DeleteVersionAction deleteVersion = new DeleteVersionAction();
        deleteVersion.setContext(sessionObj.getContext());
        deleteVersion.setDocuments(allVersions);
        deleteVersion.setProvider(this);
        deleteVersion.setQueryCatalog(QUERIES);
        this.perform(deleteVersion, true);
        int[] retval = new int[versionSet.size()];
        int i = 0;
        for (Integer integer : versionSet) {
            retval[i++] = integer;
        }
        if (removeCurrent) {
            this.removeFromIndex(sessionObj.getContext(), sessionObj.getUserId(), Collections.singletonList(metadata));
            this.indexDocument(sessionObj.getContext(), sessionObj.getUserId(), id, -1L, true);
        }
        return retval;
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getDocuments(folderId, Metadata.HTTPAPI_VALUES_ARRAY, null, 0, ctx, user, userConfig);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getDocuments(folderId, columns, null, 0, ctx, user, userConfig);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Metadata sort, int order, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        columns = this.addLastModifiedIfNeeded(columns);
        boolean onlyOwn = false;
        EffectivePermission isperm = this.security.getFolderPermission(folderId, ctx, user, userConfig);
        if (isperm.getReadPermission() == 0) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (isperm.getReadPermission() == 2) {
            onlyOwn = true;
        }
        boolean addLocked = false;
        boolean addNumberOfVersions = false;
        for (Metadata m : columns) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                addLocked = true;
                break;
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            addNumberOfVersions = true;
            break;
        }
        InfostoreIterator iter = null;
        iter = onlyOwn ? InfostoreIterator.documentsByCreator(folderId, user.getId(), columns, sort, order, this.getProvider(), ctx) : InfostoreIterator.documents(folderId, columns, sort, order, this.getProvider(), ctx);
        TimedResult<DocumentMetadata> tr = new TimedResult<DocumentMetadata>((SearchIterator<DocumentMetadata>)iter);
        if (addLocked) {
            tr = this.addLocked(tr, ctx, user, userConfig);
        }
        if (addNumberOfVersions) {
            tr = this.addNumberOfVersions(tr, ctx);
        }
        return tr;
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getVersions(id, Metadata.HTTPAPI_VALUES_ARRAY, null, 0, ctx, user, userConfig);
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getVersions(id, columns, null, 0, ctx, user, userConfig);
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, Metadata sort, int order, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(id, ctx, user, userConfig);
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        boolean addLocked = false;
        for (Metadata m : columns) {
            if (m != Metadata.LOCKED_UNTIL_LITERAL) continue;
            addLocked = true;
            break;
        }
        columns = this.addLastModifiedIfNeeded(columns);
        InfostoreIterator iter = InfostoreIterator.versions(id, columns, sort, order, this.getProvider(), ctx);
        InfostoreTimedResult tr = new InfostoreTimedResult(iter);
        if (addLocked) {
            return this.addLocked((TimedResult<DocumentMetadata>)tr, ctx, user, userConfig);
        }
        return tr;
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(int[] ids, Metadata[] columns, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        try {
            this.security.injectInfostorePermissions(ids, ctx, user, userConfig, null, new Injector<Object, EffectiveInfostorePermission>(){

                @Override
                public Object inject(Object list, EffectiveInfostorePermission element) {
                    if (!element.canReadObject()) {
                        throw new NotAllowed(element.getObjectID());
                    }
                    return list;
                }
            });
        }
        catch (NotAllowed na) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        columns = this.addLastModifiedIfNeeded(columns);
        InfostoreIterator iter = InfostoreIterator.list(ids, columns, this.getProvider(), ctx);
        TimedResult<DocumentMetadata> tr = new TimedResult<DocumentMetadata>((SearchIterator<DocumentMetadata>)iter);
        for (Metadata m : columns) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                tr = this.addLocked(tr, ctx, user, userConfig);
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            tr = this.addNumberOfVersions(tr, ctx);
        }
        return tr;
    }

    @Override
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, boolean ignoreDeleted, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getDelta(folderId, updateSince, columns, null, 0, ignoreDeleted, ctx, user, userConfig);
    }

    @Override
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, Metadata sort, int order, boolean ignoreDeleted, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        boolean onlyOwn = false;
        EffectivePermission isperm = this.security.getFolderPermission(folderId, ctx, user, userConfig);
        if (isperm.getReadPermission() == 0) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (isperm.getReadPermission() == 2) {
            onlyOwn = true;
        }
        boolean addLocked = false;
        boolean addNumberOfVersions = false;
        for (Metadata m : columns) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                addLocked = true;
                break;
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            addNumberOfVersions = true;
            break;
        }
        Map<Integer, List<Lock>> locks = this.loadLocksInFolderAndExpireOldLocks(folderId, ctx, user, userConfig);
        ReuseReadConProvider reuse = new ReuseReadConProvider(this.getProvider());
        InfostoreIterator newIter = null;
        InfostoreIterator modIter = null;
        InfostoreIterator delIter = null;
        columns = this.addLastModifiedIfNeeded(columns);
        if (onlyOwn) {
            newIter = InfostoreIterator.newDocumentsByCreator(folderId, user.getId(), columns, sort, order, updateSince, reuse, ctx);
            modIter = InfostoreIterator.modifiedDocumentsByCreator(folderId, user.getId(), columns, sort, order, updateSince, reuse, ctx);
            if (!ignoreDeleted) {
                delIter = InfostoreIterator.deletedDocumentsByCreator(folderId, user.getId(), sort, order, updateSince, reuse, ctx);
            }
        } else {
            newIter = InfostoreIterator.newDocuments(folderId, columns, sort, order, updateSince, reuse, ctx);
            modIter = InfostoreIterator.modifiedDocuments(folderId, columns, sort, order, updateSince, reuse, ctx);
            if (!ignoreDeleted) {
                delIter = InfostoreIterator.deletedDocuments(folderId, sort, order, updateSince, reuse, ctx);
            }
        }
        Object it = ignoreDeleted ? SearchIteratorAdapter.emptyIterator() : delIter;
        Delta<DocumentMetadata> delta = new Delta<DocumentMetadata>((SearchIterator)newIter, (SearchIterator)modIter, it, System.currentTimeMillis());
        if (addLocked) {
            delta = this.addLocked(delta, locks, ctx, user, userConfig);
        }
        if (addNumberOfVersions) {
            delta = this.addNumberOfVersions(delta, ctx);
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, List<Lock>> loadLocksInFolderAndExpireOldLocks(long folderId, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        HashMap<Integer, List<Lock>> locks = new HashMap<Integer, List<Lock>>();
        InfostoreIterator documents = InfostoreIterator.documents(folderId, new Metadata[]{Metadata.ID_LITERAL}, null, -1, this.getProvider(), ctx);
        try {
            while (documents.hasNext()) {
                DocumentMetadata document = documents.next();
                this.lockManager.findLocks(document.getId(), ctx, user, userConfig);
            }
        }
        finally {
            documents.close();
        }
        return locks;
    }

    @Override
    public int countDocuments(long folderId, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        boolean onlyOwn = false;
        EffectivePermission isperm = this.security.getFolderPermission(folderId, ctx, user, userConfig);
        if (!isperm.canReadAllObjects() && !isperm.canReadOwnObjects()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (isperm.canReadOwnObjects()) {
            onlyOwn = true;
        }
        return this.db.countDocuments(folderId, onlyOwn, ctx, user);
    }

    @Override
    public boolean hasFolderForeignObjects(long folderId, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.db.hasFolderForeignObjects(folderId, ctx, user);
    }

    @Override
    public boolean isFolderEmpty(long folderId, Context ctx) throws OXException {
        return this.db.isFolderEmpty(folderId, ctx);
    }

    @Override
    public void removeUser(int id, Context ctx, ServerSession session) throws OXException {
        this.db.removeUser(id, ctx, session, this.lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getId(Context context, Connection writeCon) throws SQLException {
        boolean autoCommit = writeCon.getAutoCommit();
        if (autoCommit) {
            writeCon.setAutoCommit(false);
        }
        try {
            int n = IDGenerator.getId(context, 137, writeCon);
            return n;
        }
        finally {
            if (autoCommit) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
    }

    private Metadata[] addLastModifiedIfNeeded(Metadata[] columns) {
        for (Metadata metadata : columns) {
            if (metadata != Metadata.LAST_MODIFIED_LITERAL && metadata != Metadata.LAST_MODIFIED_UTC_LITERAL) continue;
            return columns;
        }
        Metadata[] copy = new Metadata[columns.length + 1];
        int i = 0;
        for (Metadata metadata : columns) {
            copy[i++] = metadata;
        }
        copy[i] = Metadata.LAST_MODIFIED_UTC_LITERAL;
        return copy;
    }

    public InfostoreSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void commit() throws OXException {
        this.db.commit();
        ServiceMethod.COMMIT.callUnsafe(this.security, new Object[0]);
        this.lockManager.commit();
        if (null != this.fileIdRemoveList.get() && this.fileIdRemoveList.get().size() > 0) {
            QuotaFileStorage qfs = this.getFileStorage(this.ctxHolder.get());
            for (String id : this.fileIdRemoveList.get()) {
                qfs.deleteFile(id);
            }
        }
        super.commit();
    }

    @Override
    public void finish() throws OXException {
        this.fileIdRemoveList.set(null);
        this.ctxHolder.set(null);
        this.db.finish();
        ServiceMethod.FINISH.callUnsafe(this.security, new Object[0]);
        super.finish();
    }

    @Override
    public void rollback() throws OXException {
        this.db.rollback();
        ServiceMethod.ROLLBACK.callUnsafe(this.security, new Object[0]);
        this.lockManager.rollback();
        super.rollback();
    }

    @Override
    public void setRequestTransactional(boolean transactional) {
        this.db.setRequestTransactional(transactional);
        ServiceMethod.SET_REQUEST_TRANSACTIONAL.call(this.security, transactional);
        this.lockManager.setRequestTransactional(transactional);
        super.setRequestTransactional(transactional);
    }

    @Override
    public void setTransactional(boolean transactional) {
        this.lockManager.setTransactional(transactional);
    }

    @Override
    public void startTransaction() throws OXException {
        this.fileIdRemoveList.set(new ArrayList());
        this.ctxHolder.set(null);
        this.db.startTransaction();
        ServiceMethod.START_TRANSACTION.callUnsafe(this.security, new Object[0]);
        this.lockManager.startTransaction();
        super.startTransaction();
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        this.db.setProvider(provider);
        ServiceMethod.SET_PROVIDER.call(this.security, provider);
        ServiceMethod.SET_PROVIDER.call(this.lockManager, provider);
    }

    private static final UserConfiguration getUserConfiguration(ServerSession sessionObj) {
        return UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), sessionObj.getContext());
    }

    private static final User getUser(ServerSession sessionObj) {
        return UserStorage.getStorageUser(sessionObj.getUserId(), sessionObj.getContext());
    }

    @Override
    public void setSessionHolder(SessionHolder sessionHolder) {
        this.expiredLocksListener.setSessionHolder(sessionHolder);
    }

    private void removeFromIndex(final Context context, final int userId, final List<DocumentMetadata> documents) {
        if (documents == null || documents.isEmpty()) {
            return;
        }
        ThreadPoolService threadPoolService = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
        ExecutorService executorService = threadPoolService.getExecutor();
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block25: {
                    IndexFacadeService indexFacade = ServerServiceRegistry.getInstance().getService(IndexFacadeService.class);
                    if (indexFacade != null) {
                        IndexAccess attachmentIndex;
                        IndexAccess infostoreIndex;
                        block23: {
                            infostoreIndex = null;
                            attachmentIndex = null;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Deleting infostore document");
                            }
                            infostoreIndex = indexFacade.acquireIndexAccess(137, userId, context.getContextId());
                            attachmentIndex = indexFacade.acquireIndexAccess(138, userId, context.getContextId());
                            for (DocumentMetadata document : documents) {
                                infostoreIndex.deleteById(InfostoreUUID.newUUID(context.getContextId(), userId, document.getFolderId(), document.getId()).toString());
                                attachmentIndex.deleteById(AttachmentUUID.newUUID(context.getContextId(), userId, 137, "0", String.valueOf(document.getFolderId()), String.valueOf(document.getId()), "1").toString());
                            }
                            if (infostoreIndex == null) break block23;
                            try {
                                indexFacade.releaseIndexAccess(infostoreIndex);
                            }
                            catch (OXException e) {
                                // empty catch block
                            }
                        }
                        if (attachmentIndex != null) {
                            try {
                                indexFacade.releaseIndexAccess(attachmentIndex);
                            }
                            catch (OXException e) {}
                        }
                        break block25;
                        catch (Exception e) {
                            block24: {
                                try {
                                    LOG.error((Object)"Error while deleting documents from index.", (Throwable)e);
                                    if (infostoreIndex == null) break block24;
                                }
                                catch (Throwable throwable) {
                                    if (infostoreIndex != null) {
                                        try {
                                            indexFacade.releaseIndexAccess(infostoreIndex);
                                        }
                                        catch (OXException e2) {
                                            // empty catch block
                                        }
                                    }
                                    if (attachmentIndex != null) {
                                        try {
                                            indexFacade.releaseIndexAccess(attachmentIndex);
                                        }
                                        catch (OXException e3) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                try {
                                    indexFacade.releaseIndexAccess(infostoreIndex);
                                }
                                catch (OXException e4) {
                                    // empty catch block
                                }
                            }
                            if (attachmentIndex != null) {
                                try {
                                    indexFacade.releaseIndexAccess(attachmentIndex);
                                }
                                catch (OXException e5) {}
                            }
                        }
                    }
                }
            }
        });
    }

    private void indexDocument(final Context context, final int userId, final int id, final long origFolderId, final boolean isCreation) {
        ThreadPoolService threadPoolService = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
        ExecutorService executorService = threadPoolService.getExecutor();
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block28: {
                    IndexFacadeService indexFacade = ServerServiceRegistry.getInstance().getService(IndexFacadeService.class);
                    if (indexFacade != null) {
                        IndexAccess attachmentIndex;
                        IndexAccess infostoreIndex;
                        block26: {
                            infostoreIndex = null;
                            attachmentIndex = null;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Indexing infostore document");
                            }
                            infostoreIndex = indexFacade.acquireIndexAccess(137, userId, context.getContextId());
                            attachmentIndex = indexFacade.acquireIndexAccess(138, userId, context.getContextId());
                            DocumentMetadata document = InfostoreFacadeImpl.this.load(id, -1, context);
                            if (isCreation) {
                                this.addToIndex(document, (IndexAccess<DocumentMetadata>)infostoreIndex, (IndexAccess<Attachment>)attachmentIndex);
                            } else if (origFolderId > 0L) {
                                infostoreIndex.deleteById(InfostoreUUID.newUUID(context.getContextId(), userId, origFolderId, id).toString());
                                attachmentIndex.deleteById(AttachmentUUID.newUUID(context.getContextId(), userId, 137, "0", String.valueOf(origFolderId), String.valueOf(id), "1").toString());
                                this.addToIndex(document, (IndexAccess<DocumentMetadata>)infostoreIndex, (IndexAccess<Attachment>)attachmentIndex);
                            } else {
                                infostoreIndex.deleteById(InfostoreUUID.newUUID(context.getContextId(), userId, document.getFolderId(), id).toString());
                                attachmentIndex.deleteById(AttachmentUUID.newUUID(context.getContextId(), userId, 137, "0", String.valueOf(document.getFolderId()), String.valueOf(id), "1").toString());
                                this.addToIndex(document, (IndexAccess<DocumentMetadata>)infostoreIndex, (IndexAccess<Attachment>)attachmentIndex);
                            }
                            if (infostoreIndex == null) break block26;
                            try {
                                indexFacade.releaseIndexAccess(infostoreIndex);
                            }
                            catch (OXException e) {
                                // empty catch block
                            }
                        }
                        if (attachmentIndex != null) {
                            try {
                                indexFacade.releaseIndexAccess(attachmentIndex);
                            }
                            catch (OXException e) {}
                        }
                        break block28;
                        catch (Exception e) {
                            block27: {
                                try {
                                    LOG.error((Object)"Error while indexing document.", (Throwable)e);
                                    if (infostoreIndex == null) break block27;
                                }
                                catch (Throwable throwable) {
                                    if (infostoreIndex != null) {
                                        try {
                                            indexFacade.releaseIndexAccess(infostoreIndex);
                                        }
                                        catch (OXException e2) {
                                            // empty catch block
                                        }
                                    }
                                    if (attachmentIndex != null) {
                                        try {
                                            indexFacade.releaseIndexAccess(attachmentIndex);
                                        }
                                        catch (OXException e3) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                try {
                                    indexFacade.releaseIndexAccess(infostoreIndex);
                                }
                                catch (OXException e4) {
                                    // empty catch block
                                }
                            }
                            if (attachmentIndex != null) {
                                try {
                                    indexFacade.releaseIndexAccess(attachmentIndex);
                                }
                                catch (OXException e5) {}
                            }
                        }
                    }
                }
            }

            private void addToIndex(DocumentMetadata document, IndexAccess<DocumentMetadata> infostoreIndex, IndexAccess<Attachment> attachmentIndex) throws OXException {
                StandardIndexDocument indexDocument = new StandardIndexDocument((Object)document);
                infostoreIndex.addContent((IndexDocument)indexDocument, true);
                String filestoreLocation = document.getFilestoreLocation();
                if (filestoreLocation != null) {
                    QuotaFileStorage fileStorage = InfostoreFacadeImpl.this.getFileStorage(context);
                    InputStream file = ((FileStorage)fileStorage).getFile(filestoreLocation);
                    Attachment attachment = new Attachment();
                    attachment.setModule(137);
                    attachment.setAccount("0");
                    attachment.setFolder(String.valueOf(document.getFolderId()));
                    attachment.setObjectId(String.valueOf(id));
                    attachment.setAttachmentId("1");
                    attachment.setFileName(document.getFileName());
                    attachment.setFileSize(document.getFileSize());
                    attachment.setMimeType(document.getFileMIMEType());
                    attachment.setMd5Sum(document.getFileMD5Sum());
                    attachment.setContent(file);
                    attachmentIndex.addContent((IndexDocument)new StandardIndexDocument((Object)attachment), true);
                }
            }
        });
    }

    static {
        VALIDATION.add(new InvalidCharactersValidator());
        VALIDATION.add(new FilenamesMayNotContainSlashesValidator());
        filenameReserver = new SelectForUpdateFilenameReserver();
        LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreFacadeImpl.class));
        QUERIES = new InfostoreQueryCatalog();
        IS_NUMBERED_WITH_EXTENSION = Pattern.compile("\\(\\d+\\)\\.");
        IS_NUMBERED = Pattern.compile("\\(\\d+\\)$");
    }

    private static interface ResultProcessor<T> {
        public T process(ResultSet var1) throws SQLException;
    }

    private final class NumberOfVersionsDelta
    implements Delta<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> newIter;
        private final SearchIterator<DocumentMetadata> modified;
        private SearchIterator<DocumentMetadata> deleted;

        public NumberOfVersionsDelta(Delta<DocumentMetadata> delegate, Context ctx) throws OXException {
            SearchIterator deleted = delegate.getDeleted();
            if (null != deleted) {
                this.deleted = InfostoreFacadeImpl.this.numberOfVersionsIterator(deleted, ctx);
            }
            this.modified = InfostoreFacadeImpl.this.numberOfVersionsIterator(delegate.getModified(), ctx);
            this.newIter = InfostoreFacadeImpl.this.numberOfVersionsIterator(delegate.getNew(), ctx);
            this.sequenceNumber = delegate.sequenceNumber();
        }

        public SearchIterator<DocumentMetadata> getDeleted() {
            return this.deleted;
        }

        public SearchIterator<DocumentMetadata> getModified() {
            return this.modified;
        }

        public SearchIterator<DocumentMetadata> getNew() {
            return this.newIter;
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return new CombinedSearchIterator(new SearchIterator[]{this.newIter, this.modified});
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public void close() throws OXException {
            this.newIter.close();
            this.modified.close();
            this.deleted.close();
        }
    }

    private final class LockDelta
    implements Delta<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> newIter;
        private final SearchIterator<DocumentMetadata> modified;
        private SearchIterator<DocumentMetadata> deleted;

        public LockDelta(Delta<DocumentMetadata> delegate, Map<Integer, List<Lock>> locks, Context ctx, User user, UserConfiguration userConfig) throws OXException {
            SearchIterator deleted = delegate.getDeleted();
            if (null != deleted) {
                this.deleted = InfostoreFacadeImpl.this.lockedUntilIterator(deleted, locks, ctx, user, userConfig);
            }
            this.modified = InfostoreFacadeImpl.this.lockedUntilIterator(delegate.getModified(), locks, ctx, user, userConfig);
            this.newIter = InfostoreFacadeImpl.this.lockedUntilIterator(delegate.getNew(), locks, ctx, user, userConfig);
            this.sequenceNumber = delegate.sequenceNumber();
        }

        public SearchIterator<DocumentMetadata> getDeleted() {
            return this.deleted;
        }

        public SearchIterator<DocumentMetadata> getModified() {
            return this.modified;
        }

        public SearchIterator<DocumentMetadata> getNew() {
            return this.newIter;
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return new CombinedSearchIterator(new SearchIterator[]{this.newIter, this.modified});
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public void close() throws OXException {
            this.newIter.close();
            this.modified.close();
            this.deleted.close();
        }
    }

    private final class LockTimedResult
    implements TimedResult<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> results;

        public LockTimedResult(TimedResult<DocumentMetadata> delegate, Context ctx, User user, UserConfiguration userConfig) throws OXException {
            this.sequenceNumber = delegate.sequenceNumber();
            this.results = InfostoreFacadeImpl.this.lockedUntilIterator(delegate.results(), null, ctx, user, userConfig);
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return this.results;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }
    }

    private final class NumberOfVersionsTimedResult
    implements TimedResult<DocumentMetadata> {
        private final long sequenceNumber;
        private final SearchIterator<DocumentMetadata> results;

        public NumberOfVersionsTimedResult(TimedResult<DocumentMetadata> delegate, Context ctx) throws OXException {
            this.sequenceNumber = delegate.sequenceNumber();
            this.results = InfostoreFacadeImpl.this.numberOfVersionsIterator(delegate.results(), ctx);
        }

        public SearchIterator<DocumentMetadata> results() throws OXException {
            return this.results;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }
    }

    private static enum ServiceMethod {
        COMMIT,
        FINISH,
        ROLLBACK,
        SET_REQUEST_TRANSACTIONAL,
        START_TRANSACTION,
        SET_PROVIDER;


        public void call(Object o, Object ... args) {
            if (!(o instanceof DBService)) {
                return;
            }
            DBService service = (DBService)o;
            switch (this) {
                default: {
                    return;
                }
                case SET_REQUEST_TRANSACTIONAL: {
                    service.setRequestTransactional((Boolean)args[0]);
                    break;
                }
                case SET_PROVIDER: {
                    service.setProvider((DBProvider)args[0]);
                }
            }
        }

        public void callUnsafe(Object o, Object ... args) throws OXException {
            if (!(o instanceof DBService)) {
                return;
            }
            DBService service = (DBService)o;
            switch (this) {
                default: {
                    this.call(o, args);
                    break;
                }
                case COMMIT: {
                    service.commit();
                    break;
                }
                case FINISH: {
                    service.finish();
                    break;
                }
                case ROLLBACK: {
                    service.rollback();
                    break;
                }
                case START_TRANSACTION: {
                    service.startTransaction();
                }
            }
        }
    }

    private static final class NotAllowed
    extends RuntimeException {
        private static final long serialVersionUID = 4872889537922290831L;
        private final int id;

        public NotAllowed(int id) {
            this.id = id;
        }
    }
}

