/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.BusyStatus;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FreeBusyInterval
implements Comparable<FreeBusyInterval> {
    private Date startTime;
    private Date endTime;
    private BusyStatus status;
    private String objectID;
    private String folderID;
    private boolean fullTime;
    private String title;
    private String location;

    public FreeBusyInterval(Date start, Date end, FreeBusyInterval other) {
        this(start, end, other.getStatus());
        this.objectID = other.getObjectID();
        this.fullTime = other.isFullTime();
        this.folderID = other.getFolderID();
        this.title = other.getTitle();
        this.location = other.getLocation();
    }

    public FreeBusyInterval(Date start, Date end, BusyStatus status) {
        this.startTime = start;
        this.endTime = end;
        this.status = status;
    }

    public FreeBusyInterval(Appointment appointment) {
        this(appointment.getStartDate(), appointment.getEndDate(), BusyStatus.valueOf(appointment));
        this.fullTime = appointment.getFullTime();
        if (appointment.containsObjectID() && 0 < appointment.getObjectID()) {
            this.objectID = String.valueOf(appointment.getObjectID());
        }
        if (appointment.containsParentFolderID() && 0 < appointment.getParentFolderID()) {
            this.folderID = String.valueOf(appointment.getParentFolderID());
        }
        if (appointment.containsTitle()) {
            this.title = appointment.getTitle();
        }
        if (appointment.containsLocation()) {
            this.location = appointment.getLocation();
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public BusyStatus getStatus() {
        return this.status;
    }

    public void setStatus(BusyStatus status) {
        this.status = status;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public String getFolderID() {
        return this.folderID;
    }

    public void setFolderID(String folderID) {
        this.folderID = folderID;
    }

    public boolean isFullTime() {
        return this.fullTime;
    }

    public void setFullTime(boolean isFullTime) {
        this.fullTime = isFullTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean equalsIgnoreTimes(FreeBusyInterval other) {
        if (null != this.getStatus() && !this.getStatus().equals((Object)other.getStatus()) || null != other.getStatus() && !other.getStatus().equals((Object)this.getStatus())) {
            return false;
        }
        if (null != this.getObjectID() && !this.getObjectID().equals(other.getObjectID()) || null != other.getObjectID() && !other.getObjectID().equals(this.getObjectID())) {
            return false;
        }
        if (null != this.getFolderID() && !this.getFolderID().equals(other.getFolderID()) || null != other.getFolderID() && !other.getFolderID().equals(this.getFolderID())) {
            return false;
        }
        if (null != this.getTitle() && !this.getTitle().equals(other.getTitle()) || null != other.getTitle() && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (null != this.getLocation() && !this.getLocation().equals(other.getLocation()) || null != other.getLocation() && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        return this.isFullTime() == other.isFullTime();
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return (null != this.startTime ? sdf.format(this.startTime) : "[]") + " - " + (null != this.endTime ? sdf.format(this.endTime) : "[]") + " (" + (Object)((Object)this.status) + ")";
    }

    @Override
    public int compareTo(FreeBusyInterval o) {
        int value;
        int n = value = null == o ? 1 : this.startTime.compareTo(o.getStartTime());
        if (0 == value && 0 == (value = this.endTime.compareTo(o.getEndTime()))) {
            value = this.status.compareTo(o.getStatus());
        }
        return value;
    }
}

