/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FreeBusyInterval;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class FreeBusyData {
    protected String participant;
    protected Date from;
    protected Date until;
    protected List<OXException> warnings;
    protected List<FreeBusyInterval> intervals = new ArrayList<FreeBusyInterval>();

    public FreeBusyData() {
        this(null, null, null);
    }

    public FreeBusyData(String participant, Date from, Date until) {
        this.participant = participant;
        this.from = from;
        this.until = until;
    }

    public void clear() {
        this.intervals.clear();
    }

    public void add(FreeBusyInterval interval) {
        this.intervals.add(interval);
    }

    public void addAll(Collection<? extends FreeBusyInterval> intervals) {
        if (null != intervals) {
            this.intervals.addAll(intervals);
        }
    }

    public void add(FreeBusyData data) {
        if (null != data) {
            if (data.hasWarnings()) {
                for (OXException warning : data.warnings) {
                    this.addWarning(warning);
                }
            }
            if (data.hasData()) {
                this.addAll(data.getIntervals());
            }
        }
    }

    public List<FreeBusyInterval> getIntervals() {
        return Collections.unmodifiableList(this.intervals);
    }

    public String getParticipant() {
        return this.participant;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getUntil() {
        return this.until;
    }

    public List<OXException> getWarnings() {
        return null != this.warnings && 0 < this.warnings.size() ? this.warnings : null;
    }

    public boolean hasWarnings() {
        return null != this.warnings && 0 < this.warnings.size();
    }

    public boolean hasData() {
        return null != this.intervals && 0 < this.intervals.size();
    }

    public void addWarning(OXException warning) {
        if (null == this.warnings) {
            this.warnings = new ArrayList<OXException>();
        }
        this.warnings.add(warning);
    }

    private static Date[] getTimes(List<FreeBusyInterval> intervals) {
        HashSet<Date> times = new HashSet<Date>();
        for (FreeBusyInterval freeBusyInterval : intervals) {
            times.add(freeBusyInterval.getStartTime());
            times.add(freeBusyInterval.getEndTime());
        }
        Object[] array = times.toArray(new Date[times.size()]);
        Arrays.sort(array);
        return array;
    }

    public void normalize() {
        Iterator<FreeBusyInterval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            FreeBusyInterval interval = iterator.next();
            if (null != interval.getEndTime() && interval.getEndTime().after(this.getFrom()) && null != interval.getStartTime() && interval.getStartTime().before(this.getUntil())) {
                if (interval.getStartTime().before(this.getFrom())) {
                    interval.setStartTime(this.getFrom());
                }
                if (!interval.getEndTime().after(this.getUntil())) continue;
                interval.setEndTime(this.getUntil());
                continue;
            }
            iterator.remove();
        }
        if (2 > this.intervals.size()) {
            return;
        }
        Date[] times = FreeBusyData.getTimes(this.intervals);
        ArrayList<FreeBusyInterval> expandedIntervals = new ArrayList<FreeBusyInterval>();
        for (FreeBusyInterval interval : this.intervals) {
            ArrayList<Date> expandedTimes = new ArrayList<Date>();
            expandedTimes.add(interval.getStartTime());
            for (Date time : times) {
                if (!interval.getStartTime().before(time) || !interval.getEndTime().after(time)) continue;
                expandedTimes.add(time);
            }
            expandedTimes.add(interval.getEndTime());
            if (2 == expandedTimes.size()) {
                expandedIntervals.add(interval);
                continue;
            }
            for (int i = 0; i < expandedTimes.size() - 1; ++i) {
                expandedIntervals.add(new FreeBusyInterval((Date)expandedTimes.get(i), (Date)expandedTimes.get(i + 1), interval));
            }
        }
        Collections.sort(expandedIntervals);
        ArrayList<FreeBusyInterval> mergedIntervals = new ArrayList<FreeBusyInterval>();
        iterator = expandedIntervals.iterator();
        FreeBusyInterval current = iterator.next();
        while (iterator.hasNext()) {
            FreeBusyInterval next = iterator.next();
            if (current.getStartTime().equals(next.getStartTime()) && current.getEndTime().equals(next.getEndTime())) {
                if (current.getStatus().isMoreConflicting(next.getStatus())) continue;
                current = next;
                continue;
            }
            mergedIntervals.add(current);
            current = next;
        }
        mergedIntervals.add(current);
        iterator = mergedIntervals.iterator();
        block5: while (iterator.hasNext()) {
            FreeBusyInterval slot = iterator.next();
            for (FreeBusyInterval freeBusyInterval : mergedIntervals) {
                if (!freeBusyInterval.equalsIgnoreTimes(slot)) continue;
                if (freeBusyInterval.getStartTime().equals(slot.getEndTime())) {
                    freeBusyInterval.setStartTime(slot.getStartTime());
                    iterator.remove();
                    continue block5;
                }
                if (!freeBusyInterval.getEndTime().equals(slot.getStartTime())) continue;
                freeBusyInterval.setEndTime(slot.getEndTime());
                iterator.remove();
                continue block5;
            }
        }
        this.intervals = mergedIntervals;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.participant).append(" (").append(null != this.from ? sdf.format(this.from) : "").append(" - ").append(null != this.until ? sdf.format(this.until) : "").append("):").append("\n");
        if (this.hasData()) {
            for (FreeBusyInterval interval : this.intervals) {
                stringBuilder.append(interval).append("\n");
            }
        }
        if (this.hasWarnings()) {
            for (OXException warning : this.warnings) {
                stringBuilder.append(warning.getLogMessage()).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

