/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.Appointment;

public enum BusyStatus {
    UNKNOWN(0),
    FREE(4),
    TEMPORARY(2),
    RESERVED(1),
    ABSENT(3);

    private final int value;

    public static BusyStatus valueOf(Appointment appointment) {
        return BusyStatus.valueOf(appointment.getShownAs());
    }

    public static BusyStatus valueOf(int shownAs) {
        switch (shownAs) {
            case 1: {
                return RESERVED;
            }
            case 2: {
                return TEMPORARY;
            }
            case 3: {
                return ABSENT;
            }
            case 4: {
                return FREE;
            }
        }
        return UNKNOWN;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isMoreConflicting(BusyStatus other) {
        return 0 < this.compareTo(other);
    }

    private BusyStatus(int value) {
        this.value = value;
    }
}

