/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.internal;

import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.concurrent.TimeoutConcurrentMap;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.ContactInterfaceProvider;
import com.openexchange.groupware.contact.ContactInterfaceProviderRegistration;
import com.openexchange.groupware.contact.ContactInterfaceProviderRegistry;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.List;

public final class ContactInterfaceDiscoveryServiceImpl
implements ContactInterfaceDiscoveryService {
    private static volatile ContactInterfaceDiscoveryServiceImpl instance;
    private final RdbContactInterfaceProviderCache rdbProviderCache;

    public static ContactInterfaceDiscoveryServiceImpl getInstance() {
        return instance;
    }

    static void initInstance() throws OXException {
        instance = new ContactInterfaceDiscoveryServiceImpl();
    }

    static void releaseInstance() {
        instance.dispose();
        instance = null;
    }

    private ContactInterfaceDiscoveryServiceImpl() throws OXException {
        try {
            this.rdbProviderCache = new RdbContactInterfaceProviderCache();
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private void dispose() {
        this.rdbProviderCache.dispose();
    }

    @Override
    public ContactInterfaceProvider getContactInterfaceProvider(int folderId, int contextId) throws OXException {
        ContactInterfaceProvider provider = ContactInterfaceProviderRegistry.getInstance().getService(folderId, contextId);
        if (provider == null) {
            try {
                return this.rdbProviderCache.getProvider(ContextStorage.getStorageContext(contextId));
            }
            catch (OXException e) {
                throw new OXException(e);
            }
        }
        return provider;
    }

    @Override
    public ContactInterface newContactInterface(int folderId, Session session) throws OXException {
        int contextId = session.getContextId();
        ContactInterfaceProvider provider = ContactInterfaceProviderRegistry.getInstance().getService(folderId, contextId);
        if (provider == null) {
            return this.rdbBySession(session, contextId);
        }
        return provider.newContactInterface(session);
    }

    @Override
    public boolean hasSpecificContactInterface(int folderId, int contextId) {
        return null != ContactInterfaceProviderRegistry.getInstance().getService(folderId, contextId);
    }

    @Override
    public ContactInterface newDefaultContactInterface(Session session) throws OXException {
        return this.rdbBySession(session, session.getContextId());
    }

    private ContactInterface rdbBySession(Session session, int contextId) throws OXException {
        if (session instanceof ServerSession) {
            return this.rdbProviderCache.getProvider(((ServerSession)session).getContext()).newContactInterface(session);
        }
        try {
            return this.rdbProviderCache.getProvider(ContextStorage.getStorageContext(contextId)).newContactInterface(session);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public List<ContactInterfaceProviderRegistration> getRegistrations(int contextId) {
        return ContactInterfaceProviderRegistry.getInstance().getRegistrations(contextId);
    }

    private static final class RdbContactInterfaceProviderCache {
        private final TimeoutConcurrentMap<Integer, RdbContactInterfaceProvider> map = new TimeoutConcurrentMap(20);

        public RdbContactInterfaceProvider getProvider(Context ctx) {
            RdbContactInterfaceProvider prev;
            Integer key = ctx.getContextId();
            RdbContactInterfaceProvider retval = this.map.get(key);
            if (null == retval && (prev = this.map.putIfAbsent(key, retval = new RdbContactInterfaceProvider(ctx), 300)) != null) {
                retval = prev;
            }
            return retval;
        }

        public void dispose() {
            this.map.dispose();
        }
    }

    private static final class RdbContactInterfaceProvider
    implements ContactInterfaceProvider {
        private final Context ctx;

        public RdbContactInterfaceProvider(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public ContactInterface newContactInterface(Session session) {
            return new RdbContactSQLImpl(session, this.ctx);
        }
    }
}

