/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactSwitcher;
import com.openexchange.groupware.contact.mappers.ContactFieldMapper;
import com.openexchange.groupware.contact.mappers.EnglishOutlookMapper;
import com.openexchange.groupware.contact.mappers.FrenchOutlookMapper;
import com.openexchange.groupware.contact.mappers.GermanOutlookMapper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum ContactField {
    DISPLAY_NAME(500, "field01", "DISPLAY_NAME", "Display name", "display_name", 12),
    SUR_NAME(502, "field02", "SUR_NAME", "Sur name", "last_name", 12),
    GIVEN_NAME(501, "field03", "GIVEN_NAME", "Given name", "first_name", 12),
    MIDDLE_NAME(503, "field04", "MIDDLE_NAME", "Middle name", "second_name", 12),
    SUFFIX(504, "field05", "SUFFIX", "Suffix", "suffix", 12),
    TITLE(505, "field06", "TITLE", "Title", "title", 12),
    STREET_HOME(506, "field07", "STREET_HOME", "Street home", "street_home", 12),
    POSTAL_CODE_HOME(507, "field08", "POSTAL_CODE_HOME", "Postal code home", "postal_code_home", 12),
    CITY_HOME(508, "field09", "CITY_HOME", "City home", "city_home", 12),
    STATE_HOME(509, "field10", "STATE_HOME", "State home", "state_home", 12),
    COUNTRY_HOME(510, "field11", "COUNTRY_HOME", "Country home", "country_home", 12),
    MARITAL_STATUS(512, "field12", "MARITAL_STATUS", "Martial status", "marital_status", 12),
    NUMBER_OF_CHILDREN(513, "field13", "NUMBER_OF_CHILDREN", "Number of children", "number_of_children", 12),
    PROFESSION(514, "field14", "PROFESSION", "Profession", "profession", 12),
    NICKNAME(515, "field15", "NICKNAME", "Nickname", "nickname", 12),
    SPOUSE_NAME(516, "field16", "SPOUSE_NAME", "Spouse name", "spouse_name", 12),
    NOTE(518, "field17", "NOTE", "Note", "note", 12),
    COMPANY(569, "field18", "COMPANY", "Company", "company", 12),
    DEPARTMENT(519, "field19", "DEPARTMENT", "Department", "department", 12),
    POSITION(520, "field20", "POSITION", "Position", "position", 12),
    EMPLOYEE_TYPE(521, "field21", "EMPLOYEE_TYPE", "Employee type", "employee_type", 12),
    ROOM_NUMBER(522, "field22", "ROOM_NUMBER", "Room number", "room_number", 12),
    STREET_BUSINESS(523, "field23", "STREET_BUSINESS", "Street business", "street_business", 12),
    POSTAL_CODE_BUSINESS(525, "field24", "POSTAL_CODE_BUSINESS", "Postal code business", "postal_code_business", 12),
    CITY_BUSINESS(526, "field25", "CITY_BUSINESS", "City business", "city_business", 12),
    STATE_BUSINESS(527, "field26", "STATE_BUSINESS", "State business", "state_business", 12),
    COUNTRY_BUSINESS(528, "field27", "COUNTRY_BUSINESS", "Country business", "country_business", 12),
    NUMBER_OF_EMPLOYEE(529, "field28", "NUMBER_OF_EMPLOYEE", "Number of employee", "number_of_employees", 12),
    SALES_VOLUME(530, "field29", "SALES_VOLUME", "Sales volume", "sales_volume", 12),
    TAX_ID(531, "field30", "TAX_ID", "Tax id", "tax_id", 12),
    COMMERCIAL_REGISTER(532, "field31", "COMMERCIAL_REGISTER", "Commercial register", "commercial_register", 12),
    BRANCHES(533, "field32", "BRANCHES", "Branches", "branches", 12),
    BUSINESS_CATEGORY(534, "field33", "BUSINESS_CATEGORY", "Business category", "busines_categorie", 12),
    INFO(535, "field34", "INFO", "Info", "info", 12),
    MANAGER_NAME(536, "field35", "MANAGER_NAME", "Manager's name", "manager_name", 12),
    ASSISTANT_NAME(537, "field36", "ASSISTANT_NAME", "Assistant's name", "assistant_name", 12),
    STREET_OTHER(538, "field37", "STREET_OTHER", "Street other", "street_other", 12),
    POSTAL_CODE_OTHER(540, "field38", "POSTAL_CODE_OTHER", "Postal code other", "postal_code_other", 12),
    CITY_OTHER(539, "field39", "CITY_OTHER", "City other", "city_other", 12),
    STATE_OTHER(598, "field40", "STATE_OTHER", "State other", "state_other", 12),
    COUNTRY_OTHER(541, "field41", "COUNTRY_OTHER", "Country other", "country_other", 12),
    TELEPHONE_ASSISTANT(568, "field42", "TELEPHONE_ASSISTANT", "Telephone assistant", "telephone_assistant", 12),
    TELEPHONE_BUSINESS1(542, "field43", "TELEPHONE_BUSINESS1", "Telephone business 1", "telephone_business1", 12),
    TELEPHONE_BUSINESS2(543, "field44", "TELEPHONE_BUSINESS2", "Telephone business 2", "telephone_business2", 12),
    FAX_BUSINESS(544, "field45", "FAX_BUSINESS", "FAX business", "fax_business", 12),
    TELEPHONE_CALLBACK(545, "field46", "TELEPHONE_CALLBACK", "Telephone callback", "telephone_callback", 12),
    TELEPHONE_CAR(546, "field47", "TELEPHONE_CAR", "Telephone car", "telephone_car", 12),
    TELEPHONE_COMPANY(547, "field48", "TELEPHONE_COMPANY", "Telephone company", "telephone_company", 12),
    TELEPHONE_HOME1(548, "field49", "TELEPHONE_HOME1", "Telephone home 1", "telephone_home1", 12),
    TELEPHONE_HOME2(549, "field50", "TELEPHONE_HOME2", "Telephone home 2", "telephone_home2", 12),
    FAX_HOME(550, "field51", "FAX_HOME", "FAX home", "fax_home", 12),
    TELEPHONE_ISDN(559, "field52", "TELEPHONE_ISDN", "Telephone ISDN", "telephone_isdn", 12),
    CELLULAR_TELEPHONE1(551, "field53", "CELLULAR_TELEPHONE1", "Cellular telephone 1", "cellular_telephone1", 12),
    CELLULAR_TELEPHONE2(552, "field54", "CELLULAR_TELEPHONE2", "Cellular telephone 2", "cellular_telephone2", 12),
    TELEPHONE_OTHER(553, "field55", "TELEPHONE_OTHER", "Telephone other", "telephone_other", 12),
    FAX_OTHER(554, "field56", "FAX_OTHER", "FAX other", "fax_other", 12),
    TELEPHONE_PAGER(560, "field57", "TELEPHONE_PAGER", "Telephone pager", "telephone_pager", 12),
    TELEPHONE_PRIMARY(561, "field58", "TELEPHONE_PRIMARY", "Telephone primary", "telephone_primary", 12),
    TELEPHONE_RADIO(562, "field59", "TELEPHONE_RADIO", "Telephone radio", "telephone_radio", 12),
    TELEPHONE_TELEX(563, "field60", "TELEPHONE_TELEX", "Telephone telex", "telephone_telex", 12),
    TELEPHONE_TTYTDD(564, "field61", "TELEPHONE_TTYTDD", "Telephone TTY/TDD", "telephone_ttytdd", 12),
    INSTANT_MESSENGER1(565, "field62", "INSTANT_MESSENGER1", "Instantmessenger 1", "instant_messenger1", 12),
    INSTANT_MESSENGER2(566, "field63", "INSTANT_MESSENGER2", "Instantmessenger 2", "instant_messenger2", 12),
    TELEPHONE_IP(567, "field64", "TELEPHONE_IP", "Telephone IP", "telephone_ip", 12),
    EMAIL1(555, "field65", "EMAIL1", "Email 1", "email1", 12),
    EMAIL2(556, "field66", "EMAIL2", "Email 2", "email2", 12),
    EMAIL3(557, "field67", "EMAIL3", "Email 3", "email3", 12),
    URL(558, "field68", "URL", "URL", "url", 12),
    CATEGORIES(100, "field69", "CATEGORIES", "Categories", "categories", 12),
    USERFIELD01(571, "field70", "USERFIELD01", "Dynamic Field 1", "userfield01", 12),
    USERFIELD02(572, "field71", "USERFIELD02", "Dynamic Field 2", "userfield02", 12),
    USERFIELD03(573, "field72", "USERFIELD03", "Dynamic Field 3", "userfield03", 12),
    USERFIELD04(574, "field73", "USERFIELD04", "Dynamic Field 4", "userfield04", 12),
    USERFIELD05(575, "field74", "USERFIELD05", "Dynamic Field 5", "userfield05", 12),
    USERFIELD06(576, "field75", "USERFIELD06", "Dynamic Field 6", "userfield06", 12),
    USERFIELD07(577, "field76", "USERFIELD07", "Dynamic Field 7", "userfield07", 12),
    USERFIELD08(578, "field77", "USERFIELD08", "Dynamic Field 8", "userfield08", 12),
    USERFIELD09(579, "field78", "USERFIELD09", "Dynamic Field 9", "userfield09", 12),
    USERFIELD10(580, "field79", "USERFIELD10", "Dynamic Field 10", "userfield10", 12),
    USERFIELD11(581, "field80", "USERFIELD11", "Dynamic Field 11", "userfield11", 12),
    USERFIELD12(582, "field81", "USERFIELD12", "Dynamic Field 12", "userfield12", 12),
    USERFIELD13(583, "field82", "USERFIELD13", "Dynamic Field 13", "userfield13", 12),
    USERFIELD14(584, "field83", "USERFIELD14", "Dynamic Field 14", "userfield14", 12),
    USERFIELD15(585, "field84", "USERFIELD15", "Dynamic Field 15", "userfield15", 12),
    USERFIELD16(586, "field85", "USERFIELD16", "Dynamic Field 16", "userfield16", 12),
    USERFIELD17(587, "field86", "USERFIELD17", "Dynamic Field 17", "userfield17", 12),
    USERFIELD18(588, "field87", "USERFIELD18", "Dynamic Field 18", "userfield18", 12),
    USERFIELD19(589, "field88", "USERFIELD19", "Dynamic Field 19", "userfield19", 12),
    USERFIELD20(590, "field89", "USERFIELD20", "Dynamic Field 20", "userfield20", 12),
    OBJECT_ID(1, "intfield01", "OBJECT_ID", "Object id", "id", 4),
    NUMBER_OF_DISTRIBUTIONLIST(594, "intfield02", "NUMBER_OF_DISTRIBUTIONLIST", "Number of distributionlists", "number_of_distribution_list", 4),
    NUMBER_OF_LINKS(103, "intfield03", "NUMBER_OF_LINKS", "Number of links", "number_of_links", 4),
    DISTRIBUTIONLIST(592, "", "DISTRIBUTIONLIST", "", "distribution_list", 0),
    LINKS(591, "", "LINKS", "", "links", 0),
    FOLDER_ID(20, "fid", "FOLDER_ID", "Folder id", "folder_id", 4),
    CONTEXTID(593, "cid", "CONTEXTID", "Context id", "", 4),
    PRIVATE_FLAG(101, "pflag", "PRIVATE_FLAG", "private", "private_flag", 4),
    CREATED_BY(2, "created_from", "CREATED_BY", "Created by", "created_by", 4),
    MODIFIED_BY(3, "changed_from", "MODIFIED_BY", "Modified by", "modified_by", 4),
    CREATION_DATE(4, "creating_date", "CREATION_DATE", "Creation date", "creation_date", -5),
    LAST_MODIFIED(5, "changing_date", "LAST_MODIFIED", "Changing date", "last_modified", -5),
    BIRTHDAY(511, "timestampfield01", "BIRTHDAY", "Birthday", "birthday", 91),
    ANNIVERSARY(517, "timestampfield02", "ANNIVERSARY", "Anniversary", "anniversary", 91),
    IMAGE1(570, "image1", "IMAGE1", "", "image1", -3),
    IMAGE_LAST_MODIFIED(597, "changing_date", "IMAGE_LAST_MODIFIED", "", "image_last_modified", 91),
    IMAGE1_CONTENT_TYPE(601, "mime_type", "IMAGE1_CONTENT_TYPE", "", "image1_content_type", 12),
    INTERNAL_USERID(524, "userid", "INTERNAL_USERID", "", "user_id", 4),
    COLOR_LABEL(102, "intfield05", "COLOR_LABEL", "", "color_label", 4),
    FILE_AS(599, "field90", "FILE_AS", "", "file_as", 12),
    DEFAULT_ADDRESS(605, "intfield06", "DEFAULT_ADDRESS", "Default address", "default_address", 4),
    MARK_AS_DISTRIBUTIONLIST(602, "intfield07", "MARK_AS_DISTRIBUTIONLIST", "", "mark_as_distributionlist", 4),
    NUMBER_OF_ATTACHMENTS(104, "intfield08", "NUMBER_OF_ATTACHMENTS", "", "number_of_attachments", 4),
    YOMI_FIRST_NAME(610, "yomiFirstName", "YOMI_FIRST_NAME", "yomiFirstName", "yomiFirstName", 12),
    YOMI_LAST_NAME(611, "yomiLastName", "YOMI_LAST_NAME", "yomiLastName", "yomiLastName", 12),
    YOMI_COMPANY(612, "yomiCompany", "YOMI_COMPANY", "yomiCompany", "yomiCompany", 12),
    NUMBER_OF_IMAGES(596, "intfield04", "NUMBER_OF_IMAGES", "number_of_images", "number_of_images", 4),
    LAST_MODIFIED_OF_NEWEST_ATTACHMENT(105, "", "LAST_MODIFIED_OF_NEWEST_ATTACHMENT", "lastModifiedOfNewestAttachment", "lastModifiedOfNewestAttachmentUTC", 0),
    USE_COUNT(608, "useCount", "USE_COUNT", "useCount", "useCount", 4),
    IMAGE1_URL(606, "", "IMAGE1_URL", "image1_url", "image1_url", 0),
    LAST_MODIFIED_UTC(6, "", "LAST_MODIFIED_UTC", "last_modified_utc", "last_modified_utc", 0),
    HOME_ADDRESS(613, "homeAddress", "ADDRESS_HOME", "homeAddress", "addressHome", 12),
    BUSINESS_ADDRESS(614, "businessAddress", "BUSINESS_ADDRESS", "businessAddress", "addressBusiness", 12),
    OTHER_ADDRESS(615, "otherAddress", "OTHER_ADDRESS", "otherAddress", "addressOther", 12),
    UID(223, "uid", "UID", "uid", "uid", 12),
    FILENAME(106, "filename", "FILENAME", "filename", "", 12);

    private int columnNumber;
    private int sqlType;
    private String fieldName;
    private String readableName;
    private String dbName;
    private String ajaxName;
    private static final ContactFieldMapper frenchOutlook;
    private static final ContactFieldMapper germanOutlook;
    private static final ContactFieldMapper englishOutlook;
    private static final EnumSet<ContactField> VIRTUAL_FIELDS;
    private static final EnumSet<ContactField> NON_DB_FIELDS;

    private ContactField(int columnNumber, String dbName, String fieldName, String readableName, String ajaxString, int sqlType) {
        this.dbName = dbName;
        this.columnNumber = columnNumber;
        this.fieldName = fieldName;
        this.readableName = readableName;
        this.ajaxName = ajaxString;
        this.sqlType = sqlType;
    }

    @Deprecated
    public int getNumber() {
        return this.columnNumber;
    }

    @Deprecated
    public String getFieldName() {
        return this.fieldName;
    }

    @Deprecated
    public String getReadableName() {
        return this.readableName;
    }

    @Deprecated
    public String getDbName() {
        return this.dbName;
    }

    @Deprecated
    public String getEnglishOutlookName() {
        return englishOutlook.getNameOfField(this);
    }

    @Deprecated
    public String getFrenchOutlookName() {
        return frenchOutlook.getNameOfField(this);
    }

    @Deprecated
    public String getGermanOutlookName() {
        return germanOutlook.getNameOfField(this);
    }

    @Deprecated
    public String getAjaxName() {
        return this.ajaxName;
    }

    @Deprecated
    public String getVCardElementName() {
        return this.readableName;
    }

    @Deprecated
    public int getSQLType() {
        return this.sqlType;
    }

    @Deprecated
    public static ContactField getByDBFieldName(String dbFieldName) {
        if (null == dbFieldName) {
            return null;
        }
        if ("".equals(dbFieldName)) {
            return null;
        }
        for (ContactField field : ContactField.values()) {
            if (!dbFieldName.equals(field.getFieldName())) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    public static ContactField getByDisplayName(String displayName) {
        if (null == displayName) {
            return null;
        }
        if ("".equals(displayName)) {
            return null;
        }
        for (ContactField field : ContactField.values()) {
            if (!displayName.equals(field.getReadableName())) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    public static ContactField getByFieldName(String fieldName) {
        if (null == fieldName) {
            return null;
        }
        if ("".equals(fieldName)) {
            return null;
        }
        for (ContactField field : ContactField.values()) {
            if (!fieldName.equals(field.getDbName())) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    public static ContactField getByValue(int value) {
        for (ContactField field : ContactField.values()) {
            if (value != field.getNumber()) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    public static ContactField getByEnglishOutlookName(String outlook) {
        return englishOutlook.getFieldByName(outlook);
    }

    @Deprecated
    public static ContactField getByFrenchOutlookName(String outlook) {
        return frenchOutlook.getFieldByName(outlook);
    }

    @Deprecated
    public static ContactField getByGermanOutlookName(String outlook) {
        return germanOutlook.getFieldByName(outlook);
    }

    @Deprecated
    public static ContactField getByAjaxName(String value) {
        for (ContactField field : ContactField.values()) {
            if (!value.equals(field.getAjaxName())) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    public static ContactField getBySimilarity(String value) {
        String needle = value.replaceAll("[_\\. ]", "").toLowerCase();
        for (ContactField field : ContactField.values()) {
            List<String> haystack = Arrays.asList(field.getAjaxName().replaceAll("[_\\. ]", "").toLowerCase(), field.getReadableName().replaceAll("[_\\. ]", "").toLowerCase(), field.getFieldName().replaceAll("[_\\. ]", "").toLowerCase());
            if (!haystack.contains(needle)) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    public Object doSwitch(ContactSwitcher switcher, Object ... objects) throws OXException {
        switch (this) {
            case DISPLAY_NAME: {
                return switcher.displayname(objects);
            }
            case SUR_NAME: {
                return switcher.surname(objects);
            }
            case GIVEN_NAME: {
                return switcher.givenname(objects);
            }
            case MIDDLE_NAME: {
                return switcher.middlename(objects);
            }
            case SUFFIX: {
                return switcher.suffix(objects);
            }
            case TITLE: {
                return switcher.title(objects);
            }
            case STREET_HOME: {
                return switcher.streethome(objects);
            }
            case POSTAL_CODE_HOME: {
                return switcher.postalcodehome(objects);
            }
            case CITY_HOME: {
                return switcher.cityhome(objects);
            }
            case STATE_HOME: {
                return switcher.statehome(objects);
            }
            case COUNTRY_HOME: {
                return switcher.countryhome(objects);
            }
            case MARITAL_STATUS: {
                return switcher.maritalstatus(objects);
            }
            case NUMBER_OF_CHILDREN: {
                return switcher.numberofchildren(objects);
            }
            case PROFESSION: {
                return switcher.profession(objects);
            }
            case NICKNAME: {
                return switcher.nickname(objects);
            }
            case SPOUSE_NAME: {
                return switcher.spousename(objects);
            }
            case NOTE: {
                return switcher.note(objects);
            }
            case COMPANY: {
                return switcher.company(objects);
            }
            case DEPARTMENT: {
                return switcher.department(objects);
            }
            case POSITION: {
                return switcher.position(objects);
            }
            case EMPLOYEE_TYPE: {
                return switcher.employeetype(objects);
            }
            case ROOM_NUMBER: {
                return switcher.roomnumber(objects);
            }
            case STREET_BUSINESS: {
                return switcher.streetbusiness(objects);
            }
            case POSTAL_CODE_BUSINESS: {
                return switcher.postalcodebusiness(objects);
            }
            case CITY_BUSINESS: {
                return switcher.citybusiness(objects);
            }
            case STATE_BUSINESS: {
                return switcher.statebusiness(objects);
            }
            case COUNTRY_BUSINESS: {
                return switcher.countrybusiness(objects);
            }
            case NUMBER_OF_EMPLOYEE: {
                return switcher.numberofemployee(objects);
            }
            case SALES_VOLUME: {
                return switcher.salesvolume(objects);
            }
            case TAX_ID: {
                return switcher.taxid(objects);
            }
            case COMMERCIAL_REGISTER: {
                return switcher.commercialregister(objects);
            }
            case BRANCHES: {
                return switcher.branches(objects);
            }
            case BUSINESS_CATEGORY: {
                return switcher.businesscategory(objects);
            }
            case INFO: {
                return switcher.info(objects);
            }
            case MANAGER_NAME: {
                return switcher.managername(objects);
            }
            case ASSISTANT_NAME: {
                return switcher.assistantname(objects);
            }
            case STREET_OTHER: {
                return switcher.streetother(objects);
            }
            case POSTAL_CODE_OTHER: {
                return switcher.postalcodeother(objects);
            }
            case CITY_OTHER: {
                return switcher.cityother(objects);
            }
            case STATE_OTHER: {
                return switcher.stateother(objects);
            }
            case COUNTRY_OTHER: {
                return switcher.countryother(objects);
            }
            case TELEPHONE_ASSISTANT: {
                return switcher.telephoneassistant(objects);
            }
            case TELEPHONE_BUSINESS1: {
                return switcher.telephonebusiness1(objects);
            }
            case TELEPHONE_BUSINESS2: {
                return switcher.telephonebusiness2(objects);
            }
            case FAX_BUSINESS: {
                return switcher.faxbusiness(objects);
            }
            case TELEPHONE_CALLBACK: {
                return switcher.telephonecallback(objects);
            }
            case TELEPHONE_CAR: {
                return switcher.telephonecar(objects);
            }
            case TELEPHONE_COMPANY: {
                return switcher.telephonecompany(objects);
            }
            case TELEPHONE_HOME1: {
                return switcher.telephonehome1(objects);
            }
            case TELEPHONE_HOME2: {
                return switcher.telephonehome2(objects);
            }
            case FAX_HOME: {
                return switcher.faxhome(objects);
            }
            case TELEPHONE_ISDN: {
                return switcher.telephoneisdn(objects);
            }
            case CELLULAR_TELEPHONE1: {
                return switcher.cellulartelephone1(objects);
            }
            case CELLULAR_TELEPHONE2: {
                return switcher.cellulartelephone2(objects);
            }
            case TELEPHONE_OTHER: {
                return switcher.telephoneother(objects);
            }
            case FAX_OTHER: {
                return switcher.faxother(objects);
            }
            case TELEPHONE_PAGER: {
                return switcher.telephonepager(objects);
            }
            case TELEPHONE_PRIMARY: {
                return switcher.telephoneprimary(objects);
            }
            case TELEPHONE_RADIO: {
                return switcher.telephoneradio(objects);
            }
            case TELEPHONE_TELEX: {
                return switcher.telephonetelex(objects);
            }
            case TELEPHONE_TTYTDD: {
                return switcher.telephonettyttd(objects);
            }
            case INSTANT_MESSENGER1: {
                return switcher.instantmessenger1(objects);
            }
            case INSTANT_MESSENGER2: {
                return switcher.instantmessenger2(objects);
            }
            case TELEPHONE_IP: {
                return switcher.telephoneip(objects);
            }
            case EMAIL1: {
                return switcher.email1(objects);
            }
            case EMAIL2: {
                return switcher.email2(objects);
            }
            case EMAIL3: {
                return switcher.email3(objects);
            }
            case URL: {
                return switcher.url(objects);
            }
            case CATEGORIES: {
                return switcher.categories(objects);
            }
            case USERFIELD01: {
                return switcher.userfield01(objects);
            }
            case USERFIELD02: {
                return switcher.userfield02(objects);
            }
            case USERFIELD03: {
                return switcher.userfield03(objects);
            }
            case USERFIELD04: {
                return switcher.userfield04(objects);
            }
            case USERFIELD05: {
                return switcher.userfield05(objects);
            }
            case USERFIELD06: {
                return switcher.userfield06(objects);
            }
            case USERFIELD07: {
                return switcher.userfield07(objects);
            }
            case USERFIELD08: {
                return switcher.userfield08(objects);
            }
            case USERFIELD09: {
                return switcher.userfield09(objects);
            }
            case USERFIELD10: {
                return switcher.userfield10(objects);
            }
            case USERFIELD11: {
                return switcher.userfield11(objects);
            }
            case USERFIELD12: {
                return switcher.userfield12(objects);
            }
            case USERFIELD13: {
                return switcher.userfield13(objects);
            }
            case USERFIELD14: {
                return switcher.userfield14(objects);
            }
            case USERFIELD15: {
                return switcher.userfield15(objects);
            }
            case USERFIELD16: {
                return switcher.userfield16(objects);
            }
            case USERFIELD17: {
                return switcher.userfield17(objects);
            }
            case USERFIELD18: {
                return switcher.userfield18(objects);
            }
            case USERFIELD19: {
                return switcher.userfield19(objects);
            }
            case USERFIELD20: {
                return switcher.userfield20(objects);
            }
            case OBJECT_ID: {
                return switcher.objectid(objects);
            }
            case NUMBER_OF_DISTRIBUTIONLIST: {
                return switcher.numberofdistributionlists(objects);
            }
            case NUMBER_OF_LINKS: {
                return switcher.numberoflinks(objects);
            }
            case DISTRIBUTIONLIST: {
                return switcher.distributionlist(objects);
            }
            case LINKS: {
                return switcher.links(objects);
            }
            case FOLDER_ID: {
                return switcher.parentfolderid(objects);
            }
            case CONTEXTID: {
                return switcher.contextid(objects);
            }
            case PRIVATE_FLAG: {
                return switcher.privateflag(objects);
            }
            case CREATED_BY: {
                return switcher.createdby(objects);
            }
            case MODIFIED_BY: {
                return switcher.modifiedby(objects);
            }
            case CREATION_DATE: {
                return switcher.creationdate(objects);
            }
            case LAST_MODIFIED: {
                return switcher.lastmodified(objects);
            }
            case BIRTHDAY: {
                return switcher.birthday(objects);
            }
            case ANNIVERSARY: {
                return switcher.anniversary(objects);
            }
            case IMAGE_LAST_MODIFIED: {
                return switcher.imagelastmodified(objects);
            }
            case INTERNAL_USERID: {
                return switcher.internaluserid(objects);
            }
            case COLOR_LABEL: {
                return switcher.label(objects);
            }
            case FILE_AS: {
                return switcher.fileas(objects);
            }
            case DEFAULT_ADDRESS: {
                return switcher.defaultaddress(objects);
            }
            case NUMBER_OF_ATTACHMENTS: {
                return switcher.numberofattachments(objects);
            }
            case NUMBER_OF_IMAGES: {
                return switcher.numberofimages(objects);
            }
            case LAST_MODIFIED_OF_NEWEST_ATTACHMENT: {
                return switcher.lastmodifiedofnewestattachment(objects);
            }
            case USE_COUNT: {
                return switcher.usecount(objects);
            }
            case MARK_AS_DISTRIBUTIONLIST: {
                return switcher.markasdistributionlist(objects);
            }
            case YOMI_FIRST_NAME: {
                return switcher.yomifirstname(objects);
            }
            case YOMI_LAST_NAME: {
                return switcher.yomilastname(objects);
            }
            case YOMI_COMPANY: {
                return switcher.yomicompanyname(objects);
            }
            case IMAGE1_CONTENT_TYPE: {
                return switcher.image1contenttype(objects);
            }
            case HOME_ADDRESS: {
                return switcher.homeaddress(objects);
            }
            case BUSINESS_ADDRESS: {
                return switcher.businessaddress(objects);
            }
            case OTHER_ADDRESS: {
                return switcher.otheraddress(objects);
            }
            case UID: {
                return switcher.uid(objects);
            }
            case IMAGE1: {
                return switcher.image1(objects);
            }
        }
        return null;
    }

    @Deprecated
    public boolean isVirtual() {
        return VIRTUAL_FIELDS.contains((Object)this);
    }

    @Deprecated
    public boolean isDBField() {
        return !NON_DB_FIELDS.contains((Object)this);
    }

    static {
        frenchOutlook = new FrenchOutlookMapper();
        germanOutlook = new GermanOutlookMapper();
        englishOutlook = new EnglishOutlookMapper();
        VIRTUAL_FIELDS = EnumSet.of(IMAGE1_URL);
        NON_DB_FIELDS = EnumSet.of(IMAGE1_URL, new ContactField[]{IMAGE1_CONTENT_TYPE, IMAGE_LAST_MODIFIED, IMAGE1, DISTRIBUTIONLIST, LINKS});
    }
}

