/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.datasource;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.contact.ContactService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;

public final class ContactImageDataSource
implements ImageDataSource {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContactImageDataSource.class));
    private static final ContactImageDataSource INSTANCE = new ContactImageDataSource();
    private static final String[] ARGS = new String[]{"com.openexchange.groupware.contact.folder", "com.openexchange.groupware.contact.id"};
    private static final String REGISTRATION_NAME = "com.openexchange.contact.image";
    private static final String ALIAS = "/contact/picture";

    public static ContactImageDataSource getInstance() {
        return INSTANCE;
    }

    private ContactImageDataSource() {
    }

    @Override
    public String generateUrl(ImageLocation imageLocation, Session session) throws OXException {
        StringBuilder sb = new StringBuilder(64);
        ImageUtility.startImageUrl(imageLocation, session, this, true, sb);
        Contact contact = ContactImageDataSource.optContact(session, imageLocation, ContactField.LAST_MODIFIED);
        if (null != contact) {
            sb.append('&').append("timestamp=").append(contact.getLastModified().getTime());
        }
        return sb.toString();
    }

    @Override
    public DataArguments generateDataArgumentsFrom(ImageLocation imageLocation) {
        DataArguments dataArguments = new DataArguments(2);
        dataArguments.put(ARGS[0], imageLocation.getFolder());
        dataArguments.put(ARGS[1], imageLocation.getId());
        return dataArguments;
    }

    @Override
    public long getExpires() {
        return -1L;
    }

    @Override
    public ImageLocation parseUrl(String url) {
        return ImageUtility.parseImageLocationFrom(url);
    }

    @Override
    public ImageLocation parseRequest(AJAXRequestData requestData) {
        return ImageUtility.parseImageLocationFrom(requestData);
    }

    @Override
    public String getETag(ImageLocation imageLocation, Session session) throws OXException {
        int delim = 35;
        StringBuilder builder = new StringBuilder(128);
        builder.append('#').append(imageLocation.getFolder());
        Contact contact = ContactImageDataSource.optContact(session, imageLocation, ContactField.LAST_MODIFIED);
        if (null != contact) {
            builder.append('#').append(contact.getLastModified().getTime());
        }
        builder.append('#');
        return ImageUtility.getMD5(builder.toString(), "hex");
    }

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        int objectId;
        int folder;
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        String val = dataArguments.get(ARGS[0]);
        if (val == null) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[0]});
        }
        try {
            folder = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw DataExceptionCodes.INVALID_ARGUMENT.create((Throwable)e, new Object[]{ARGS[0], val});
        }
        String val2 = dataArguments.get(ARGS[1]);
        if (val2 == null) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[1]});
        }
        try {
            objectId = Integer.parseInt(val2);
        }
        catch (NumberFormatException e) {
            throw DataExceptionCodes.INVALID_ARGUMENT.create((Throwable)e, new Object[]{ARGS[1], val2});
        }
        Contact contact = ContactImageDataSource.optContact(session, objectId, folder, ContactField.IMAGE1, ContactField.IMAGE1_CONTENT_TYPE);
        byte[] imageBytes = contact.getImage1();
        DataProperties properties = new DataProperties();
        if (imageBytes == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Requested a non-existing image in contact: object-id=" + objectId + " folder=" + folder + " context=" + session.getContextId() + " session-user=" + session.getUserId() + "\nReturning an empty image as fallback."));
            }
            properties.put("com.openexchange.conversion.content-type", "image/jpg");
            properties.put("com.openexchange.conversion.size", String.valueOf(0));
            return new SimpleData((Object)new UnsynchronizedByteArrayInputStream(new byte[0]), properties);
        }
        properties.put("com.openexchange.conversion.content-type", contact.getImageContentType());
        properties.put("com.openexchange.conversion.size", String.valueOf(imageBytes.length));
        properties.put("com.openexchange.conversion.name", contact.getImageContentType().replace('/', '.'));
        return new SimpleData((Object)new UnsynchronizedByteArrayInputStream(imageBytes), properties);
    }

    private static Contact optContact(Session session, ImageLocation imageLocation, ContactField ... fields) throws OXException {
        return ContactImageDataSource.optContact(session, ImageUtility.getUnsignedInteger(imageLocation.getId()), ImageUtility.getUnsignedInteger(imageLocation.getFolder()), fields);
    }

    private static Contact optContact(Session session, int objectID, int folderID, ContactField ... fields) throws OXException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, false);
        try {
            return contactService.getContact(session, Integer.toString(folderID), Integer.toString(objectID), fields);
        }
        catch (OXException e) {
            if (ContactExceptionCodes.CONTACT_NOT_FOUND.equals(e) || ContactExceptionCodes.NOT_IN_FOLDER.equals(e)) {
                LOG.debug((Object)"unable to get contact", (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    public String[] getRequiredArguments() {
        String[] args = new String[ARGS.length];
        System.arraycopy(ARGS, 0, args, 0, ARGS.length);
        return args;
    }

    public Class<?>[] getTypes() {
        return new Class[]{InputStream.class};
    }

    @Override
    public String getRegistrationName() {
        return REGISTRATION_NAME;
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }
}

