/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.AttachmentWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.ldap.User;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.apache.commons.logging.Log;
import org.json.JSONValue;

@Action(method=RequestMethod.GET, name="get", description="Get an attachment.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="attached", description="Object ID of the object to which the attachments are attached."), @Parameter(name="module", description="Module ID (as per Attachment object) of the attached object."), @Parameter(name="id", description="Object ID of the requested attachment.")}, responseDescription="Response with timestamp: An object containing all data of the requested attachment. The fields of the object are listed in Common object data (with only id, created_by and creation_date available) and Attachment object.")
public final class GetAction
extends AbstractAttachmentAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GetAction.class));
    private static final String DATASOURCE = "datasource";
    private static final String IDENTIFIER = "identifier";

    public GetAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            GetAction.require(requestData, "folder", "attached", "module", "id");
            int folderId = this.requireNumber(requestData, "folder");
            int attachedId = this.requireNumber(requestData, "attached");
            int moduleId = this.requireNumber(requestData, "module");
            int id = this.requireNumber(requestData, "id");
            return new AJAXRequestResult((Object)this.get(folderId, attachedId, moduleId, id, session), "apiResponse");
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private JSONValue get(int folderId, int attachedId, int moduleId, int id, ServerSession session) throws OXException {
        try {
            ATTACHMENT_BASE.startTransaction();
            User user = session.getUser();
            AttachmentMetadata attachment = ATTACHMENT_BASE.getAttachment(folderId, attachedId, moduleId, id, session.getContext(), user, session.getUserConfiguration());
            OXJSONWriter w = new OXJSONWriter();
            AttachmentWriter aWriter = new AttachmentWriter(w);
            aWriter.timedResult(attachment.getCreationDate().getTime());
            aWriter.write(attachment, TimeZoneUtils.getTimeZone(user.getTimeZone()));
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
            JSONValue jSONValue = w.getObject();
            return jSONValue;
        }
        catch (Throwable t) {
            this.rollback();
            if (t instanceof OXException) {
                throw (OXException)t;
            }
            throw new OXException(t);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

