/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.service.ServicePriorityConflictException;
import com.openexchange.tools.service.SpecificServiceChooser;

public class OverridableAttachmentAuthorization
implements AttachmentAuthorization {
    private final SpecificServiceChooser<AttachmentAuthorization> chooser;

    public OverridableAttachmentAuthorization(SpecificServiceChooser<AttachmentAuthorization> chooser) {
        this.chooser = chooser;
    }

    @Override
    public void checkMayAttach(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        this.getDelegate(folderId, ctx.getContextId()).checkMayAttach(folderId, objectId, user, userConfig, ctx);
    }

    @Override
    public void checkMayDetach(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        this.getDelegate(folderId, ctx.getContextId()).checkMayDetach(folderId, objectId, user, userConfig, ctx);
    }

    @Override
    public void checkMayReadAttachments(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        this.getDelegate(folderId, ctx.getContextId()).checkMayReadAttachments(folderId, objectId, user, userConfig, ctx);
    }

    private AttachmentAuthorization getDelegate(int folderId, int contextId) throws OXException {
        try {
            return this.chooser.choose(contextId, folderId);
        }
        catch (ServicePriorityConflictException e) {
            throw AttachmentExceptionCodes.SERVICE_CONFLICT.create(Autoboxing.I((int)contextId), Autoboxing.I((int)folderId));
        }
    }
}

