/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class VirtualFolderType
implements FolderType {
    private static final VirtualFolderType INSTANCE = new VirtualFolderType();
    private static final Set<String> KNOWN_TREES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FolderStorage.REAL_TREE_ID, "1")));

    public static VirtualFolderType getInstance() {
        return INSTANCE;
    }

    private VirtualFolderType() {
    }

    @Override
    public boolean servesFolderId(String folderId) {
        return null != folderId;
    }

    @Override
    public boolean servesTreeId(String treeId) {
        return !KNOWN_TREES.contains(treeId);
    }

    @Override
    public boolean servesParentId(String parentId) {
        return this.servesFolderId(parentId);
    }
}

