/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.osgi;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

final class MaxCapacityLinkedHashMap<K, V>
extends LinkedHashMap<K, V>
implements ConcurrentMap<K, V> {
    private static final long serialVersionUID = 8965907246210389424L;
    private static final int INITIAL_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private final int maximumCapacity;

    MaxCapacityLinkedHashMap(int maximumCapacity) {
        super(16, 0.75f, true);
        this.maximumCapacity = maximumCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maximumCapacity;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object currentValue = this.get(key);
        return currentValue == null ? this.put(key, value) : currentValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value.equals(this.get(key))) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        return this.containsKey(key) ? (V)this.put(key, value) : null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object currentValue = this.get(key);
        if (oldValue.equals(currentValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }
}

