/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail;

import com.openexchange.folderstorage.SortableId;

public final class MailId
implements SortableId {
    private final String fullname;
    private final int ordinal;
    private String name;

    public MailId(String fullname, int ordinal) {
        this.fullname = fullname;
        this.ordinal = ordinal;
    }

    public MailId setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.fullname;
    }

    @Override
    public SortableId.Priority getPriority() {
        return SortableId.Priority.HIGH;
    }

    @Override
    public int compareTo(SortableId o) {
        int anotherPrio;
        if (o instanceof MailId) {
            int thisVal = this.ordinal;
            int anotherVal = ((MailId)o).ordinal;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        int thisPrio = this.getPriority().ordinal();
        return thisPrio < (anotherPrio = o.getPriority().ordinal()) ? 1 : (thisPrio == anotherPrio ? 0 : -1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ordinal;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailId)) {
            return false;
        }
        MailId other = (MailId)obj;
        return this.ordinal == other.ordinal;
    }

    public String toString() {
        return new StringBuilder(32).append("{folderId=").append(this.fullname).append(", ordinal=").append(this.ordinal).append('}').toString();
    }
}

