/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderExtension;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.SystemContentType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.mail.DefaultFolderFullnameProvider;
import com.openexchange.folderstorage.mail.MailPermissionImpl;
import com.openexchange.folderstorage.mail.contentType.DraftsContentType;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.mail.contentType.SentContentType;
import com.openexchange.folderstorage.mail.contentType.SpamContentType;
import com.openexchange.folderstorage.mail.contentType.TrashContentType;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.IMailFolderStorageEnhanced2;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.map.hash.TIntIntHashMap;
import org.apache.commons.logging.Log;

public final class MailFolderImpl
extends AbstractFolder
implements FolderExtension {
    private static final long serialVersionUID = 6445442372690458946L;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailFolderImpl.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String PROTOCOL_UNIFIED_INBOX = "unifiedinbox";
    private final MailFolderType mailFolderType;
    private final boolean cacheable;
    private final String fullName;
    private final int accountId;
    private final int userId;
    private final int contextId;
    private static final int BIT_USER_FLAG = 0x20000000;
    private static final int BIT_RENAME_FLAG = 0x40000000;
    private static final int MAX_PERMISSION = 64;
    private static final TIntIntHashMap MAPPING = new TIntIntHashMap(6){
        {
            this.put(128, 64);
            this.put(64, 64);
            this.put(0, 0);
            this.put(2, 1);
            this.put(4, 2);
            this.put(8, 4);
        }
    };
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};

    public MailFolderImpl(MailFolder mailFolder, int accountId, MailConfig mailConfig, StorageParameters params, DefaultFolderFullnameProvider fullnameProvider) throws OXException {
        this(mailFolder, accountId, mailConfig, params.getUser(), params.getContext(), fullnameProvider);
    }

    public MailFolderImpl(MailFolder mailFolder, int accountId, MailConfig mailConfig, User user, Context context, DefaultFolderFullnameProvider fullnameProvider) throws OXException {
        int canRename;
        MailPermission mp;
        String value;
        this.accountId = accountId;
        this.userId = user.getId();
        this.contextId = context.getContextId();
        this.fullName = mailFolder.getFullname();
        this.id = MailFolderUtility.prepareFullname(accountId, this.fullName);
        String folderName = mailFolder.getName();
        this.name = "INBOX".equals(this.fullName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.INBOX) : folderName;
        this.parent = mailFolder.isRootFolder() ? FolderStorage.PRIVATE_ID : MailFolderUtility.prepareFullname(accountId, mailFolder.getParentFullname());
        MailPermission[] mailPermissions = mailFolder.getPermissions();
        this.permissions = new Permission[mailPermissions.length];
        for (int i = 0; i < mailPermissions.length; ++i) {
            this.permissions[i] = new MailPermissionImpl(mailPermissions[i]);
        }
        this.type = SystemType.getInstance();
        boolean ignoreSubscription = mailConfig.getMailProperties().isIgnoreSubscription();
        this.subscribed = ignoreSubscription ? true : mailFolder.isSubscribed();
        this.subscribedSubfolders = ignoreSubscription ? mailFolder.hasSubfolders() : mailFolder.hasSubscribedSubfolders();
        this.capabilities = mailConfig.getCapabilities().getCapabilities();
        this.summary = value = mailFolder.isRootFolder() ? "" : new StringBuilder(16).append('(').append(mailFolder.getMessageCount()).append('/').append(mailFolder.getUnreadMessageCount()).append(')').toString();
        this.deefault = 0 == accountId && mailFolder.isDefaultFolder();
        this.total = mailFolder.getMessageCount();
        this.nu = mailFolder.getNewMessageCount();
        this.unread = mailFolder.getUnreadMessageCount();
        this.deleted = mailFolder.getDeletedMessageCount();
        if (mailFolder.isRootFolder()) {
            this.mailFolderType = MailFolderType.ROOT;
            MailPermission rootPermission = mailFolder.getOwnPermission();
            if (rootPermission == null) {
                mp = new DefaultMailPermission();
                mp.setAllPermission(8, 0, 0, 0);
                mp.setFolderAdmin(false);
            } else {
                mp = rootPermission;
            }
        } else {
            boolean translateDefaultFolders;
            mp = mailFolder.getOwnPermission();
            MailFolderType mailFolderType = MailFolderType.NONE;
            for (Permission pe : this.permissions) {
                if (pe.getEntity() != mp.getEntity() || pe.getFolderPermission() > 0) continue;
                pe.setFolderPermission(2);
            }
            ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean bl = translateDefaultFolders = null == configurationService || configurationService.getBoolProperty("com.openexchange.mail.translateDefaultFolders", true);
            if (mailFolder.containsDefaultFolderType()) {
                switch (mailFolder.getDefaultFolderType()) {
                    case INBOX: {
                        mailFolderType = MailFolderType.INBOX;
                        break;
                    }
                    case TRASH: {
                        this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.TRASH) : (MailStrings.TRASH.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.TRASH) : folderName);
                        mailFolderType = MailFolderType.TRASH;
                        break;
                    }
                    case SENT: {
                        this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SENT) : (MailStrings.SENT.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SENT) : folderName);
                        mailFolderType = MailFolderType.SENT;
                        break;
                    }
                    case SPAM: {
                        this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SPAM) : (MailStrings.SPAM.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SPAM) : folderName);
                        mailFolderType = MailFolderType.SPAM;
                        break;
                    }
                    case DRAFTS: {
                        this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.DRAFTS) : (MailStrings.DRAFTS.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.DRAFTS) : folderName);
                        mailFolderType = MailFolderType.DRAFTS;
                        break;
                    }
                    case CONFIRMED_SPAM: {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.CONFIRMED_SPAM);
                        break;
                    }
                    case CONFIRMED_HAM: {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.CONFIRMED_HAM);
                        break;
                    }
                }
            } else if (null != this.fullName) {
                if (null == fullnameProvider) {
                    mailFolderType = MailFolderType.ROOT;
                } else {
                    try {
                        if (this.fullName.equals(fullnameProvider.getDraftsFolder())) {
                            this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.DRAFTS) : (MailStrings.DRAFTS.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.DRAFTS) : folderName);
                            mailFolderType = MailFolderType.DRAFTS;
                        } else if (this.fullName.equals(fullnameProvider.getINBOXFolder())) {
                            mailFolderType = MailFolderType.INBOX;
                        } else if (this.fullName.equals(fullnameProvider.getSentFolder())) {
                            this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SENT) : (MailStrings.SENT.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SENT) : folderName);
                            mailFolderType = MailFolderType.SENT;
                        } else if (this.fullName.equals(fullnameProvider.getSpamFolder())) {
                            this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SPAM) : (MailStrings.SPAM.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.SPAM) : folderName);
                            mailFolderType = MailFolderType.SPAM;
                        } else if (this.fullName.equals(fullnameProvider.getTrashFolder())) {
                            this.name = translateDefaultFolders ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.TRASH) : (MailStrings.TRASH.equals(folderName) ? StringHelper.valueOf(user.getLocale()).getString(MailStrings.TRASH) : folderName);
                            mailFolderType = MailFolderType.TRASH;
                        } else if (this.fullName.equals(fullnameProvider.getConfirmedSpamFolder())) {
                            this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.CONFIRMED_SPAM);
                        } else if (this.fullName.equals(fullnameProvider.getConfirmedHamFolder())) {
                            this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.CONFIRMED_HAM);
                        }
                    }
                    catch (OXException e) {
                        com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailFolderImpl.class)).error((Object)e.getMessage(), (Throwable)e);
                        mailFolderType = MailFolderType.NONE;
                    }
                }
            } else {
                mailFolderType = MailFolderType.NONE;
            }
            this.mailFolderType = mailFolderType;
        }
        if (!mailFolder.isHoldsFolders() && mp.canCreateSubfolders()) {
            mp.setFolderPermission(4);
        }
        if (!mailFolder.isHoldsMessages() && mp.canReadOwnObjects()) {
            mp.setReadObjectPermission(0);
        }
        int permissionBits = MailFolderImpl.createPermissionBits(mp.getFolderPermission(), mp.getReadPermission(), mp.getWritePermission(), mp.getDeletePermission(), mp.isFolderAdmin());
        if (mailFolder.isSupportsUserFlags()) {
            permissionBits |= 0x20000000;
        }
        if ((canRename = mp.canRename()) > 0) {
            permissionBits |= 0x40000000;
        }
        this.bits = permissionBits;
        boolean cache = true;
        if (mailFolder.containsShared() && mailFolder.isShared()) {
            cache = false;
        } else if (mailFolder.isTrash()) {
            cache = false;
        } else if (this.isUnifiedMail(mailFolder)) {
            cache = false;
        }
        this.cacheable = cache;
    }

    private boolean isUnifiedMail(MailFolder mailFolder) {
        return PROTOCOL_UNIFIED_INBOX.equals(mailFolder.getProperty("protocol"));
    }

    static int createPermissionBits(Permission perm) {
        return MailFolderImpl.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isAdmin());
    }

    static int createPermissionBits(int fp, int rp, int wp, int dp, boolean adminFlag) {
        int retval = 0;
        int i = 4;
        retval += (adminFlag ? 1 : 0) << i-- * 7;
        retval += MAPPING.get(dp) << i-- * 7;
        retval += MAPPING.get(wp) << i-- * 7;
        retval += MAPPING.get(rp) << i-- * 7;
        return retval += MAPPING.get(fp) << i * 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnread() {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = MailAccess.getInstance(this.userId, this.contextId, this.accountId);
            mailAccess.connect(false);
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageEnhanced) {
                int n = ((IMailFolderStorageEnhanced)folderStorage).getUnreadCounter(MailFolderImpl.ensureFullName(this.fullName));
                return n;
            }
            int n = mailAccess.getMessageStorage().getUnreadMessages(MailFolderImpl.ensureFullName(this.fullName), MailSortField.RECEIVED_DATE, OrderDirection.DESC, FIELDS_ID, -1).length;
            return n;
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Cannot return up-to-date unread counter.", (Throwable)e);
            }
            int n = super.getUnread();
            return n;
        }
        catch (Exception e) {
            if (DEBUG) {
                LOG.debug((Object)"Cannot return up-to-date unread counter.", (Throwable)e);
            }
            int n = super.getUnread();
            return n;
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotal() {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = MailAccess.getInstance(this.userId, this.contextId, this.accountId);
            mailAccess.connect(false);
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageEnhanced) {
                int n = ((IMailFolderStorageEnhanced)folderStorage).getTotalCounter(MailFolderImpl.ensureFullName(this.fullName));
                return n;
            }
            int n = mailAccess.getMessageStorage().searchMessages(MailFolderImpl.ensureFullName(this.fullName), IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, null, FIELDS_ID).length;
            return n;
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Cannot return up-to-date total counter.", (Throwable)e);
            }
            int n = super.getTotal();
            return n;
        }
        catch (Exception e) {
            if (DEBUG) {
                LOG.debug((Object)"Cannot return up-to-date total counter.", (Throwable)e);
            }
            int n = super.getTotal();
            return n;
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getTotalAndUnread() {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            int total;
            int unread;
            mailAccess = MailAccess.getInstance(this.userId, this.contextId, this.accountId);
            mailAccess.connect(false);
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageEnhanced2) {
                int[] nArray = ((IMailFolderStorageEnhanced2)folderStorage).getTotalAndUnreadCounter(MailFolderImpl.ensureFullName(this.fullName));
                return nArray;
            }
            String ensuredFullName = MailFolderImpl.ensureFullName(this.fullName);
            if (folderStorage instanceof IMailFolderStorageEnhanced) {
                IMailFolderStorageEnhanced storageEnhanced = (IMailFolderStorageEnhanced)folderStorage;
                unread = storageEnhanced.getUnreadCounter(ensuredFullName);
                total = storageEnhanced.getTotalCounter(ensuredFullName);
            } else {
                unread = mailAccess.getMessageStorage().getUnreadMessages(ensuredFullName, MailSortField.RECEIVED_DATE, OrderDirection.DESC, FIELDS_ID, -1).length;
                total = mailAccess.getMessageStorage().searchMessages(ensuredFullName, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, null, FIELDS_ID).length;
            }
            int[] nArray = new int[]{total, unread};
            return nArray;
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Cannot return up-to-date total counter.", (Throwable)e);
            }
            int[] nArray = null;
            return nArray;
        }
        catch (Exception e) {
            if (DEBUG) {
                LOG.debug((Object)"Cannot return up-to-date total counter.", (Throwable)e);
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }

    private static String ensureFullName(String fullName) {
        return MailFolderUtility.prepareMailFolderParam(fullName).getFullname();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public ContentType getContentType() {
        return this.mailFolderType.getContentType();
    }

    @Override
    public int getDefaultType() {
        return this.mailFolderType.getType();
    }

    @Override
    public void setDefaultType(int defaultType) {
    }

    @Override
    public Type getType() {
        return MailType.getInstance();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public boolean isGlobalID() {
        return false;
    }

    public static enum MailFolderType {
        NONE(MailContentType.getInstance(), 0),
        ROOT(SystemContentType.getInstance(), 0),
        INBOX(MailContentType.getInstance(), 7),
        DRAFTS(DraftsContentType.getInstance(), 9),
        SENT(SentContentType.getInstance(), 10),
        SPAM(SpamContentType.getInstance(), 11),
        TRASH(TrashContentType.getInstance(), 12);

        private final ContentType contentType;
        private final int type;

        private MailFolderType(ContentType contentType, int type) {
            this.contentType = contentType;
            this.type = type;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public int getType() {
            return this.type;
        }
    }
}

