/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;

public final class ConsistencyPerformer
extends AbstractPerformer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ConsistencyPerformer.class));
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();

    public ConsistencyPerformer(ServerSession session) {
        super(session);
    }

    public ConsistencyPerformer(User user, Context context) {
        super(user, context);
    }

    public ConsistencyPerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, folderStorageDiscoverer);
    }

    public ConsistencyPerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
    }

    public void doConsistencyCheck(String treeId) throws OXException {
        FolderStorage[] folderStorages = this.folderStorageDiscoverer.getFolderStoragesForTreeID(treeId);
        long start = DEBUG_ENABLED ? System.currentTimeMillis() : 0L;
        for (FolderStorage folderStorage : folderStorages) {
            boolean started = folderStorage.startTransaction(this.storageParameters, true);
            try {
                folderStorage.checkConsistency(treeId, this.storageParameters);
                if (!started) continue;
                folderStorage.commitTransaction(this.storageParameters);
            }
            catch (OXException e) {
                if (started) {
                    folderStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    folderStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        if (DEBUG_ENABLED) {
            long duration = System.currentTimeMillis() - start;
            LOG.debug((Object)("ConsistencyPerformer.doConsistencyCheck() took " + duration + "msec for tree: " + treeId));
        }
    }
}

