/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.folderstorage.FolderI18nNamesService;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.i18n.I18nService;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class FolderI18nNamesServiceImpl
implements FolderI18nNamesService {
    private static final FolderI18nNamesServiceImpl INSTANCE = new FolderI18nNamesServiceImpl();
    private final Map<String, String> i18nNames;
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();
    private final Set<String> identifiers = new HashSet<String>(32);

    public static FolderI18nNamesServiceImpl getInstance() {
        return INSTANCE;
    }

    private FolderI18nNamesServiceImpl() {
        this.i18nNames = new ConcurrentHashMap<String, String>(512);
        this.initIdentifiers();
    }

    private void initIdentifiers() {
        this.identifiers.add(MailStrings.INBOX);
        this.identifiers.add(MailStrings.SPAM);
        this.identifiers.add(MailStrings.DRAFTS);
        this.identifiers.add(MailStrings.TRASH);
        this.identifiers.add(MailStrings.SENT);
        this.identifiers.add(MailStrings.SENT_ALT);
        this.identifiers.add(MailStrings.CONFIRMED_HAM);
        this.identifiers.add(MailStrings.CONFIRMED_HAM_ALT);
        this.identifiers.add(MailStrings.CONFIRMED_SPAM);
        this.identifiers.add(MailStrings.CONFIRMED_SPAM_ALT);
        this.identifiers.add("Calendar");
        this.identifiers.add("Collected addresses");
        this.identifiers.add("Contacts");
        this.identifiers.add("Tasks");
        this.identifiers.add("E-Mail attachments");
        this.identifiers.add("System");
        this.identifiers.add("Shared address book");
        this.identifiers.add("Infostore");
        this.identifiers.add("Global address book");
        this.identifiers.add("OX folders");
        this.identifiers.add("Projects");
        this.identifiers.add("Private folders");
        this.identifiers.add("Public folders");
        this.identifiers.add("Public infostore");
        this.identifiers.add("Shared folders");
        this.identifiers.add("Userstore");
        this.identifiers.add("Other calendar folders");
        this.identifiers.add("Other contact folders");
        this.identifiers.add("Other infostore folders");
        this.identifiers.add("Other task folders");
    }

    public void addService(I18nService service) {
        this.services.put(service.getLocale(), service);
        this.i18nNames.clear();
    }

    public void removeService(I18nService service) {
        this.services.remove(service.getLocale());
        this.i18nNames.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getI18nNamesFor(int ... modules) {
        if (this.i18nNames.isEmpty()) {
            Map<Locale, I18nService> map = this.services;
            synchronized (map) {
                if (this.i18nNames.isEmpty()) {
                    for (String identifier : this.identifiers) {
                        this.i18nNames.put(identifier, identifier);
                    }
                    for (I18nService service : this.services.values()) {
                        for (String identifier : this.identifiers) {
                            String translated = service.getLocalized(identifier);
                            this.i18nNames.put(translated, translated);
                        }
                    }
                    ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                    if (null != service) {
                        this.handleText(service.getText("folder-reserved-names"));
                    }
                }
            }
        }
        return Collections.unmodifiableSet(this.i18nNames.keySet());
    }

    private void handleText(String text) {
        if (null == text) {
            return;
        }
        for (String line : text.split("\r?\n")) {
            if (FolderI18nNamesServiceImpl.isEmpty(line) || '#' == line.charAt(0)) continue;
            for (String value : line.split(" *, *")) {
                this.processValue(value);
            }
        }
    }

    private void processValue(String value) {
        if (FolderI18nNamesServiceImpl.isEmpty(value)) {
            return;
        }
        String val = value.trim();
        if ('#' == val.charAt(0)) {
            return;
        }
        int mlen = val.length() - 1;
        if ('\"' == val.charAt(0) && '\"' == val.charAt(mlen)) {
            if (0 == mlen) {
                return;
            }
            if (FolderI18nNamesServiceImpl.isEmpty(val = val.substring(1, mlen))) {
                return;
            }
        }
        this.i18nNames.put(val, val);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

