/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.memory;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;

final class LockBasedConcurrentMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, V> delegate;
    private final Lock writeLock;
    private final Lock readLock;

    LockBasedConcurrentMap(Lock readLock, Lock writeLock, ConcurrentMap<K, V> delegate) {
        this.writeLock = writeLock;
        this.readLock = readLock;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.readLock.lock();
        try {
            Object v = this.delegate.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            V v = this.delegate.put(key, value);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.writeLock.lock();
        try {
            V v = this.delegate.putIfAbsent(key, value);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.writeLock.lock();
        try {
            this.delegate.putAll(map);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.writeLock.lock();
        try {
            Object v = this.delegate.remove(key);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.remove(key, value);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.replace(key, oldValue, newValue);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.writeLock.lock();
        try {
            V v = this.delegate.replace(key, value);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.readLock.lock();
        try {
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.delegate.keySet());
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        this.readLock.lock();
        try {
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.delegate.values());
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.readLock.lock();
        try {
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.delegate.entrySet());
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.equals(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

