/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.memory;

import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.RemoveAfterAccessFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.folderstorage.cache.memory.LockBasedConcurrentMap;
import com.openexchange.folderstorage.cache.memory.MaxCapacityLinkedHashMap;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.AbortBehavior;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public final class FolderMap {
    protected static final Log LOG = LogFactory.getLog(FolderMap.class);
    private final ConcurrentMap<Key, Wrapper> map;
    private final int maxLifeMillis;
    private final int userId;
    private final int contextId;

    public FolderMap(int maxCapacity, int maxLifeUnits, TimeUnit unit, int userId, int contextId) {
        ReentrantLock lock = new ReentrantLock();
        this.map = new LockBasedConcurrentMap<Key, Wrapper>(lock, lock, new MaxCapacityLinkedHashMap(maxCapacity));
        this.maxLifeMillis = (int)unit.toMillis(maxLifeUnits);
        this.contextId = contextId;
        this.userId = userId;
    }

    public FolderMap(int maxCapacity, int maxLifeMillis, int userId, int contextId) {
        this(maxCapacity, maxLifeMillis, TimeUnit.MILLISECONDS, userId, contextId);
    }

    public void shrink() {
        ArrayList removeKeys = new ArrayList(16);
        long minStamp = System.currentTimeMillis() - (long)this.maxLifeMillis;
        for (Map.Entry entry : this.map.entrySet()) {
            Wrapper wrapper = (Wrapper)entry.getValue();
            if (wrapper.removeAfterAccess || wrapper.getStamp() >= minStamp) continue;
            removeKeys.add(entry.getKey());
        }
        this.map.keySet().removeAll(removeKeys);
    }

    public Folder putIfAbsent(String treeId, Folder folder, Session session) {
        return this.putIfAbsent(folder.getID(), treeId, folder, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder putIfAbsent(String folderId, String treeId, Folder folder, Session session) {
        Wrapper wrapper = this.wrapperOf(folder, session);
        Key key = FolderMap.keyOf(folderId, treeId);
        Wrapper prev = this.map.putIfAbsent(key, wrapper);
        if (null == prev) {
            return null;
        }
        if (prev.elapsed(this.maxLifeMillis)) {
            ConcurrentMap<Key, Wrapper> concurrentMap = this.map;
            synchronized (concurrentMap) {
                prev = (Wrapper)this.map.get(key);
                if (prev.elapsed(this.maxLifeMillis)) {
                    this.shrink();
                    this.map.put(key, wrapper);
                    return null;
                }
            }
        }
        return prev.getValue();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(String folderId, String treeId) {
        return this.map.containsKey(FolderMap.keyOf(folderId, treeId));
    }

    public Folder get(String folderId, String treeId, Session session) {
        Key key = FolderMap.keyOf(folderId, treeId);
        Wrapper wrapper = (Wrapper)this.map.get(key);
        if (null == wrapper) {
            return null;
        }
        if (wrapper.elapsed(this.maxLifeMillis)) {
            this.map.remove(key);
            this.shrink();
            if (!wrapper.removeAfterAccess) {
                return null;
            }
            Folder folder = wrapper.getValue();
            this.reloadFolder(folderId, treeId, wrapper.loadSubfolders, session);
            return folder;
        }
        return wrapper.getValue();
    }

    private void reloadFolder(String folderId, String treeId, boolean loadSubfolders, Session ses) {
        try {
            SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
            if (null == sessiondService) {
                return;
            }
            ServerSession session = ServerSessionAdapter.valueOf(null == ses ? sessiondService.getAnyActiveSessionForUser(this.userId, this.contextId) : ses);
            if (null == session) {
                return;
            }
            ThreadPools.getThreadPool().submit(ThreadPools.trackableTask((Runnable)new RunnableImpl(folderId, treeId, loadSubfolders, this, session)), AbortBehavior.getInstance());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void loadSubolders(Folder folder, String treeId, Session ses) {
        try {
            SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
            if (null == sessiondService) {
                return;
            }
            ServerSession session = ServerSessionAdapter.valueOf(null == ses ? sessiondService.getAnyActiveSessionForUser(this.userId, this.contextId) : ses);
            if (null == session) {
                return;
            }
            if (LogProperties.isEnabled()) {
                Props properties = LogProperties.getLogProperties();
                properties.put("com.openexchange.session.sessionId", (Object)session.getSessionID());
                properties.put("com.openexchange.session.userId", (Object)session.getUserId());
                properties.put("com.openexchange.session.contextId", (Object)session.getContextId());
                String client = session.getClient();
                properties.put("com.openexchange.session.clientId", (Object)(client == null ? "unknown" : client));
            }
            ThreadPools.getThreadPool().submit(ThreadPools.trackableTask((Runnable)new LoadSubfolders(folder, treeId, this, session)), AbortBehavior.getInstance());
        }
        catch (Exception e) {
            folder.setSubfolderIDs(null);
        }
    }

    public Folder put(String treeId, Folder folder, Session session) {
        return this.put(folder.getID(), treeId, folder, session);
    }

    public Folder put(String folderId, String treeId, Folder folder, Session session) {
        Key key = FolderMap.keyOf(folderId, treeId);
        Wrapper wrapper = this.map.put(key, this.wrapperOf(folder, session));
        if (null == wrapper) {
            return null;
        }
        if (wrapper.elapsed(this.maxLifeMillis)) {
            this.map.remove(key);
            this.shrink();
            return null;
        }
        return wrapper.getValue();
    }

    public void remove(String folderId, String treeId) {
        this.map.remove(FolderMap.keyOf(folderId, treeId));
    }

    public Folder remove(String folderId, String treeId, Session session) {
        Wrapper wrapper = (Wrapper)this.map.remove(FolderMap.keyOf(folderId, treeId));
        if (null == wrapper) {
            return null;
        }
        Folder ret = wrapper.getIfNotElapsed(this.maxLifeMillis);
        if (wrapper.removeAfterAccess) {
            this.reloadFolder(folderId, treeId, wrapper.loadSubfolders, session);
        }
        return ret;
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    private static Key keyOf(String folderId, String treeId) {
        return new Key(folderId, treeId);
    }

    private Wrapper wrapperOf(Folder folder, Session session) {
        Wrapper wrapper = new Wrapper(folder);
        if (wrapper.loadSubfolders && null == folder.getSubfolderIDs()) {
            this.loadSubolders(folder, folder.getTreeID(), session);
        }
        return wrapper;
    }

    private static final class LoadSubfolders
    implements Runnable {
        private final Folder folder;
        private final String treeId;
        private final FolderMap folderMap;
        private final ServerSession session;

        protected LoadSubfolders(Folder folder, String treeId, FolderMap folderMap, ServerSession session) {
            this.folder = folder;
            this.treeId = treeId;
            this.folderMap = folderMap;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StorageParametersImpl params = new StorageParametersImpl(this.session);
                params.putParameter(MailFolderType.getInstance(), "__accessFast", Boolean.FALSE);
                Lock lock = CacheFolderStorage.readLockFor(this.treeId, params);
                lock.lock();
                try {
                    CacheFolderStorage folderStorage = CacheFolderStorage.getInstance();
                    SortableId[] subfolders = folderStorage.getSubfolders(this.treeId, this.folder.getID(), params);
                    String[] ids = new String[subfolders.length];
                    for (int i = 0; i < ids.length; ++i) {
                        ids[i] = subfolders[i].getId();
                    }
                    this.folder.setSubfolderIDs(ids);
                    for (SortableId sortableId : subfolders) {
                        Folder loaded = folderStorage.loadFolder(this.treeId, sortableId.getId(), StorageType.WORKING, params);
                        if (loaded.isGlobalID()) {
                            folderStorage.putFolder(loaded, this.treeId, params);
                            continue;
                        }
                        this.folderMap.put(this.treeId, loaded, this.session);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final class RunnableImpl
    implements Runnable {
        private final String folderId;
        private final String treeId;
        private final boolean loadSubfolders;
        private final FolderMap folderMap;
        private final ServerSession session;

        protected RunnableImpl(String folderId, String treeId, boolean loadSubfolders, FolderMap folderMap, ServerSession session) {
            this.folderId = folderId;
            this.treeId = treeId;
            this.loadSubfolders = loadSubfolders;
            this.folderMap = folderMap;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StorageParametersImpl params = new StorageParametersImpl(this.session);
                params.putParameter(MailFolderType.getInstance(), "__accessFast", Boolean.FALSE);
                Lock lock = CacheFolderStorage.readLockFor(this.treeId, params);
                lock.lock();
                try {
                    String[] subfolderIDs;
                    CacheFolderStorage folderStorage = CacheFolderStorage.getInstance();
                    Folder loaded = folderStorage.loadFolder(this.treeId, this.folderId, StorageType.WORKING, params);
                    if (loaded.isGlobalID()) {
                        return;
                    }
                    this.folderMap.put(this.treeId, loaded, this.session);
                    if (this.loadSubfolders && null != (subfolderIDs = loaded.getSubfolderIDs())) {
                        for (String subfolderId : subfolderIDs) {
                            loaded = folderStorage.loadFolder(this.treeId, subfolderId, StorageType.WORKING, params);
                            if (loaded.isGlobalID()) {
                                folderStorage.putFolder(loaded, this.treeId, params);
                                continue;
                            }
                            this.folderMap.put(this.treeId, loaded, this.session);
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final class Key {
        private final String treeId;
        private final String folderId;
        private final int hash;

        public Key(String folderId, String treeId) {
            this.folderId = folderId;
            this.treeId = treeId;
            int prime = 31;
            int result = 1;
            result = 31 * result + (folderId == null ? 0 : folderId.hashCode());
            this.hash = result = 31 * result + (treeId == null ? 0 : treeId.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.folderId == null ? other.folderId != null : !this.folderId.equals(other.folderId)) {
                return false;
            }
            return !(this.treeId == null ? other.treeId != null : !this.treeId.equals(other.treeId));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Key ( ");
            sb.append("treeId = ");
            sb.append(this.treeId);
            sb.append(", folderId = ");
            sb.append(this.folderId);
            sb.append(" )");
            return sb.toString();
        }
    }

    private static final class Wrapper {
        private final Folder value;
        private final long stamp;
        protected final boolean removeAfterAccess;
        protected final boolean loadSubfolders;

        public Wrapper(Folder value) {
            this.value = value;
            this.stamp = System.currentTimeMillis();
            if (value instanceof RemoveAfterAccessFolder) {
                this.removeAfterAccess = true;
                this.loadSubfolders = ((RemoveAfterAccessFolder)value).loadSubfolders();
            } else {
                this.removeAfterAccess = false;
                this.loadSubfolders = false;
            }
        }

        public long getStamp() {
            return this.stamp;
        }

        public boolean elapsed(int maxLifeMillis) {
            return System.currentTimeMillis() - this.stamp > (long)maxLifeMillis;
        }

        public Folder getIfNotElapsed(int maxLifeMillis) {
            return this.elapsed(maxLifeMillis) ? null : this.value;
        }

        public Folder getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.getID();
        }
    }
}

