/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.lock;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class UserLockManagement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UserLockManagement.class));
    private static final UserLockManagement INSTANCE = new UserLockManagement();
    private final ConcurrentMap<Key, ReadWriteLock> map = new ConcurrentHashMap<Key, ReadWriteLock>();

    public static UserLockManagement getInstance() {
        return INSTANCE;
    }

    private UserLockManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(Session session) {
        this.map.remove(UserLockManagement.keyFor(session));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleaned folder locks for user " + session.getUserId() + " in context " + session.getContextId()));
        }
    }

    public ReadWriteLock getFor(Session session) {
        return this.getFor(session.getUserId(), session.getContextId());
    }

    public ReadWriteLock getFor(int userId, int contextId) {
        ReentrantReadWriteLock nrwl;
        Key key = UserLockManagement.keyFor(userId, contextId);
        ReadWriteLock readWriteLock = (ReadWriteLock)this.map.get(key);
        if (null == readWriteLock && null == (readWriteLock = this.map.putIfAbsent(key, nrwl = new ReentrantReadWriteLock()))) {
            readWriteLock = nrwl;
        }
        return readWriteLock;
    }

    public ReadWriteLock optFor(Session session) {
        return (ReadWriteLock)this.map.get(UserLockManagement.keyFor(session));
    }

    private static Key keyFor(Session session) {
        return new Key(session.getUserId(), session.getContextId());
    }

    private static Key keyFor(int userId, int contextId) {
        return new Key(userId, contextId);
    }

    private static final class Key {
        private final int cid;
        private final int user;
        private final int hash;

        protected Key(int user, int cid) {
            this.user = user;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + user;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.user == other.user;
        }
    }
}

