/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.cache.CacheContentTypeRegistry;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CacheFolderStorageRegistry
implements FolderStorageDiscoverer {
    private static final CacheFolderStorageRegistry instance = new CacheFolderStorageRegistry();
    private final ConcurrentMap<String, List<FolderStorage>> registry = new ConcurrentHashMap<String, List<FolderStorage>>();
    private final Queue<FolderStorage> genStorages = new Java7ConcurrentLinkedQueue();

    public static CacheFolderStorageRegistry getInstance() {
        return instance;
    }

    private CacheFolderStorageRegistry() {
    }

    public void clearCaches(int userId, int contextId) {
        for (FolderStorage fs : this.genStorages) {
            fs.clearCache(userId, contextId);
        }
        Set entrySet = this.registry.entrySet();
        for (Map.Entry entry : entrySet) {
            List list = (List)entry.getValue();
            for (FolderStorage folderStorage : list) {
                folderStorage.clearCache(userId, contextId);
            }
        }
    }

    public boolean addFolderStorage(String treeId, FolderStorage folderStorage) {
        if (StoragePriority.HIGHEST == folderStorage.getStoragePriority()) {
            return false;
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            boolean success = true;
            for (int i = 0; success && i < contentTypes.length; ++i) {
                success = CacheContentTypeRegistry.getInstance().addContentType(treeId, contentTypes[i], folderStorage);
            }
            if (!success) {
                for (ContentType contentType : contentTypes) {
                    CacheContentTypeRegistry.getInstance().removeContentType(treeId, contentType);
                }
                return false;
            }
        } else if (!CacheContentTypeRegistry.getInstance().addGeneralContentType(treeId, folderStorage)) {
            return false;
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.add(folderStorage);
        } else {
            CopyOnWriteArrayList<FolderStorage> tmp;
            CopyOnWriteArrayList<FolderStorage> storages = (CopyOnWriteArrayList<FolderStorage>)this.registry.get(treeId);
            if (null == storages && null == (storages = (List)this.registry.putIfAbsent(treeId, tmp = new CopyOnWriteArrayList<FolderStorage>()))) {
                storages = tmp;
            }
            storages.add(folderStorage);
        }
        return true;
    }

    @Override
    public FolderStorage getFolderStorage(String treeId, String folderId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                if (!folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return folderStorage;
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return null;
        }
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesFolderId(folderId)) continue;
            return folderStorage;
        }
        return null;
    }

    @Override
    public FolderStorage[] getFolderStoragesForParent(String treeId, String parentId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId) || !folderType.servesParentId(parentId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        ArrayList<FolderStorage> l = new ArrayList<FolderStorage>(4);
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesParentId(parentId)) continue;
            l.add(folderStorage);
        }
        return l.toArray(new FolderStorage[l.size()]);
    }

    @Override
    public FolderStorage[] getFolderStoragesForTreeID(String treeId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage[] getTreeFolderStorages(String treeId) {
        List storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                if (StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || !folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (List)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage getFolderStorageByContentType(String treeId, ContentType contentType) {
        return CacheContentTypeRegistry.getInstance().getFolderStorageByContentType(treeId, contentType);
    }

    public void removeFolderStorage(String treeId, FolderStorage folderStorage) {
        if (StoragePriority.HIGHEST == folderStorage.getStoragePriority()) {
            return;
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.remove(folderStorage);
        } else {
            List storages = (List)this.registry.get(treeId);
            if (null == storages) {
                return;
            }
            storages.remove(folderStorage);
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            for (ContentType contentType : contentTypes) {
                CacheContentTypeRegistry.getInstance().removeContentType(treeId, contentType);
            }
        } else {
            CacheContentTypeRegistry.getInstance().removeGeneralContentType(treeId, folderStorage);
        }
    }
}

