/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.filemanagement.internal.ManagedFileImpl;
import com.openexchange.filemanagement.internal.ManagedInputStream;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

final class ManagedFileManagementImpl
implements ManagedFileManagement {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ManagedFileManagementImpl.class));
    private static final int DELAY = 10000;
    private static final int INITIAL_DELAY = 1000;
    private static volatile ManagedFileManagementImpl instance;
    private static final String PREFIX = "open-xchange-";
    private static final String SUFFIX = ".tmp";
    private final ConcurrentMap<String, ManagedFile> files = new ConcurrentHashMap<String, ManagedFile>();
    private PropertyListener propertyListener;
    private ScheduledTimerTask timerTask;
    private final AtomicReference<File> tmpDirReference = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ManagedFileManagementImpl getInstance() {
        ManagedFileManagementImpl tmp = instance;
        if (tmp != null) return tmp;
        Class<ManagedFileManagementImpl> clazz = ManagedFileManagementImpl.class;
        synchronized (ManagedFileManagementImpl.class) {
            tmp = instance;
            if (tmp != null) return tmp;
            instance = new ManagedFileManagementImpl();
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void releaseInstance() {
        if (instance == null) return;
        Class<ManagedFileManagementImpl> clazz = ManagedFileManagementImpl.class;
        synchronized (ManagedFileManagementImpl.class) {
            if (instance == null) return;
            instance.shutDown(true);
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private ManagedFileManagementImpl() {
        ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
        ConfigurationService cs = registry.getService(ConfigurationService.class);
        if (null == cs) {
            throw new IllegalStateException("Missing configuration service");
        }
        this.propertyListener = new FileManagementPropertyListener(this.tmpDirReference);
        String path = cs.getProperty("UPLOAD_DIRECTORY", this.propertyListener);
        this.tmpDirReference.set(this.getTmpDirByPath(path));
        TimerService timer = registry.getService(TimerService.class);
        if (null == timer) {
            throw new IllegalStateException("Missing timer service");
        }
        this.timerTask = timer.scheduleWithFixedDelay((Runnable)new FileManagementTask(this.files, 300000, LOG), 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public InputStream createInputStream(byte[] bytes) throws OXException {
        return new ManagedInputStream(bytes, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(byte[] bytes, int capacity) throws OXException {
        return new ManagedInputStream(bytes, capacity, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in) throws OXException {
        return new ManagedInputStream(in, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in, int capacity) throws OXException {
        return new ManagedInputStream(in, capacity, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in, int size, int capacity) throws OXException {
        return new ManagedInputStream(in, size, capacity, this);
    }

    public void clear() {
        Iterator iter = this.files.values().iterator();
        while (iter.hasNext()) {
            ((ManagedFile)iter.next()).delete();
        }
        this.files.clear();
    }

    public File newTempFile() throws OXException {
        return this.newTempFile(PREFIX, SUFFIX);
    }

    public File newTempFile(String prefix, String suffix) throws OXException {
        File tmpFile = null;
        File directory = null;
        do {
            directory = this.tmpDirReference.get();
            try {
                if (null == tmpFile) {
                    tmpFile = File.createTempFile(prefix, suffix, directory);
                    tmpFile.deleteOnExit();
                    continue;
                }
                File tmp = File.createTempFile(prefix, suffix, directory);
                if (!tmpFile.delete()) {
                    LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()));
                }
                tmpFile = tmp;
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                if (tmpFile != null && !tmpFile.delete() && LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()), (Throwable)e);
                }
                throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        } while (!this.tmpDirReference.compareAndSet(directory, directory));
        return tmpFile;
    }

    public ManagedFile createManagedFile(File temporaryFile) throws OXException {
        ManagedFileImpl mf = new ManagedFileImpl(UUID.randomUUID().toString(), temporaryFile);
        mf.setSize(temporaryFile.length());
        this.files.put(mf.getID(), mf);
        return mf;
    }

    public ManagedFile createManagedFile(byte[] bytes) throws OXException {
        return this.createManagedFile0((InputStream)new UnsynchronizedByteArrayInputStream(bytes), false, null);
    }

    public ManagedFile createManagedFile(InputStream inputStream) throws OXException {
        return this.createManagedFile0(inputStream, true, null);
    }

    public ManagedFile createManagedFile(InputStream inputStream, String optExtension) throws OXException {
        return this.createManagedFile0(inputStream, true, optExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedFile createManagedFile0(InputStream inputStream, boolean closeStream, String optExtension) throws OXException {
        if (null == inputStream) {
            throw new IllegalArgumentException("Missing input stream.");
        }
        ManagedFileImpl mf = null;
        File tmpFile = null;
        File directory = null;
        do {
            block15: {
                directory = this.tmpDirReference.get();
                try {
                    if (null == tmpFile) {
                        tmpFile = File.createTempFile(PREFIX, null == optExtension ? SUFFIX : optExtension, directory);
                        tmpFile.deleteOnExit();
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile, false));
                        try {
                            byte[] buf = new byte[8192];
                            int len = -1;
                            while ((len = inputStream.read(buf, 0, buf.length)) != -1) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((OutputStream)out).flush();
                            break block15;
                        }
                        finally {
                            Streams.close((Closeable)out);
                        }
                    }
                    File tmp = File.createTempFile(PREFIX, SUFFIX, directory);
                    ManagedFileManagementImpl.copyFile(tmpFile, tmp);
                    if (!tmpFile.delete()) {
                        LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()));
                    }
                    tmpFile = tmp;
                    tmpFile.deleteOnExit();
                }
                catch (IOException e) {
                    if (tmpFile != null && !tmpFile.delete() && LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Temporary file could not be deleted: " + tmpFile.getPath()), (Throwable)e);
                    }
                    throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    if (closeStream) {
                        Streams.close((Closeable)inputStream);
                    }
                }
            }
            mf = new ManagedFileImpl(UUID.randomUUID().toString(), tmpFile);
            mf.setSize(tmpFile.length());
        } while (!this.tmpDirReference.compareAndSet(directory, directory));
        this.files.put(mf.getID(), mf);
        return mf;
    }

    public boolean contains(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf || mf.isDeleted()) {
            return false;
        }
        mf.touch();
        return true;
    }

    public ManagedFile getByID(String id) throws OXException {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf || mf.isDeleted()) {
            throw ManagedFileExceptionErrorMessage.NOT_FOUND.create(new Object[]{id});
        }
        mf.touch();
        return mf;
    }

    File getTmpDirByPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("Path is null. Probably property \"UPLOAD_DIRECTORY\" is not set.");
        }
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            throw new IllegalArgumentException("Directory " + path + " does not exist.");
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory.");
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByID(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf) {
            return;
        }
        try {
            if (!mf.isDeleted()) {
                mf.delete();
            }
        }
        finally {
            this.files.remove(mf.getID());
        }
    }

    void removeFromFiles(String id) {
        this.files.remove(id);
    }

    void shutDown(boolean complete) {
        if (complete && this.propertyListener != null) {
            ConfigurationService cs = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null != cs) {
                cs.removePropertyListener("UPLOAD_DIRECTORY", this.propertyListener);
            }
            this.propertyListener = null;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel(true);
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                timer.purge();
            }
            this.timerTask = null;
        }
        this.tmpDirReference.set(null);
        this.clear();
    }

    void startUp() {
        if (this.timerTask == null) {
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null == timer) {
                throw new IllegalStateException("Missing timer service");
            }
            this.timerTask = timer.scheduleWithFixedDelay((Runnable)new FileManagementTask(this.files, 300000, LOG), 1000L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static class FileManagementTask
    implements Runnable {
        private final Log logger;
        private final ConcurrentMap<String, ManagedFile> tfiles;
        private final int time2live;

        public FileManagementTask(ConcurrentMap<String, ManagedFile> files, int time2live, Log logger) {
            this.tfiles = files;
            this.time2live = time2live;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                long now = System.currentTimeMillis();
                Iterator iter = this.tfiles.values().iterator();
                while (iter.hasNext()) {
                    ManagedFile cur = (ManagedFile)iter.next();
                    if (!cur.isDeleted() && now - cur.getLastAccess() <= (long)this.time2live) continue;
                    cur.delete();
                    iter.remove();
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)t.getMessage(), t);
            }
        }
    }

    private class FileManagementPropertyListener
    implements PropertyListener {
        private final AtomicReference<File> ttmpDirReference;

        public FileManagementPropertyListener(AtomicReference<File> tmpDirReference) {
            this.ttmpDirReference = tmpDirReference;
        }

        public void onPropertyChange(PropertyEvent event) {
            if (PropertyEvent.Type.CHANGED.equals((Object)event.getType())) {
                this.ttmpDirReference.set(ManagedFileManagementImpl.this.getTmpDirByPath(event.getValue()));
                ManagedFileManagementImpl.this.startUp();
            } else {
                ManagedFileManagementImpl.this.shutDown(false);
            }
        }
    }
}

