/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.internal.Initialization;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DatabaseServiceRegisterer
implements ServiceTrackerCustomizer<ConfigurationService, ConfigurationService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DatabaseServiceRegisterer.class));
    private final BundleContext context;
    private ServiceRegistration<DatabaseService> serviceRegistration;

    public DatabaseServiceRegisterer(BundleContext context) {
        this.context = context;
    }

    public ConfigurationService addingService(ServiceReference<ConfigurationService> reference) {
        if (Initialization.getInstance().isStarted()) {
            return null;
        }
        ConfigurationService configuration = (ConfigurationService)this.context.getService(reference);
        try {
            DatabaseService service = Initialization.getInstance().start(configuration);
            LOG.info((Object)"Publishing DatabaseService.");
            this.serviceRegistration = this.context.registerService(DatabaseService.class, (Object)service, null);
        }
        catch (OXException e) {
            LOG.error((Object)"Publishing the DatabaseService failed.", (Throwable)e);
        }
        return configuration;
    }

    public void modifiedService(ServiceReference<ConfigurationService> reference, ConfigurationService service) {
    }

    public void removedService(ServiceReference<ConfigurationService> reference, ConfigurationService service) {
        if (null != this.serviceRegistration) {
            LOG.info((Object)"Unpublishing DatabaseService.");
            this.serviceRegistration.unregister();
            Initialization.getInstance().stop();
            this.context.ungetService(reference);
        }
    }
}

