/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.database.internal.OverviewMBean;
import com.openexchange.database.internal.Pools;
import com.openexchange.database.internal.ReplicationMonitor;

public class Overview
implements OverviewMBean {
    private final Pools pools;

    public Overview(Pools pools) {
        this.pools = pools;
    }

    @Override
    public int getNumConnections() {
        int retval = 0;
        for (ConnectionPool pool : this.pools.getPools()) {
            retval += pool.getPoolSize();
        }
        return retval;
    }

    @Override
    public long getMasterConnectionsFetched() {
        return ReplicationMonitor.getMasterConnectionsFetched();
    }

    @Override
    public long getSlaveConnectionsFetched() {
        return ReplicationMonitor.getSlaveConnectionsFetched();
    }

    @Override
    public long getMasterInsteadOfSlave() {
        return ReplicationMonitor.getMasterInsteadOfSlave();
    }
}

