/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.internal.ConfigDatabaseAssignmentImpl;
import com.openexchange.database.internal.ConfigDatabaseLifeCycle;
import com.openexchange.database.internal.ConfigDatabaseServiceImpl;
import com.openexchange.database.internal.Configuration;
import com.openexchange.database.internal.ContextDatabaseAssignmentImpl;
import com.openexchange.database.internal.ContextDatabaseLifeCycle;
import com.openexchange.database.internal.DatabaseServiceImpl;
import com.openexchange.database.internal.Management;
import com.openexchange.database.internal.Overview;
import com.openexchange.database.internal.Pools;
import com.openexchange.database.internal.Server;
import com.openexchange.database.internal.Timer;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;

public final class Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Initialization.class));
    private static final Initialization SINGLETON = new Initialization();
    private CacheService cacheService;
    private final Management management = new Management();
    private final Timer timer = new Timer();
    private final Configuration configuration = new Configuration();
    private Pools pools;
    private ContextDatabaseAssignmentImpl contextAssignment;
    private ConfigDatabaseServiceImpl configDatabaseService;
    private volatile DatabaseServiceImpl databaseService;

    private Initialization() {
    }

    public static final Initialization getInstance() {
        return SINGLETON;
    }

    public boolean isStarted() {
        return null != this.pools;
    }

    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    public DatabaseService start(ConfigurationService configurationService) throws OXException {
        return this.start0(configurationService, false);
    }

    public DatabaseService startIfAbsent(ConfigurationService configurationService) throws OXException {
        return this.start0(configurationService, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseService start0(ConfigurationService configurationService, boolean returnIfPresent) throws OXException {
        Management management = this.management;
        synchronized (management) {
            if (null != this.pools) {
                if (returnIfPresent) {
                    return this.databaseService;
                }
                throw DBPoolingExceptionCodes.ALREADY_INITIALIZED.create(new Object[]{Initialization.class.getName()});
            }
            this.configuration.readConfiguration(configurationService);
            this.timer.configure(this.configuration);
            this.pools = new Pools(this.timer);
            this.management.addOverview(new Overview(this.pools));
            ConfigDatabaseLifeCycle configDBLifeCycle = new ConfigDatabaseLifeCycle(this.configuration, this.management, this.timer);
            this.pools.addLifeCycle(configDBLifeCycle);
            this.configDatabaseService = new ConfigDatabaseServiceImpl(new ConfigDatabaseAssignmentImpl(), this.pools);
            this.contextAssignment = new ContextDatabaseAssignmentImpl(this.configDatabaseService);
            if (null != this.cacheService) {
                this.contextAssignment.setCacheService(this.cacheService);
            }
            ContextDatabaseLifeCycle contextDBLifeCycle = new ContextDatabaseLifeCycle(this.configuration, this.management, this.timer, this.configDatabaseService);
            this.pools.addLifeCycle(contextDBLifeCycle);
            Server.setConfigDatabaseService(this.configDatabaseService);
            Server.start(configurationService);
            try {
                LOG.info((Object)("Resolved server name \"" + Server.getServerName() + "\" to identifier " + Server.getServerId()));
            }
            catch (OXException e) {
                LOG.warn((Object)"Resolving server name to an identifier failed. This is normal until a server has been registered.", (Throwable)e);
            }
            this.databaseService = new DatabaseServiceImpl(this.pools, this.configDatabaseService, this.contextAssignment);
            return this.databaseService;
        }
    }

    public void stop() {
        this.databaseService = null;
        this.contextAssignment.removeCacheService();
        this.contextAssignment = null;
        this.configDatabaseService = null;
        this.pools.stop(this.timer);
        this.pools = null;
        this.configuration.clear();
    }

    public void setCacheService(CacheService service) {
        this.cacheService = service;
        if (null != this.contextAssignment) {
            this.contextAssignment.setCacheService(service);
        }
    }

    public void removeCacheService() {
        this.cacheService = null;
        if (null != this.contextAssignment) {
            this.contextAssignment.removeCacheService();
        }
    }

    public Management getManagement() {
        return this.management;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

