/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.pooling.PoolableLifecycle;
import com.openexchange.pooling.PooledData;
import com.openexchange.tools.sql.DBUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

class ConnectionLifecycle
implements PoolableLifecycle<Connection> {
    private static final String TEST_SELECT = "SELECT 1 AS test";
    private final String url;
    private final Properties info;
    private final long checkTime = 120000L;

    public ConnectionLifecycle(String url, Properties info) {
        this.url = url;
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activate(PooledData<Connection> data) {
        boolean retval;
        Connection con = data.getPooled();
        Statement stmt = null;
        ResultSet result = null;
        try {
            boolean bl = retval = !con.isClosed();
            if (data.getTimeDiff() > 120000L) {
                stmt = con.createStatement();
                result = stmt.executeQuery(TEST_SELECT);
                retval = result.next() ? result.getInt(1) == 1 : false;
            }
            DBUtils.closeSQLStuff(result, stmt);
        }
        catch (SQLException e) {
            retval = false;
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
        return retval;
    }

    @Override
    public Connection create() throws SQLException {
        return DriverManager.getConnection(this.url, this.info);
    }

    public Connection createWithoutTimeout() throws SQLException {
        Properties withoutTimeout = new Properties();
        withoutTimeout.putAll((Map<?, ?>)this.info);
        Iterator<Object> iter = withoutTimeout.keySet().iterator();
        while (iter.hasNext()) {
            Object test = iter.next();
            if (!String.class.isAssignableFrom(test.getClass()) || !((String)test).toLowerCase().endsWith("timeout")) continue;
            iter.remove();
        }
        return DriverManager.getConnection(this.url, withoutTimeout);
    }

    @Override
    public boolean deactivate(PooledData<Connection> data) {
        boolean retval = true;
        try {
            retval = !data.getPooled().isClosed();
        }
        catch (SQLException e) {
            retval = false;
        }
        return retval;
    }

    @Override
    public void destroy(Connection obj) {
        try {
            obj.close();
        }
        catch (SQLException e) {
            ConnectionPool.LOG.debug((Object)"Problem while closing connection.", (Throwable)e);
        }
    }

    private static void addTrace(OXException dbe, PooledData<Connection> data) {
        if (null != data.getTrace()) {
            dbe.setStackTrace(data.getTrace());
        }
    }

    @Override
    public boolean validate(PooledData<Connection> data) {
        Connection con = data.getPooled();
        boolean retval = true;
        try {
            if (con.isClosed()) {
                ConnectionPool.LOG.error((Object)"Found closed connection.");
                retval = false;
            } else if (!con.getAutoCommit()) {
                OXException dbe = DBPoolingExceptionCodes.NO_AUTOCOMMIT.create();
                ConnectionLifecycle.addTrace(dbe, data);
                ConnectionPool.LOG.error((Object)dbe.getMessage(), (Throwable)dbe);
                con.rollback();
                con.setAutoCommit(true);
            }
            Class<?> connectionClass = con.getClass();
            try {
                Method method = connectionClass.getMethod("getActiveStatementCount", new Class[0]);
                int active = (Integer)method.invoke((Object)con, new Object[0]);
                if (active > 0) {
                    OXException dbe = DBPoolingExceptionCodes.ACTIVE_STATEMENTS.create(new Object[]{Autoboxing.I((int)active)});
                    ConnectionLifecycle.addTrace(dbe, data);
                    ConnectionPool.LOG.error((Object)dbe.getMessage(), (Throwable)dbe);
                    retval = false;
                }
            }
            catch (Exception e) {
                ConnectionPool.LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (data.getTimeDiff() > 2000L) {
                OXException dbe = DBPoolingExceptionCodes.TOO_LONG.create(new Object[]{Autoboxing.L((long)data.getTimeDiff())});
                ConnectionLifecycle.addTrace(dbe, data);
                if (ConnectionPool.LOG.isWarnEnabled()) {
                    ConnectionPool.LOG.warn((Object)dbe.getMessage(), (Throwable)dbe);
                }
            }
        }
        catch (SQLException e) {
            retval = false;
        }
        return retval;
    }

    @Override
    public String getObjectName() {
        return "Database connection";
    }
}

