/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.internal.Configuration;
import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.database.internal.Management;
import com.openexchange.database.internal.PoolLifeCycle;
import com.openexchange.database.internal.Timer;
import com.openexchange.exception.OXException;
import javax.mail.internet.IDNA;

public final class ConfigDatabaseLifeCycle
implements PoolLifeCycle {
    private final ConnectionPool configDBWrite;
    private final ConnectionPool configDBRead;

    ConfigDatabaseLifeCycle(Configuration configuration, Management management, Timer timer) {
        this.configDBWrite = new ConnectionPool(IDNA.toASCII((String)configuration.getWriteUrl()), configuration.getWriteProps(), configuration.getPoolConfig());
        timer.addTask(this.configDBWrite.getCleanerTask());
        management.addPool(-2, this.configDBWrite);
        this.configDBRead = new ConnectionPool(IDNA.toASCII((String)configuration.getReadUrl()), configuration.getReadProps(), configuration.getPoolConfig());
        timer.addTask(this.configDBRead.getCleanerTask());
        management.addPool(-1, this.configDBRead);
    }

    @Override
    public ConnectionPool create(int poolId) throws OXException {
        switch (poolId) {
            case -2: {
                return this.configDBWrite;
            }
            case -1: {
                return this.configDBRead;
            }
        }
        return null;
    }

    @Override
    public boolean destroy(int poolId) {
        return poolId == -2 || poolId == -1;
    }
}

