/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.ContactFieldOperand;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.internal.Check;
import com.openexchange.contact.internal.DefaultContactService;
import com.openexchange.contact.internal.QueryFields;
import com.openexchange.contact.internal.ResultIterator;
import com.openexchange.contact.internal.SearchTermAnalyzer;
import com.openexchange.contact.internal.Tools;
import com.openexchange.contact.internal.mapping.ContactMapper;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.ContactMergerator;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ConstantOperand;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ContactServiceImpl
extends DefaultContactService {
    private static final String GAB = Integer.toString(6);

    @Override
    protected void doCreateContact(Session session, String folderID, Contact contact) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        Check.validateProperties(contact);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canCreateObjects(permission, session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        Check.noPrivateInPublic(folder, contact, session);
        Check.canWriteInGAB(storage, session, folderID, contact);
        Date now = new Date();
        contact.setParentFolderID(Tools.parse(folderID));
        contact.setContextId(contextID);
        contact.setLastModified(now);
        contact.setCreationDate(now);
        contact.setCreatedBy(userID);
        contact.setModifiedBy(userID);
        contact.removeObjectID();
        contact.setNumberOfAttachments(0);
        contact.setUseCount(0);
        if (contact.containsImage1()) {
            contact.setImageLastModified(now);
            if (null != contact.getImage1()) {
                contact.setNumberOfImages(1);
            } else {
                contact.setNumberOfImages(0);
                contact.setImageContentType(null);
            }
        }
        if (!contact.containsUid() || Tools.isEmpty(contact.getUid())) {
            contact.setUid(UUID.randomUUID().toString());
        }
        if (!contact.containsFileAs() && contact.containsDisplayName()) {
            contact.setFileAs(contact.getDisplayName());
        }
        storage.create(session, folderID, contact);
        new EventClient(session).create(contact, folder);
    }

    @Override
    protected void doUpdateAndMoveContact(Session session, String sourceFolderId, String targetFolderId, String objectID, Contact contact, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactMapper.getInstance().validateAll(contact);
        if (contact.containsObjectID() && contact.getObjectID() > 0 && !Integer.toString(contact.getObjectID()).equals(objectID)) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        FolderObject sourceFolder = Tools.getFolder(contextID, sourceFolderId);
        Check.isContactFolder(sourceFolder, session);
        EffectivePermission sourceFolderPermission = Tools.getPermission(contextID, sourceFolderId, userID);
        Check.canDeleteOwn(sourceFolderPermission, session, sourceFolderId);
        FolderObject targetFolder = Tools.getFolder(contextID, targetFolderId);
        Check.isContactFolder(targetFolder, session);
        Check.noPrivateInPublic(targetFolder, contact, session);
        EffectivePermission targetFolderPermission = Tools.getPermission(contextID, targetFolderId, userID);
        Check.canCreateObjects(targetFolderPermission, session, targetFolderId);
        ContactStorage sourceStorage = Tools.getStorage(session, sourceFolderId);
        Contact storedContact = sourceStorage.get(session, sourceFolderId, objectID, ContactField.values());
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            Check.canDeleteAll(sourceFolderPermission, session, sourceFolderId);
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        Check.folderEquals(storedContact, sourceFolderId, contextID);
        Contact delta = (Contact)ContactMapper.getInstance().getDifferences(storedContact, contact);
        if (delta.containsContextId() && delta.getContextId() > 0) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsObjectID() && delta.getObjectID() > 0) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsUid() && !Tools.isEmpty(storedContact.getUid())) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsCreatedBy()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsCreationDate()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsPrivateFlag() && delta.getPrivateFlag() && storedContact.getModifiedBy() != userID) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        Date now = new Date();
        delta.setLastModified(now);
        delta.setModifiedBy(userID);
        delta.setParentFolderID(Tools.parse(targetFolderId));
        if (!(storedContact.containsUid() && !Tools.isEmpty(storedContact.getUid()) || delta.containsUid())) {
            delta.setUid(UUID.randomUUID().toString());
        }
        if (delta.containsImage1()) {
            delta.setImageLastModified(now);
            if (null != delta.getImage1()) {
                delta.setNumberOfImages(1);
            } else {
                delta.setNumberOfImages(0);
                delta.setImageContentType(null);
            }
        }
        Tools.invalidateAddressesIfNeeded(delta);
        ContactStorage targetStorage = Tools.getStorage(session, targetFolderId);
        if (sourceStorage.equals(targetStorage)) {
            sourceStorage.update(session, sourceFolderId, objectID, delta, lastRead);
        } else {
            ContactMapper.getInstance().mergeDifferences(storedContact, delta);
            targetStorage.create(session, targetFolderId, storedContact);
            try {
                sourceStorage.delete(session, sourceFolderId, objectID, lastRead);
            }
            catch (OXException e) {
                LOG.warn((Object)"error deleting contact from source folder, rolling back move operation", (Throwable)e);
                targetStorage.delete(session, targetFolderId, Integer.toString(storedContact.getObjectID()), storedContact.getLastModified());
                throw e;
            }
        }
        ContactMapper.getInstance().mergeDifferences(contact, delta);
        contact.setObjectID(storedContact.getObjectID());
        contact.setParentFolderID(storedContact.getParentFolderID());
        for (ContactStorage contactStorage : Tools.getStorages(session)) {
            contactStorage.updateReferences(session, contact);
        }
        new EventClient(session).modify(storedContact, contact, targetFolder);
    }

    @Override
    protected void doUpdateContact(Session session, String folderID, String objectID, Contact contact, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        Check.validateProperties(contact);
        if (contact.containsObjectID() && contact.getObjectID() > 0 && !Integer.toString(contact.getObjectID()).equals(objectID)) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        try {
            Check.canWriteOwn(permission, session);
        }
        catch (OXException e) {
            if (!(GAB.equals(folderID) && ContactExceptionCodes.NO_CHANGE_PERMISSION.equals(e) && OXFolderProperties.isEnableInternalUsersEdit())) {
                throw e;
            }
            OXFolderProperties.updatePermissions(true, contextID);
            permission = Tools.getPermission(contextID, folderID, userID);
            Check.canWriteOwn(permission, session);
        }
        Contact storedContact = storage.get(session, folderID, objectID, ContactField.values());
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            Check.canWriteAll(permission, session);
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        Check.folderEquals(storedContact, folderID, contextID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        Check.noPrivateInPublic(folder, contact, session);
        Check.canWriteInGAB(storage, session, folderID, contact);
        Contact delta = (Contact)ContactMapper.getInstance().getDifferences(storedContact, contact);
        if (delta.containsContextId() && delta.getContextId() > 0) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsObjectID() && delta.getObjectID() > 0) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsUid() && !Tools.isEmpty(storedContact.getUid())) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsCreatedBy()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsCreationDate()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsParentFolderID()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (delta.containsPrivateFlag() && delta.getPrivateFlag() && storedContact.getModifiedBy() != userID) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        Date now = new Date();
        delta.setLastModified(now);
        delta.setModifiedBy(userID);
        if (!(storedContact.containsUid() && !Tools.isEmpty(storedContact.getUid()) || delta.containsUid())) {
            delta.setUid(UUID.randomUUID().toString());
        }
        if (delta.containsImage1()) {
            delta.setImageLastModified(now);
            if (null != delta.getImage1()) {
                delta.setNumberOfImages(1);
            } else {
                delta.setNumberOfImages(0);
                delta.setImageContentType(null);
            }
        }
        Tools.invalidateAddressesIfNeeded(delta);
        storage.update(session, folderID, objectID, delta, lastRead);
        ContactMapper.getInstance().mergeDifferences(contact, delta);
        contact.setObjectID(storedContact.getObjectID());
        contact.setParentFolderID(storedContact.getParentFolderID());
        for (ContactStorage contactStorage : Tools.getStorages(session)) {
            contactStorage.updateReferences(session, contact);
        }
        new EventClient(session).modify(storedContact, contact, folder);
    }

    @Override
    protected void doDeleteContact(Session session, String folderID, String objectID, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canDeleteOwn(permission, session, folderID);
        Contact storedContact = storage.get(session, folderID, objectID, new ContactField[]{ContactField.CREATED_BY, ContactField.LAST_MODIFIED});
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            Check.canDeleteAll(permission, session, folderID);
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        storage.delete(session, folderID, objectID, lastRead);
        storedContact.setContextId(contextID);
        storedContact.setParentFolderID(Tools.parse(folderID));
        storedContact.setObjectID(Tools.parse(objectID));
        new EventClient(session).delete(storedContact, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeleteContacts(Session session, String folderID, String[] objectIDs, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canDeleteOwn(permission, session, folderID);
        SearchIterator<Contact> contacts2 = null;
        ArrayList<Contact> storedContacts = new ArrayList<Contact>();
        try {
            contacts2 = storage.list(session, folderID, objectIDs, new ContactField[]{ContactField.CREATED_BY, ContactField.LAST_MODIFIED, ContactField.OBJECT_ID});
            while (contacts2.hasNext()) {
                Contact storedContact = (Contact)contacts2.next();
                if (storedContact.getCreatedBy() != userID) {
                    Check.canDeleteAll(permission, session, folderID);
                }
                Check.lastModifiedBefore(storedContact, lastRead);
                storedContacts.add(storedContact);
            }
        }
        finally {
            if (null != contacts2) {
                try {
                    contacts2.close();
                }
                catch (OXException e) {
                    LOG.warn((Object)"error closing iterator", (Throwable)e);
                }
            }
        }
        for (String objectID : objectIDs) {
            boolean found = false;
            for (Contact contact : storedContacts) {
                if (contact.getObjectID() != Tools.parse(objectID)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Tools.parse(objectID), contextID);
        }
        storage.delete(session, folderID, objectIDs, lastRead);
        EventClient eventClient = new EventClient(session);
        for (Contact storedContact : storedContacts) {
            storedContact.setContextId(contextID);
            storedContact.setParentFolderID(Tools.parse(folderID));
            storedContact.setObjectID(storedContact.getObjectID());
            eventClient.delete(storedContact, folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeleteContacts(Session session, String folderID) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canDeleteAll(permission, session, folderID);
        ArrayList<Contact> storedContacts = new ArrayList<Contact>();
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = storage.all(session, folderID, new ContactField[]{ContactField.CREATED_BY, ContactField.OBJECT_ID});
            if (null != searchIterator) {
                while (searchIterator.hasNext()) {
                    Contact storedContact = (Contact)searchIterator.next();
                    storedContacts.add(storedContact);
                }
            }
        }
        finally {
            if (null != searchIterator) {
                try {
                    searchIterator.close();
                }
                catch (OXException e) {
                    LOG.warn((Object)"error closing iterator", (Throwable)e);
                }
            }
        }
        storage.delete(session, folderID);
        EventClient eventClient = new EventClient(session);
        Date now = new Date();
        for (Contact contact : storedContacts) {
            contact.setContextId(contextID);
            contact.setParentFolderID(Tools.parse(folderID));
            contact.setLastModified(now);
            contact.setModifiedBy(userID);
            eventClient.delete(contact, folder);
        }
    }

    @Override
    protected <O> SearchIterator<Contact> doGetContacts(boolean deleted, Session session, String folderID, String[] ids, ContactField[] fields, SortOptions sortOptions, Date since) throws OXException {
        int contextID = session.getContextId();
        FolderObject folder = Tools.getFolder(contextID, folderID, deleted);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(session, folder);
        Check.canReadOwn(permission, session, folderID);
        QueryFields queryFields = new QueryFields(fields);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        ContactStorage storage = Tools.getStorage(session, folderID);
        SearchIterator<Contact> contacts2 = null;
        contacts2 = null != since ? (deleted ? storage.deleted(session, folderID, since, queryFields.getFields(), sortOptions) : storage.modified(session, folderID, since, queryFields.getFields(), sortOptions)) : (null != ids ? storage.list(session, folderID, ids, queryFields.getFields(), sortOptions) : storage.all(session, folderID, queryFields.getFields(), sortOptions));
        if (null == contacts2) {
            throw ContactExceptionCodes.UNEXPECTED_ERROR.create("got no results from storage");
        }
        return new ResultIterator(contacts2, queryFields.needsAttachmentInfo(), session, permission.canReadAllObjects());
    }

    @Override
    protected <O> SearchIterator<Contact> doSearchContacts(Session session, SearchTerm<O> term, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        SearchTermAnalyzer termAnanlyzer = new SearchTermAnalyzer(term);
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, termAnanlyzer.hasFolderIDs() ? termAnanlyzer.getFolderIDs() : Tools.getSearchFolders(contextID, userID));
        if (null == queriedStorages || 0 == queriedStorages.size()) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{"No contact storage found for queried folder IDs"});
        }
        QueryFields queryFields = new QueryFields(fields);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        ArrayList<SearchIterator<Contact>> searchIterators = new ArrayList<SearchIterator<Contact>>();
        for (Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            CompositeSearchTerm searchTerm;
            if (termAnanlyzer.hasFolderIDs()) {
                searchTerm = term;
            } else {
                CompositeSearchTerm combinedTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
                combinedTerm.addSearchTerm(Tools.getFoldersTerm(queriedStorage.getValue()));
                combinedTerm.addSearchTerm(term);
                searchTerm = combinedTerm;
            }
            SearchIterator<Contact> searchIterator = queriedStorage.getKey().search(session, searchTerm, queryFields.getFields(), sortOptions);
            searchIterators.add(new ResultIterator(searchIterator, queryFields.needsAttachmentInfo(), session));
        }
        return 2 > searchIterators.size() ? (SearchIterator)searchIterators.get(0) : new ContactMergerator(Tools.getComparator(sortOptions), searchIterators);
    }

    @Override
    protected SearchIterator<Contact> doSearchContacts(Session session, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        Check.validateSearch(contactSearch);
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, contactSearch.hasFolders() ? Tools.toStringList(contactSearch.getFolders()) : Tools.getSearchFolders(contextID, userID));
        if (null == queriedStorages || 0 == queriedStorages.size()) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{"No contact storage found for queried folder IDs"});
        }
        QueryFields queryFields = new QueryFields(fields);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        ArrayList<SearchIterator<Contact>> searchIterators = new ArrayList<SearchIterator<Contact>>();
        for (Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            contactSearch.setFolders(Tools.parse(queriedStorage.getValue()));
            SearchIterator<Contact> searchIterator = queriedStorage.getKey().search(session, contactSearch, queryFields.getFields(), sortOptions);
            searchIterators.add(new ResultIterator(searchIterator, queryFields.needsAttachmentInfo(), session));
        }
        return 2 > searchIterators.size() ? (SearchIterator)searchIterators.get(0) : new ContactMergerator(Tools.getComparator(sortOptions), searchIterators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doGetOrganization(Session session) throws OXException {
        int userID = Tools.getContext(session).getMailadmin();
        String folderID = Integer.toString(6);
        ContactStorage storage = Tools.getStorage(session, folderID);
        CompositeSearchTerm searchTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
        SingleSearchTerm folderIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
        folderIDTerm.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
        folderIDTerm.addOperand(new ConstantOperand<String>(folderID));
        searchTerm.addSearchTerm(folderIDTerm);
        SingleSearchTerm userIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
        userIDTerm.addOperand(new ContactFieldOperand(ContactField.INTERNAL_USERID));
        userIDTerm.addOperand(new ConstantOperand<Integer>(userID));
        searchTerm.addSearchTerm(userIDTerm);
        Contact contact = null;
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = storage.search(session, searchTerm, new ContactField[]{ContactField.COMPANY});
            if (null != searchIterator && searchIterator.hasNext()) {
                contact = (Contact)searchIterator.next();
            }
        }
        finally {
            if (null != searchIterator) {
                try {
                    searchIterator.close();
                }
                catch (OXException e) {
                    LOG.debug((Object)"error closing search iterator", (Throwable)e);
                }
            }
        }
        Check.contactNotNull(contact, session.getContextId(), userID);
        return contact.getCompany();
    }

    @Override
    protected <O> SearchIterator<Contact> doGetUsers(Session session, int[] userIDs, SearchTerm<O> term, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int currentUserID = session.getUserId();
        int contextID = session.getContextId();
        String folderID = Integer.toString(6);
        ContactStorage storage = Tools.getStorage(session, folderID);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, currentUserID);
        QueryFields queryFields = permission.canReadAllObjects() || permission.canReadOwnObjects() && 1 == userIDs.length && currentUserID == userIDs[0] ? new QueryFields(fields) : new QueryFields(fields, LIMITED_USER_FIELDS);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        CompositeSearchTerm searchTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
        SingleSearchTerm folderIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
        folderIDTerm.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
        folderIDTerm.addOperand(new ConstantOperand<String>(folderID));
        searchTerm.addSearchTerm(folderIDTerm);
        if (null == userIDs || 0 == userIDs.length) {
            SingleSearchTerm userIDsTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.GREATER_THAN);
            userIDsTerm.addOperand(new ContactFieldOperand(ContactField.INTERNAL_USERID));
            userIDsTerm.addOperand(new ConstantOperand<Integer>(0));
            searchTerm.addSearchTerm(userIDsTerm);
        } else if (1 == userIDs.length) {
            SingleSearchTerm userIDsTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
            userIDsTerm.addOperand(new ContactFieldOperand(ContactField.INTERNAL_USERID));
            userIDsTerm.addOperand(new ConstantOperand<Integer>(userIDs[0]));
            searchTerm.addSearchTerm(userIDsTerm);
        } else {
            CompositeSearchTerm userIDsTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
            for (int userID : userIDs) {
                SingleSearchTerm userIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
                userIDTerm.addOperand(new ContactFieldOperand(ContactField.INTERNAL_USERID));
                userIDTerm.addOperand(new ConstantOperand<Integer>(userID));
                userIDsTerm.addSearchTerm(userIDTerm);
            }
            searchTerm.addSearchTerm(userIDsTerm);
        }
        if (null != term) {
            searchTerm.addSearchTerm(term);
        }
        return new ResultIterator(storage.search(session, searchTerm, queryFields.getFields(), sortOptions), queryFields.needsAttachmentInfo(), session, true);
    }

    @Override
    protected SearchIterator<Contact> doGetUsers(Session session, int[] userIDs, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int currentUserID = session.getUserId();
        int contextID = session.getContextId();
        String folderID = Integer.toString(6);
        ContactStorage storage = Tools.getStorage(session, folderID);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, currentUserID);
        QueryFields queryFields = permission.canReadAllObjects() || permission.canReadOwnObjects() && 1 == userIDs.length && currentUserID == userIDs[0] ? new QueryFields(fields) : new QueryFields(fields, LIMITED_USER_FIELDS);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        return new ResultIterator(storage.search(session, contactSearch, queryFields.getFields(), sortOptions), queryFields.needsAttachmentInfo(), session, true);
    }

    @Override
    protected SearchIterator<Contact> doSearchContactsWithBirthday(Session session, Date from, Date until, List<String> folderIDs, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, null == folderIDs ? Tools.getVisibleFolders(contextID, userID) : folderIDs);
        if (null == queriedStorages || 0 == queriedStorages.size()) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{"No contact storage found for queried folder IDs"});
        }
        QueryFields queryFields = new QueryFields(fields);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        ArrayList<SearchIterator<Contact>> searchIterators = new ArrayList<SearchIterator<Contact>>();
        for (Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            SearchIterator<Contact> searchIterator = queriedStorage.getKey().searchByBirthday(session, queriedStorage.getValue(), from, until, queryFields.getFields(), sortOptions);
            searchIterators.add(new ResultIterator(searchIterator, queryFields.needsAttachmentInfo(), session));
        }
        return 2 > searchIterators.size() ? (SearchIterator)searchIterators.get(0) : new ContactMergerator(Tools.getComparator(sortOptions), searchIterators);
    }

    @Override
    protected SearchIterator<Contact> doSearchContactsWithAnniversary(Session session, Date from, Date until, List<String> folderIDs, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, null == folderIDs ? Tools.getVisibleFolders(contextID, userID) : folderIDs);
        if (null == queriedStorages || 0 == queriedStorages.size()) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{"No contact storage found for queried folder IDs"});
        }
        QueryFields queryFields = new QueryFields(fields);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        ArrayList<SearchIterator<Contact>> searchIterators = new ArrayList<SearchIterator<Contact>>();
        for (Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            SearchIterator<Contact> searchIterator = queriedStorage.getKey().searchByAnniversary(session, queriedStorage.getValue(), from, until, queryFields.getFields(), sortOptions);
            searchIterators.add(new ResultIterator(searchIterator, queryFields.needsAttachmentInfo(), session));
        }
        return 2 > searchIterators.size() ? (SearchIterator)searchIterators.get(0) : new ContactMergerator(Tools.getComparator(sortOptions), searchIterators);
    }
}

