/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.ContactFieldOperand;
import com.openexchange.contact.internal.Tools;
import com.openexchange.contact.internal.mapping.ContactMapper;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.Search;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ConstantOperand;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;

public final class Check {
    public static void argNotNull(Object object, String argumentName) {
        if (null == object) {
            throw new IllegalArgumentException("the passed argument '" + argumentName + "' may not be null");
        }
    }

    public static void validateProperties(Contact contact) throws OXException {
        ContactMapper.getInstance().validateAll(contact);
    }

    public static void isNotPrivate(Contact contact, Session session, String folderID) throws OXException {
        if (contact.containsPrivateFlag()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canReadOwn(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canReadOwnObjects()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canWriteOwn(EffectivePermission permission, Session session) throws OXException {
        if (!permission.canWriteOwnObjects()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(session.getUserId(), session.getContextId());
        }
    }

    public static void canWriteAll(EffectivePermission permission, Session session) throws OXException {
        if (!permission.canWriteAllObjects()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(session.getUserId(), session.getContextId());
        }
    }

    public static void canReadAll(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canReadAllObjects()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canCreateObjects(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canCreateObjects()) {
            throw ContactExceptionCodes.NO_CREATE_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canDeleteOwn(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canDeleteOwnObjects()) {
            throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canDeleteAll(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canDeleteAllObjects()) {
            throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void isContactFolder(FolderObject folder, Session session) throws OXException {
        if (3 != folder.getModule()) {
            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(folder.getObjectID(), session.getContextId(), session.getUserId());
        }
    }

    public static void contactNotNull(Contact contact, int contextID, int id) throws OXException {
        if (null == contact) {
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(id, contextID);
        }
    }

    public static void lastModifiedBefore(Contact contact, Date lastRead) throws OXException {
        if (lastRead.before(contact.getLastModified())) {
            throw ContactExceptionCodes.OBJECT_HAS_CHANGED.create();
        }
    }

    public static void folderEquals(Contact contact, String folderID, int contextID) throws OXException {
        if (contact.getParentFolderID() != Tools.parse(folderID)) {
            throw ContactExceptionCodes.NOT_IN_FOLDER.create(contact.getObjectID(), Tools.parse(folderID), contextID);
        }
    }

    public static void noPrivateInPublic(FolderObject folder, Contact contact, Session session) throws OXException {
        if (2 == folder.getType() && contact.getPrivateFlag()) {
            throw ContactExceptionCodes.PFLAG_IN_PUBLIC_FOLDER.create(folder.getObjectID(), session.getContextId(), session.getUserId());
        }
    }

    public static void validateSearch(ContactSearchObject contactSearch) throws OXException {
        Search.checkPatternLength(contactSearch);
        if (0 != contactSearch.getIgnoreOwn() || null != contactSearch.getAnniversaryRange() || null != contactSearch.getBirthdayRange() || null != contactSearch.getBusinessPostalCodeRange() || null != contactSearch.getCreationDateRange() || null != contactSearch.getDynamicSearchField() || null != contactSearch.getDynamicSearchFieldValue() || null != contactSearch.getFrom() || null != contactSearch.getLastModifiedRange() || null != contactSearch.getNumberOfEmployeesRange() || null != contactSearch.getSalesVolumeRange() || null != contactSearch.getOtherPostalCodeRange() || null != contactSearch.getPrivatePostalCodeRange()) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void canWriteInGAB(ContactStorage storage, Session session, String folderID, Contact update) throws OXException {
        if (6 == Tools.parse(folderID)) {
            Context context;
            if (update.containsDisplayName()) {
                if (Tools.isEmpty(update.getDisplayName())) {
                    throw ContactExceptionCodes.DISPLAY_NAME_MANDATORY.create();
                }
                CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
                SingleSearchTerm folderIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
                folderIDTerm.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
                folderIDTerm.addOperand(new ConstantOperand<String>(folderID));
                andTerm.addSearchTerm(folderIDTerm);
                SingleSearchTerm displayNameTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
                displayNameTerm.addOperand(new ContactFieldOperand(ContactField.DISPLAY_NAME));
                displayNameTerm.addOperand(new ConstantOperand<String>(update.getDisplayName()));
                andTerm.addSearchTerm(displayNameTerm);
                SingleSearchTerm objectIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.NOT_EQUALS);
                objectIDTerm.addOperand(new ContactFieldOperand(ContactField.OBJECT_ID));
                objectIDTerm.addOperand(new ConstantOperand<Integer>(update.getObjectID()));
                andTerm.addSearchTerm(objectIDTerm);
                SearchIterator<Contact> searchIterator = null;
                try {
                    searchIterator = storage.search(session, andTerm, new ContactField[]{ContactField.OBJECT_ID});
                    if (searchIterator.hasNext()) {
                        throw ContactExceptionCodes.DISPLAY_NAME_IN_USE.create(session.getContextId(), update.getObjectID());
                    }
                }
                finally {
                    if (null != searchIterator) {
                        searchIterator.close();
                    }
                }
            }
            if (update.containsSurName() && Tools.isEmpty(update.getSurName())) {
                throw ContactExceptionCodes.LAST_NAME_MANDATORY.create();
            }
            if (update.containsGivenName() && Tools.isEmpty(update.getGivenName())) {
                throw ContactExceptionCodes.FIRST_NAME_MANDATORY.create();
            }
            if (update.containsEmail1() && (context = Tools.getContext(session)).getMailadmin() != session.getUserId()) {
                throw ContactExceptionCodes.NO_PRIMARY_EMAIL_EDIT.create(session.getContextId(), update.getObjectID(), session.getUserId());
            }
        }
    }

    private Check() {
    }
}

