/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.TimedWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.MetadataSwitcher;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONWriter;

public class InfostoreWriter
extends TimedWriter<DocumentMetadata> {
    public static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreWriter.class));

    public InfostoreWriter(JSONWriter w) {
        super(w);
    }

    public void writeMetadata(SearchIterator<DocumentMetadata> iter, Metadata[] cols, TimeZone tz) throws JSONException, OXException {
        this.jsonWriter.array();
        this.fillArray(iter, (Object[])cols, tz);
        this.jsonWriter.endArray();
    }

    @Override
    protected void fillArray(SearchIterator<DocumentMetadata> iter, Object[] cols, TimeZone tz) throws JSONException, OXException {
        WriterSwitch sw = new WriterSwitch(this.jsonWriter, tz);
        while (iter.hasNext()) {
            sw.setDocumentMetadata((DocumentMetadata)iter.next());
            this.jsonWriter.array();
            for (Metadata column : (Metadata[])cols) {
                column.doSwitch(sw);
            }
            this.jsonWriter.endArray();
        }
    }

    public void write(DocumentMetadata dm, TimeZone tz) throws JSONException {
        this.jsonWriter.object();
        WriterSwitch w = new WriterSwitch(this.jsonWriter, tz);
        w.setDocumentMetadata(dm);
        for (Metadata metadata : Metadata.HTTPAPI_VALUES) {
            w.setMetadata(metadata);
            metadata.doSwitch(w);
        }
        this.jsonWriter.endObject();
    }

    @Override
    protected int getId(Object object) {
        return ((DocumentMetadata)object).getId();
    }

    private static final class WriterSwitch
    implements MetadataSwitcher {
        private DocumentMetadata dm;
        private final JSONWriter writer;
        private final TimeZone tz;

        public WriterSwitch(JSONWriter writer, TimeZone tz) {
            this.writer = writer;
            this.tz = tz;
        }

        public void setDocumentMetadata(DocumentMetadata dm) {
            this.dm = dm;
        }

        public void setMetadata(Metadata current) {
            try {
                this.writer.key(current.getName());
            }
            catch (JSONException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }

        @Override
        public Object lastModified() {
            this.writeDate(this.dm.getLastModified());
            return null;
        }

        @Override
        public Object creationDate() {
            this.writeDate(this.dm.getCreationDate());
            return null;
        }

        @Override
        public Object modifiedBy() {
            this.writeId(this.dm.getModifiedBy());
            return null;
        }

        @Override
        public Object folderId() {
            this.writeId(this.dm.getFolderId());
            return null;
        }

        @Override
        public Object title() {
            this.writeString(this.dm.getTitle());
            return null;
        }

        @Override
        public Object version() {
            this.writeInteger(this.dm.getVersion());
            return null;
        }

        @Override
        public Object content() {
            this.writeString(this.dm.getContent());
            return null;
        }

        @Override
        public Object id() {
            this.writeId(this.dm.getId());
            return null;
        }

        @Override
        public Object fileSize() {
            this.writeInteger(this.dm.getFileSize());
            return null;
        }

        @Override
        public Object description() {
            this.writeString(this.dm.getDescription());
            return null;
        }

        @Override
        public Object url() {
            this.writeString(this.dm.getURL());
            return null;
        }

        @Override
        public Object createdBy() {
            this.writeId(this.dm.getCreatedBy());
            return null;
        }

        @Override
        public Object fileName() {
            this.writeString(this.dm.getFileName());
            return null;
        }

        @Override
        public Object fileMIMEType() {
            this.writeString(this.dm.getFileMIMEType());
            return null;
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object categories() {
            String categoriesString = this.dm.getCategories();
            if (categoriesString == null || categoriesString.equals("")) {
                try {
                    this.writer.array();
                    this.writer.endArray();
                }
                catch (JSONException e) {
                    LOG.debug((Object)"", (Throwable)e);
                }
                return null;
            }
            String[] categoriesArray = categoriesString.split("\\s*,\\s*");
            try {
                this.writer.array();
                for (String cat : categoriesArray) {
                    this.writer.value((Object)cat);
                }
                this.writer.endArray();
            }
            catch (JSONException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
            return null;
        }

        @Override
        public Object versionComment() {
            this.writeString(this.dm.getVersionComment());
            return null;
        }

        @Override
        public Object currentVersion() {
            this.writeBoolean(this.dm.isCurrentVersion());
            return null;
        }

        @Override
        public Object colorLabel() {
            this.writeInteger(this.dm.getColorLabel());
            return null;
        }

        @Override
        public Object lockedUntil() {
            if (this.dm.getLockedUntil() != null && this.dm.getLockedUntil().getTime() > System.currentTimeMillis()) {
                this.writeDate(this.dm.getLockedUntil());
            } else {
                this.writeInteger(0L);
            }
            return null;
        }

        @Override
        public Object fileMD5Sum() {
            this.writeString(this.dm.getFileMD5Sum());
            return null;
        }

        private void writeDate(Date date) {
            if (date == null) {
                this.writeNull();
            } else {
                int offset = this.tz.getOffset(date.getTime());
                long time = date.getTime() + (long)offset;
                if (time < 0L) {
                    time = Long.MAX_VALUE;
                }
                this.writeInteger(time);
            }
        }

        private void writeId(long id) {
            this.writeString(Long.toString(id));
        }

        private void writeString(String string) {
            if (string == null) {
                this.writeNull();
                return;
            }
            try {
                this.writer.value((Object)string);
            }
            catch (JSONException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }

        private void writeInteger(long l) {
            try {
                this.writer.value(l);
            }
            catch (JSONException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }

        private void writeNull() {
            try {
                this.writer.value(null);
            }
            catch (JSONException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }

        private void writeBoolean(boolean b) {
            try {
                this.writer.value(b);
            }
            catch (JSONException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }

        @Override
        public Object filestoreLocation() {
            this.writeString(this.dm.getFilestoreLocation());
            return null;
        }

        @Override
        public Object lastModifiedUTC() {
            if (this.dm.getLastModified() == null) {
                this.writeNull();
                return null;
            }
            this.writeInteger(this.dm.getLastModified().getTime());
            return null;
        }

        @Override
        public Object numberOfVersions() {
            this.writeInteger(this.dm.getNumberOfVersions());
            return null;
        }
    }
}

