/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.CommonWriter;
import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.datasource.ContactImageDataSource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.image.ImageLocation;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactWriter
extends CommonWriter {
    private final TimeZone utc = TimeZoneUtils.getTimeZone("utc");
    private static final TIntObjectMap<ContactFieldWriter> WRITER_MAP;

    public ContactWriter(TimeZone timeZone) {
        super(timeZone, null);
    }

    public void writeArray(Contact contactobject, int[] cols, JSONArray jsonArray, Session session) throws JSONException {
        for (int a = 0; a < cols.length; ++a) {
            this.write(cols[a], contactobject, jsonArray, session);
        }
    }

    public void writeContact(Contact contact, JSONObject json, Session session) throws JSONException {
        JSONArray jsonDistributionListArray;
        byte[] imageData;
        this.writeCommonFields(contact, json);
        ContactWriter.writeParameter("last_name", contact.getSurName(), json);
        ContactWriter.writeParameter("first_name", contact.getGivenName(), json);
        ContactWriter.writeParameter("anniversary", contact.getAnniversary(), json);
        ContactWriter.writeParameter("assistant_name", contact.getAssistantName(), json);
        ContactWriter.writeParameter("birthday", contact.getBirthday(), json);
        ContactWriter.writeParameter("branches", contact.getBranches(), json);
        ContactWriter.writeParameter("busines_categorie", contact.getBusinessCategory(), json);
        ContactWriter.writeParameter("cellular_telephone1", contact.getCellularTelephone1(), json);
        ContactWriter.writeParameter("cellular_telephone2", contact.getCellularTelephone2(), json);
        ContactWriter.writeParameter("city_home", contact.getCityHome(), json);
        ContactWriter.writeParameter("city_business", contact.getCityBusiness(), json);
        ContactWriter.writeParameter("city_other", contact.getCityOther(), json);
        ContactWriter.writeParameter("commercial_register", contact.getCommercialRegister(), json);
        ContactWriter.writeParameter("company", contact.getCompany(), json);
        ContactWriter.writeParameter("country_home", contact.getCountryHome(), json);
        ContactWriter.writeParameter("country_business", contact.getCountryBusiness(), json);
        ContactWriter.writeParameter("country_other", contact.getCountryOther(), json);
        ContactWriter.writeParameter("default_address", contact.getDefaultAddress(), json, contact.containsDefaultAddress());
        ContactWriter.writeParameter("department", contact.getDepartment(), json);
        ContactWriter.writeParameter("display_name", contact.getDisplayName(), json);
        ContactWriter.writeParameter("email1", contact.getEmail1(), json);
        ContactWriter.writeParameter("email2", contact.getEmail2(), json);
        ContactWriter.writeParameter("email3", contact.getEmail3(), json);
        ContactWriter.writeParameter("employee_type", contact.getEmployeeType(), json);
        ContactWriter.writeParameter("fax_business", contact.getFaxBusiness(), json);
        ContactWriter.writeParameter("fax_home", contact.getFaxHome(), json);
        ContactWriter.writeParameter("fax_other", contact.getFaxOther(), json);
        ContactWriter.writeParameter("number_of_images", contact.getNumberOfImages(), json);
        if (contact.containsImage1() && (imageData = contact.getImage1()) != null && null != session) {
            try {
                ContactImageDataSource imgSource = ContactImageDataSource.getInstance();
                ImageLocation imageLocation = new ImageLocation.Builder().folder(Integer.toString(contact.getParentFolderID())).id(Integer.toString(contact.getObjectID())).build();
                String imageURL = imgSource.generateUrl(imageLocation, session);
                ContactWriter.writeParameter("image1_url", imageURL, json);
            }
            catch (OXException e) {
                LogFactory.getLog(ContactWriter.class).warn((Object)"Contact image URL could not be generated.", (Throwable)e);
            }
        }
        if (contact.containsImage1() && null == contact.getImage1()) {
            json.put("image1", JSONObject.NULL);
        }
        ContactWriter.writeParameter("info", contact.getInfo(), json);
        ContactWriter.writeParameter("note", contact.getNote(), json);
        ContactWriter.writeParameter("instant_messenger1", contact.getInstantMessenger1(), json);
        ContactWriter.writeParameter("instant_messenger2", contact.getInstantMessenger2(), json);
        ContactWriter.writeParameter("marital_status", contact.getMaritalStatus(), json);
        ContactWriter.writeParameter("manager_name", contact.getManagerName(), json);
        ContactWriter.writeParameter("second_name", contact.getMiddleName(), json);
        ContactWriter.writeParameter("nickname", contact.getNickname(), json);
        ContactWriter.writeParameter("number_of_children", contact.getNumberOfChildren(), json);
        ContactWriter.writeParameter("number_of_employees", contact.getNumberOfEmployee(), json);
        ContactWriter.writeParameter("position", contact.getPosition(), json);
        ContactWriter.writeParameter("postal_code_home", contact.getPostalCodeHome(), json);
        ContactWriter.writeParameter("postal_code_business", contact.getPostalCodeBusiness(), json);
        ContactWriter.writeParameter("postal_code_other", contact.getPostalCodeOther(), json);
        ContactWriter.writeParameter("profession", contact.getProfession(), json);
        ContactWriter.writeParameter("room_number", contact.getRoomNumber(), json);
        ContactWriter.writeParameter("sales_volume", contact.getSalesVolume(), json);
        ContactWriter.writeParameter("spouse_name", contact.getSpouseName(), json);
        ContactWriter.writeParameter("state_home", contact.getStateHome(), json);
        ContactWriter.writeParameter("state_business", contact.getStateBusiness(), json);
        ContactWriter.writeParameter("state_other", contact.getStateOther(), json);
        ContactWriter.writeParameter("street_home", contact.getStreetHome(), json);
        ContactWriter.writeParameter("street_business", contact.getStreetBusiness(), json);
        ContactWriter.writeParameter("street_other", contact.getStreetOther(), json);
        ContactWriter.writeParameter("suffix", contact.getSuffix(), json);
        ContactWriter.writeParameter("tax_id", contact.getTaxID(), json);
        ContactWriter.writeParameter("telephone_assistant", contact.getTelephoneAssistant(), json);
        ContactWriter.writeParameter("telephone_business1", contact.getTelephoneBusiness1(), json);
        ContactWriter.writeParameter("telephone_business2", contact.getTelephoneBusiness2(), json);
        ContactWriter.writeParameter("telephone_callback", contact.getTelephoneCallback(), json);
        ContactWriter.writeParameter("telephone_car", contact.getTelephoneCar(), json);
        ContactWriter.writeParameter("telephone_company", contact.getTelephoneCompany(), json);
        ContactWriter.writeParameter("telephone_home1", contact.getTelephoneHome1(), json);
        ContactWriter.writeParameter("telephone_home2", contact.getTelephoneHome2(), json);
        ContactWriter.writeParameter("telephone_ip", contact.getTelephoneIP(), json);
        ContactWriter.writeParameter("telephone_isdn", contact.getTelephoneISDN(), json);
        ContactWriter.writeParameter("telephone_other", contact.getTelephoneOther(), json);
        ContactWriter.writeParameter("telephone_pager", contact.getTelephonePager(), json);
        ContactWriter.writeParameter("telephone_primary", contact.getTelephonePrimary(), json);
        ContactWriter.writeParameter("telephone_radio", contact.getTelephoneRadio(), json);
        ContactWriter.writeParameter("telephone_telex", contact.getTelephoneTelex(), json);
        ContactWriter.writeParameter("telephone_ttytdd", contact.getTelephoneTTYTTD(), json);
        ContactWriter.writeParameter("title", contact.getTitle(), json);
        ContactWriter.writeParameter("url", contact.getURL(), json);
        ContactWriter.writeParameter("userfield01", contact.getUserField01(), json);
        ContactWriter.writeParameter("userfield02", contact.getUserField02(), json);
        ContactWriter.writeParameter("userfield03", contact.getUserField03(), json);
        ContactWriter.writeParameter("userfield04", contact.getUserField04(), json);
        ContactWriter.writeParameter("userfield05", contact.getUserField05(), json);
        ContactWriter.writeParameter("userfield06", contact.getUserField06(), json);
        ContactWriter.writeParameter("userfield07", contact.getUserField07(), json);
        ContactWriter.writeParameter("userfield08", contact.getUserField08(), json);
        ContactWriter.writeParameter("userfield09", contact.getUserField09(), json);
        ContactWriter.writeParameter("userfield10", contact.getUserField10(), json);
        ContactWriter.writeParameter("userfield11", contact.getUserField11(), json);
        ContactWriter.writeParameter("userfield12", contact.getUserField12(), json);
        ContactWriter.writeParameter("userfield13", contact.getUserField13(), json);
        ContactWriter.writeParameter("userfield14", contact.getUserField14(), json);
        ContactWriter.writeParameter("userfield15", contact.getUserField15(), json);
        ContactWriter.writeParameter("userfield16", contact.getUserField16(), json);
        ContactWriter.writeParameter("userfield17", contact.getUserField17(), json);
        ContactWriter.writeParameter("userfield18", contact.getUserField18(), json);
        ContactWriter.writeParameter("userfield19", contact.getUserField19(), json);
        ContactWriter.writeParameter("userfield20", contact.getUserField20(), json);
        ContactWriter.writeParameter("user_id", contact.getInternalUserId(), json);
        ContactWriter.writeParameter("mark_as_distributionlist", contact.getMarkAsDistribtuionlist(), json, contact.containsMarkAsDistributionlist());
        ContactWriter.writeParameter("useCount", contact.getUseCount(), json);
        ContactWriter.writeParameter("file_as", contact.getFileAs(), json, contact.containsFileAs());
        ContactWriter.writeParameter("yomiFirstName", contact.getYomiFirstName(), json);
        ContactWriter.writeParameter("yomiLastName", contact.getYomiLastName(), json);
        ContactWriter.writeParameter("yomiCompany", contact.getYomiCompany(), json);
        ContactWriter.writeParameter("addressBusiness", contact.getAddressBusiness(), json);
        ContactWriter.writeParameter("addressHome", contact.getAddressHome(), json);
        ContactWriter.writeParameter("addressOther", contact.getAddressOther(), json);
        ContactWriter.writeParameter("uid", contact.getUid(), json);
        JSONArray jsonLinkArray = ContactWriter.getLinksAsJSONArray(contact);
        if (jsonLinkArray != null) {
            json.put("links", (Object)jsonLinkArray);
        }
        if ((jsonDistributionListArray = ContactWriter.getDistributionListAsJSONArray(contact)) != null) {
            json.put("distribution_list", (Object)jsonDistributionListArray);
        }
    }

    static final JSONArray getLinksAsJSONArray(Contact contactobject) throws JSONException {
        LinkEntryObject[] linkentries = contactobject.getLinks();
        if (linkentries != null) {
            JSONArray jsonArray = new JSONArray();
            for (int a = 0; a < linkentries.length; ++a) {
                JSONObject jsonLinkObject = new JSONObject();
                ContactWriter.writeParameter("id", linkentries[a].getLinkID(), jsonLinkObject, linkentries[a].containsLinkID());
                ContactWriter.writeParameter("display_name", linkentries[a].getLinkDisplayname(), jsonLinkObject);
                jsonArray.put((Object)jsonLinkObject);
            }
            return jsonArray;
        }
        return null;
    }

    static final JSONArray getDistributionListAsJSONArray(Contact contactobject) throws JSONException {
        DistributionListEntryObject[] distributionlist = contactobject.getDistributionList();
        if (distributionlist == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (int a = 0; a < distributionlist.length; ++a) {
            JSONObject jsonDListObj = new JSONObject();
            int emailField = distributionlist[a].getEmailfield();
            if (emailField != 0) {
                ContactWriter.writeParameter("id", distributionlist[a].getEntryID(), jsonDListObj);
            }
            ContactWriter.writeParameter("mail", distributionlist[a].getEmailaddress(), jsonDListObj);
            ContactWriter.writeParameter("display_name", distributionlist[a].getDisplayname(), jsonDListObj);
            ContactWriter.writeParameter("mail_field", emailField, jsonDListObj);
            jsonArray.put((Object)jsonDListObj);
        }
        return jsonArray;
    }

    public void write(int field, Contact contactobject, JSONArray jsonArray, Session session) throws JSONException {
        ContactFieldWriter writer = (ContactFieldWriter)WRITER_MAP.get(field);
        if (writer != null) {
            writer.write(contactobject, jsonArray, session);
            return;
        }
        switch (field) {
            case 4: {
                ContactWriter.writeValue(contactobject.getCreationDate(), this.timeZone, jsonArray);
                break;
            }
            case 5: {
                ContactWriter.writeValue(contactobject.getLastModified(), this.timeZone, jsonArray);
                break;
            }
            case 6: {
                ContactWriter.writeValue(contactobject.getLastModified(), this.utc, jsonArray);
                break;
            }
            default: {
                throw new JSONException("missing field in mapping: " + field);
            }
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(128);
        m.put(1, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getObjectID(), jsonArray, contactObject.containsObjectID());
            }
        });
        m.put(2, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCreatedBy(), jsonArray, contactObject.containsCreatedBy());
            }
        });
        m.put(3, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getModifiedBy(), jsonArray, contactObject.containsModifiedBy());
            }
        });
        m.put(20, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getParentFolderID(), jsonArray, contactObject.containsParentFolderID());
            }
        });
        m.put(101, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getPrivateFlag(), jsonArray, contactObject.containsPrivateFlag());
            }
        });
        m.put(502, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getSurName(), jsonArray);
            }
        });
        m.put(610, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getYomiFirstName(), jsonArray);
            }
        });
        m.put(614, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getAddressBusiness(), jsonArray);
            }
        });
        m.put(613, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getAddressHome(), jsonArray);
            }
        });
        m.put(615, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getAddressOther(), jsonArray);
            }
        });
        m.put(223, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUid(), jsonArray);
            }
        });
        m.put(501, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getGivenName(), jsonArray);
            }
        });
        m.put(611, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getYomiLastName(), jsonArray);
            }
        });
        m.put(517, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getAnniversary(), jsonArray);
            }
        });
        m.put(537, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getAssistantName(), jsonArray);
            }
        });
        m.put(511, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getBirthday(), jsonArray);
            }
        });
        m.put(533, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getBranches(), jsonArray);
            }
        });
        m.put(534, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getBusinessCategory(), jsonArray);
            }
        });
        m.put(100, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCategories(), jsonArray);
            }
        });
        m.put(551, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCellularTelephone1(), jsonArray);
            }
        });
        m.put(552, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCellularTelephone2(), jsonArray);
            }
        });
        m.put(508, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCityHome(), jsonArray);
            }
        });
        m.put(526, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCityBusiness(), jsonArray);
            }
        });
        m.put(539, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCityOther(), jsonArray);
            }
        });
        m.put(102, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getLabel(), jsonArray, contactObject.containsLabel());
            }
        });
        m.put(532, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCommercialRegister(), jsonArray);
            }
        });
        m.put(569, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCompany(), jsonArray);
            }
        });
        m.put(612, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getYomiCompany(), jsonArray);
            }
        });
        m.put(510, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCountryHome(), jsonArray);
            }
        });
        m.put(528, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCountryBusiness(), jsonArray);
            }
        });
        m.put(541, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getCountryOther(), jsonArray);
            }
        });
        m.put(605, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getDefaultAddress(), jsonArray, contactObject.containsDefaultAddress());
            }
        });
        m.put(519, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getDepartment(), jsonArray);
            }
        });
        m.put(500, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getDisplayName(), jsonArray);
            }
        });
        m.put(602, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getMarkAsDistribtuionlist(), jsonArray, contactObject.containsMarkAsDistributionlist());
            }
        });
        m.put(555, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getEmail1(), jsonArray);
            }
        });
        m.put(556, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getEmail2(), jsonArray);
            }
        });
        m.put(557, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getEmail3(), jsonArray);
            }
        });
        m.put(521, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getEmployeeType(), jsonArray);
            }
        });
        m.put(544, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getFaxBusiness(), jsonArray);
            }
        });
        m.put(550, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getFaxHome(), jsonArray);
            }
        });
        m.put(554, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getFaxOther(), jsonArray);
            }
        });
        m.put(570, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                byte[] imageData = contactObject.getImage1();
                if (imageData == null) {
                    DataWriter.writeValueNull(jsonArray);
                } else {
                    DataWriter.writeValue(new String(imageData), jsonArray);
                }
            }
        });
        m.put(606, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                if (contactObject.containsContextId()) {
                    byte[] imageData2 = contactObject.getImage1();
                    if (imageData2 == null) {
                        DataWriter.writeValueNull(jsonArray);
                    } else {
                        try {
                            ContactImageDataSource imgSource = ContactImageDataSource.getInstance();
                            ImageLocation imageLocation = new ImageLocation.Builder().folder(Integer.toString(contactObject.getParentFolderID())).id(Integer.toString(contactObject.getObjectID())).build();
                            String imageURL = imgSource.generateUrl(imageLocation, session);
                            DataWriter.writeValue(imageURL, jsonArray);
                        }
                        catch (OXException e) {
                            LogFactory.getLog(ContactWriter.class).warn((Object)"Contact image URL could not be generated.", (Throwable)e);
                            DataWriter.writeValueNull(jsonArray);
                        }
                    }
                } else {
                    DataWriter.writeValueNull(jsonArray);
                }
            }
        });
        m.put(596, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contact, JSONArray json, Session session) {
                DataWriter.writeValue(contact.getNumberOfImages(), json);
            }
        });
        m.put(535, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getInfo(), jsonArray);
            }
        });
        m.put(565, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getInstantMessenger1(), jsonArray);
            }
        });
        m.put(566, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getInstantMessenger2(), jsonArray);
            }
        });
        m.put(524, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getInternalUserId(), jsonArray, contactObject.containsInternalUserId());
            }
        });
        m.put(536, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getManagerName(), jsonArray);
            }
        });
        m.put(512, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getMaritalStatus(), jsonArray);
            }
        });
        m.put(503, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getMiddleName(), jsonArray);
            }
        });
        m.put(515, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNickname(), jsonArray);
            }
        });
        m.put(518, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNote(), jsonArray);
            }
        });
        m.put(513, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNumberOfChildren(), jsonArray);
            }
        });
        m.put(529, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNumberOfEmployee(), jsonArray);
            }
        });
        m.put(520, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getPosition(), jsonArray);
            }
        });
        m.put(507, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getPostalCodeHome(), jsonArray);
            }
        });
        m.put(525, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getPostalCodeBusiness(), jsonArray);
            }
        });
        m.put(540, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getPostalCodeOther(), jsonArray);
            }
        });
        m.put(514, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getProfession(), jsonArray);
            }
        });
        m.put(522, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getRoomNumber(), jsonArray);
            }
        });
        m.put(530, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getSalesVolume(), jsonArray);
            }
        });
        m.put(516, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getSpouseName(), jsonArray);
            }
        });
        m.put(509, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getStateHome(), jsonArray);
            }
        });
        m.put(527, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getStateBusiness(), jsonArray);
            }
        });
        m.put(598, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getStateOther(), jsonArray);
            }
        });
        m.put(506, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getStreetHome(), jsonArray);
            }
        });
        m.put(523, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getStreetBusiness(), jsonArray);
            }
        });
        m.put(538, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getStreetOther(), jsonArray);
            }
        });
        m.put(504, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getSuffix(), jsonArray);
            }
        });
        m.put(531, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTaxID(), jsonArray);
            }
        });
        m.put(568, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneAssistant(), jsonArray);
            }
        });
        m.put(542, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneBusiness1(), jsonArray);
            }
        });
        m.put(543, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneBusiness2(), jsonArray);
            }
        });
        m.put(545, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneCallback(), jsonArray);
            }
        });
        m.put(546, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneCar(), jsonArray);
            }
        });
        m.put(547, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneCompany(), jsonArray);
            }
        });
        m.put(548, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneHome1(), jsonArray);
            }
        });
        m.put(549, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneHome2(), jsonArray);
            }
        });
        m.put(567, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneIP(), jsonArray);
            }
        });
        m.put(559, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneISDN(), jsonArray);
            }
        });
        m.put(553, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneOther(), jsonArray);
            }
        });
        m.put(560, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephonePager(), jsonArray);
            }
        });
        m.put(561, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephonePrimary(), jsonArray);
            }
        });
        m.put(562, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneRadio(), jsonArray);
            }
        });
        m.put(563, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneTelex(), jsonArray);
            }
        });
        m.put(564, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTelephoneTTYTTD(), jsonArray);
            }
        });
        m.put(505, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getTitle(), jsonArray);
            }
        });
        m.put(558, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getURL(), jsonArray);
            }
        });
        m.put(571, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField01(), jsonArray);
            }
        });
        m.put(572, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField02(), jsonArray);
            }
        });
        m.put(573, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField03(), jsonArray);
            }
        });
        m.put(574, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField04(), jsonArray);
            }
        });
        m.put(575, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField05(), jsonArray);
            }
        });
        m.put(576, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField06(), jsonArray);
            }
        });
        m.put(577, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField07(), jsonArray);
            }
        });
        m.put(578, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField08(), jsonArray);
            }
        });
        m.put(579, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField09(), jsonArray);
            }
        });
        m.put(580, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField10(), jsonArray);
            }
        });
        m.put(581, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField11(), jsonArray);
            }
        });
        m.put(582, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField12(), jsonArray);
            }
        });
        m.put(583, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField13(), jsonArray);
            }
        });
        m.put(584, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField14(), jsonArray);
            }
        });
        m.put(585, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField15(), jsonArray);
            }
        });
        m.put(586, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField16(), jsonArray);
            }
        });
        m.put(587, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField17(), jsonArray);
            }
        });
        m.put(588, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField18(), jsonArray);
            }
        });
        m.put(589, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField19(), jsonArray);
            }
        });
        m.put(590, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUserField20(), jsonArray);
            }
        });
        m.put(104, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNumberOfAttachments(), jsonArray, contactObject.containsNumberOfAttachments());
            }
        });
        m.put(105, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contact, JSONArray json, Session session) {
                DataWriter.writeValue(contact.getLastModifiedOfNewestAttachment(), json, contact.containsLastModifiedOfNewestAttachment());
            }
        });
        ContactFieldWriter fieldWriter = new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNumberOfLinks(), jsonArray, contactObject.containsNumberOfLinks());
            }
        };
        m.put(103, (Object)fieldWriter);
        m.put(595, (Object)fieldWriter);
        m.put(594, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getNumberOfDistributionLists(), jsonArray, contactObject.containsNumberOfDistributionLists());
            }
        });
        m.put(597, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getImageLastModified(), jsonArray);
            }
        });
        m.put(599, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contact, JSONArray json, Session session) {
                DataWriter.writeValue(contact.getFileAs(), json, contact.containsFileAs());
            }
        });
        m.put(601, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getImageContentType(), jsonArray);
            }
        });
        m.put(608, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getUseCount(), jsonArray);
            }
        });
        m.put(591, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) throws JSONException {
                JSONArray jsonLinksArray = ContactWriter.getLinksAsJSONArray(contactObject);
                if (jsonLinksArray == null) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    jsonArray.put((Object)jsonLinksArray);
                }
            }
        });
        m.put(592, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) throws JSONException {
                JSONArray jsonDistributionListArray = ContactWriter.getDistributionListAsJSONArray(contactObject);
                if (jsonDistributionListArray == null) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    jsonArray.put((Object)jsonDistributionListArray);
                }
            }
        });
        m.put(610, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getYomiFirstName(), jsonArray);
            }
        });
        m.put(611, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getYomiLastName(), jsonArray);
            }
        });
        m.put(612, (Object)new ContactFieldWriter(){

            @Override
            public void write(Contact contactObject, JSONArray jsonArray, Session session) {
                DataWriter.writeValue(contactObject.getYomiCompany(), jsonArray);
            }
        });
        WRITER_MAP = m;
    }

    private static interface ContactFieldWriter {
        public void write(Contact var1, JSONArray var2, Session var3) throws JSONException;
    }
}

