/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.config.ConfigurationService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.log.Log;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.services.ServerServiceRegistry;

public class PrefixServiceActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void startBundle() throws Exception {
        try {
            String tmp = ((ConfigurationService)this.getService(ConfigurationService.class)).getProperty("com.openexchange.dispatcher.prefix", "/ajax/").trim();
            if (tmp.charAt(0) != '/') {
                tmp = '/' + tmp;
            }
            if (!tmp.endsWith("/")) {
                tmp = tmp + '/';
            }
            String prefix = tmp;
            DispatcherServlet.setPrefix(prefix);
            DefaultDispatcherPrefixService prefixService = DefaultDispatcherPrefixService.getInstance();
            ServerServiceRegistry.getInstance().addService(DispatcherPrefixService.class, prefixService);
            ImageMatcher.setPrefixService(prefixService);
            this.registerService(DispatcherPrefixService.class, prefixService);
        }
        catch (Exception e) {
            org.apache.commons.logging.Log log = Log.loggerFor(PrefixServiceActivator.class);
            log.error((Object)"DispatcherPrefixService could not be registered", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            org.apache.commons.logging.Log log = Log.loggerFor(PrefixServiceActivator.class);
            log.error((Object)"DispatcherPrefixService could not be registered", (Throwable)e);
            throw e;
        }
    }
}

