/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.AJAXResultDecorator;
import com.openexchange.ajax.requesthandler.AJAXResultDecoratorRegistry;
import com.openexchange.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class OSGiAJAXResultDecoratorRegistry
implements AJAXResultDecoratorRegistry,
ServiceTrackerCustomizer<AJAXResultDecorator, AJAXResultDecorator> {
    final ConcurrentMap<String, AJAXResultDecorator> map;
    private final BundleContext context;

    public OSGiAJAXResultDecoratorRegistry(BundleContext context) {
        this.context = context;
        this.map = new ConcurrentHashMap<String, AJAXResultDecorator>(8);
    }

    @Override
    public List<AJAXResultDecorator> getDecorators() {
        return new ArrayList<AJAXResultDecorator>(this.map.values());
    }

    @Override
    public AJAXResultDecorator getDecorator(String identifier) {
        return (AJAXResultDecorator)this.map.get(identifier);
    }

    public AJAXResultDecorator addingService(ServiceReference<AJAXResultDecorator> reference) {
        AJAXResultDecorator service = (AJAXResultDecorator)this.context.getService(reference);
        if (null == this.map.putIfAbsent(service.getIdentifier(), service)) {
            return service;
        }
        Log logger = LogFactory.getLog(OSGiAJAXResultDecoratorRegistry.class);
        if (logger.isWarnEnabled()) {
            logger.warn((Object)new StringBuilder(128).append("Another AJAXResultDecorator is already registered with identifier: ").append(service.getIdentifier()).toString());
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<AJAXResultDecorator> reference, AJAXResultDecorator service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<AJAXResultDecorator> reference, AJAXResultDecorator service) {
        try {
            this.map.remove(service.getIdentifier());
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

