/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultConverter
implements Converter {
    private final Map<String, List<Node>> understandsFormat = new ConcurrentHashMap<String, List<Node>>();
    private final Map<String, List<Node>> suppliesFormat = new ConcurrentHashMap<String, List<Node>>();
    private final Map<Conversion, Step> cachedSteps = new ConcurrentHashMap<Conversion, Step>();

    public void addConverter(ResultConverter converter) {
        List<Node> understanders;
        String outputFormat;
        List<Node> nodesWhoUnderstandMe;
        Node n = new Node();
        n.converter = converter;
        Edge edge = new Edge();
        edge.node = n;
        List<Node> nodesWhoseOutputIsUnderstood = this.suppliesFormat.get(converter.getInputFormat());
        if (nodesWhoseOutputIsUnderstood != null && !nodesWhoseOutputIsUnderstood.isEmpty()) {
            for (Node node : nodesWhoseOutputIsUnderstood) {
                node.edges.add(edge);
            }
        }
        if ((nodesWhoUnderstandMe = this.understandsFormat.get(outputFormat = converter.getOutputFormat())) != null && !nodesWhoUnderstandMe.isEmpty()) {
            for (Node node : nodesWhoUnderstandMe) {
                Edge edge2 = new Edge();
                edge2.node = node;
                n.edges.add(edge2);
            }
        }
        if ((understanders = this.understandsFormat.get(converter.getInputFormat())) == null) {
            understanders = new LinkedList<Node>();
            this.understandsFormat.put(converter.getInputFormat(), understanders);
        }
        understanders.add(n);
        List<Node> suppliers = this.suppliesFormat.get(converter.getOutputFormat());
        if (suppliers == null) {
            suppliers = new LinkedList<Node>();
            this.suppliesFormat.put(converter.getOutputFormat(), suppliers);
        }
        suppliers.add(n);
    }

    public void removeConverter(ResultConverter resultConverter) {
    }

    @Override
    public void convert(String fromFormat, String toFormat, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        Step path = this.getShortestPath(fromFormat, toFormat);
        while (path != null) {
            path.converter.convert(requestData, result, session, this);
            result.setFormat(path.converter.getOutputFormat());
            path = path.next;
        }
    }

    public Step getShortestPath(String from, String to) {
        Conversion conversion = new Conversion(from, to);
        Step step = this.cachedSteps.get(conversion);
        if (step != null) {
            return step;
        }
        HashMap<Node, Mark> markings = new HashMap<Node, Mark>();
        List<Edge> edges = this.getInitialEdges(from);
        Mark currentMark = new Mark();
        currentMark.weight = 0;
        Node currentNode = null;
        while (true) {
            Mark mark;
            Mark nextMark = null;
            Node nextNode = null;
            for (Edge edge : edges) {
                if (edge.node.converter.getOutputFormat().equals(to)) {
                    Mark m = new Mark();
                    m.previous = currentNode;
                    Step newStep = this.unwind(m, edge, markings);
                    this.cachedSteps.put(conversion, newStep);
                    return newStep;
                }
                mark = (Mark)markings.get(edge.node);
                if (mark == null) {
                    mark = new Mark();
                    markings.put(edge.node, mark);
                }
                if (mark.visited || mark.weight <= currentMark.weight + edge.weight()) continue;
                mark.weight = currentMark.weight + edge.weight();
                mark.previous = currentNode;
                if (nextMark != null && nextMark.weight <= mark.weight) continue;
                nextMark = mark;
                nextNode = edge.node;
            }
            currentMark.visited = true;
            if (nextMark == null) {
                currentMark.weight = 100;
                while (nextMark == null) {
                    if (currentMark.previous == null) {
                        throw new IllegalArgumentException("Can't find path from " + from + " to " + to);
                    }
                    currentNode = currentMark.previous;
                    currentMark = (Mark)markings.get(currentNode);
                    for (Edge edge : currentNode.edges) {
                        mark = (Mark)markings.get(edge.node);
                        if (mark.visited || nextMark != null && nextMark.weight <= mark.weight) continue;
                        nextMark = mark;
                        nextNode = edge.node;
                    }
                }
            }
            currentMark = nextMark;
            currentNode = nextNode;
            edges = nextNode.edges;
        }
    }

    private Step unwind(Mark currentMark, Edge edge, Map<Node, Mark> markings) {
        Step current = new Step();
        current.converter = edge.node.converter;
        while (currentMark.previous != null) {
            Step step = new Step();
            step.converter = currentMark.previous.converter;
            step.next = current;
            current = step;
            currentMark = markings.get(currentMark.previous);
        }
        return current;
    }

    private List<Edge> getInitialEdges(String format) {
        List<Node> list = this.understandsFormat.get(format);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Can't convert from " + format);
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(list.size());
        for (Node node : list) {
            Edge edge = new Edge();
            edge.node = node;
            edges.add(edge);
        }
        return edges;
    }

    public static final class Conversion {
        private final String from;
        private final String to;
        private final int hashCode;

        Conversion(String from, String to) {
            this.from = from;
            this.to = to;
            int prime = 31;
            int result = 1;
            result = 31 * result + (from == null ? 0 : from.hashCode());
            this.hashCode = result = 31 * result + (to == null ? 0 : to.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Conversion)) {
                return false;
            }
            Conversion other = (Conversion)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }

    public static final class Node {
        public ResultConverter converter;
        public List<Edge> edges = new LinkedList<Edge>();
    }

    public static final class Edge {
        public Node node;

        public int weight() {
            switch (this.node.converter.getQuality()) {
                case GOOD: {
                    return 1;
                }
                case BAD: {
                    return 2;
                }
            }
            return 2;
        }
    }

    public static final class Mark {
        public Node previous;
        public int weight = Integer.MAX_VALUE;
        public boolean visited = false;
    }

    public static final class Step {
        public Step next;
        public ResultConverter converter;
    }
}

