/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.ConfigMenu;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.Send;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.Header;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResultCode;
import com.openexchange.config.ConfigTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ClientWhitelist;
import com.openexchange.configuration.CookieHashSource;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.login.ConfigurationProperty;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.oauth.provider.OAuthProviderService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.IPRange;
import com.openexchange.tools.io.IOTools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Authorization;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class Login
extends AJAXServlet {
    private static final long serialVersionUID = 7680745138705836499L;
    protected static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Login.class));
    protected static final boolean INFO = LOG.isInfoEnabled();
    public static final String SESSION_PREFIX = "open-xchange-session-".intern();
    public static final String SECRET_PREFIX = "open-xchange-secret-".intern();
    public static final String PUBLIC_SESSION_NAME = "open-xchange-public-session".intern();
    private static final String ACTION_FORMLOGIN = "formlogin";
    public static final String ACTION_CHANGEIP = "changeip".intern();
    protected final AtomicReference<LoginConfiguration> confReference = new AtomicReference<LoginConfiguration>(new LoginConfiguration());
    private final Map<String, JSONRequestHandler> handlerMap;
    private static final String ERROR_PAGE_TEMPLATE = "<html>\n<script type=\"text/javascript\">\n// Display normal HTML for 5 seconds, then redirect via referrer.\nsetTimeout(redirect,5000);\nfunction redirect(){\n var referrer=document.referrer;\n var redirect_url;\n // If referrer already contains failed parameter, we don't add a 2nd one.\n if(referrer.indexOf(\"login=failed\")>=0){\n  redirect_url=referrer;\n }else{\n  // Check if referrer contains multiple parameter\n  if(referrer.indexOf(\"?\")<0){\n   redirect_url=referrer+\"?login=failed\";\n  }else{\n   redirect_url=referrer+\"&login=failed\";\n  }\n }\n // Redirect to referrer\n window.location.href=redirect_url;\n}\n</script>\n<body>\n<h1>ERROR_MESSAGE</h1>\n</body>\n</html>\n";

    public Login() {
        ConcurrentHashMap<String, JSONRequestHandler> map = new ConcurrentHashMap<String, JSONRequestHandler>(8);
        map.put("login", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doLogin(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
            }
        });
        map.put("oauth", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doOAuthLogin(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
            }
        });
        map.put("store", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doStore(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        map.put("refreshSecret", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doRefreshSecret(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        map.put("logout", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String sessionId = req.getParameter("session");
                if (sessionId == null) {
                    resp.sendError(400);
                    return;
                }
                try {
                    Session session = LoginPerformer.getInstance().lookupSession(sessionId);
                    if (session != null) {
                        LoginConfiguration conf = Login.this.confReference.get();
                        SessionServlet.checkIP(conf.ipCheck, conf.ranges, session, req.getRemoteAddr(), conf.ipCheckWhitelist);
                        String secret = SessionServlet.extractSecret(conf.hashSource, req, session.getHash(), session.getClient());
                        if (secret == null || !session.getSecret().equals(secret)) {
                            LOG.info((Object)"Status code 403 (FORBIDDEN): Missing or non-matching secret.");
                            resp.sendError(403);
                            return;
                        }
                        LoginPerformer.getInstance().doLogout(sessionId);
                        SessionServlet.removeOXCookies(session.getHash(), req, resp);
                        SessionServlet.removeJSESSIONID(req, resp);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)"Logout failed", (Throwable)e);
                }
            }
        });
        map.put("redirect", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String hash;
                Session session;
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String randomToken = req.getParameter("random");
                if (randomToken == null) {
                    resp.sendError(400);
                    return;
                }
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (sessiondService == null) {
                    OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                    LOG.error((Object)se.getMessage(), (Throwable)se);
                    resp.sendError(403);
                    return;
                }
                LoginConfiguration conf = Login.this.confReference.get();
                if (conf.insecure) {
                    if (conf.redirectIPChangeAllowed) {
                        session = sessiondService.getSessionByRandomToken(randomToken, req.getRemoteAddr());
                    } else {
                        String newIP;
                        String oldIP;
                        session = sessiondService.getSessionByRandomToken(randomToken);
                        if (null != session && (null == (oldIP = session.getLocalIp()) || SessionServlet.isWhitelistedFromIPCheck(oldIP, conf.ranges)) && !(newIP = req.getRemoteAddr()).equals(oldIP)) {
                            LOG.info((Object)("Changing IP of session " + session.getSessionID() + " with authID: " + session.getAuthId() + " from " + oldIP + " to " + newIP + '.'));
                            session.setLocalIp(newIP);
                        }
                    }
                } else {
                    session = sessiondService.getSessionByRandomToken(randomToken);
                }
                if (session == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No session could be found for random token: " + randomToken), new Throwable());
                    } else if (INFO) {
                        LOG.info((Object)("No session could be found for random token: " + randomToken));
                    }
                    resp.sendError(403);
                    return;
                }
                if (conf.insecure) {
                    SessionServlet.removeOXCookies(session.getHash(), req, resp);
                }
                try {
                    Context context = ContextStorage.getInstance().getContext(session.getContextId());
                    User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                    if (!context.isEnabled() || !user.isMailEnabled()) {
                        LOG.info((Object)("Status code 403 (FORBIDDEN): Either context " + context.getContextId() + " or user " + user.getId() + " not enabled"));
                        resp.sendError(403);
                        return;
                    }
                }
                catch (UndeclaredThrowableException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Unexpected error occurred during login: " + e.getMessage()));
                    resp.sendError(403);
                    return;
                }
                catch (OXException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Couldn't resolve context/user by identifier: " + session.getContextId() + "/" + session.getUserId()));
                    resp.sendError(403);
                    return;
                }
                String client = req.getParameter("client");
                if (!conf.insecure) {
                    hash = session.getHash();
                } else {
                    if (null == client) {
                        client = session.getClient();
                    } else {
                        session.setClient(client);
                    }
                    hash = HashCalculator.getHash(req, client);
                    session.setHash(hash);
                }
                Login.this.writeSecretCookie(resp, session, hash, req.isSecure(), req.getServerName());
                resp.sendRedirect(Login.this.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("store"), session.getSessionID()));
            }
        });
        map.put(ACTION_CHANGEIP, new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Response response = new Response();
                Session session = null;
                try {
                    String sessionId = req.getParameter("session");
                    if (null == sessionId) {
                        if (INFO) {
                            StringBuilder sb = new StringBuilder(32);
                            sb.append("Parameter \"").append("session").append("\" not found for action ").append(ACTION_CHANGEIP);
                            LOG.info((Object)sb.toString());
                        }
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
                    }
                    String newIP = req.getParameter("clientIP");
                    if (null == newIP) {
                        if (INFO) {
                            StringBuilder sb = new StringBuilder(32);
                            sb.append("Parameter \"").append("clientIP").append("\" not found for action ").append(ACTION_CHANGEIP);
                            LOG.info((Object)sb.toString());
                        }
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create("clientIP");
                    }
                    SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class, true);
                    session = sessiondService.getSession(sessionId);
                    LoginConfiguration conf = Login.this.confReference.get();
                    if (session != null) {
                        SessionServlet.checkIP(conf.ipCheck, conf.ranges, session, req.getRemoteAddr(), conf.ipCheckWhitelist);
                        String secret = SessionServlet.extractSecret(conf.hashSource, req, session.getHash(), session.getClient());
                        if (secret == null || !session.getSecret().equals(secret)) {
                            if (INFO && null != secret) {
                                LOG.info((Object)("Session secret is different. Given secret \"" + secret + "\" differs from secret in session \"" + session.getSecret() + "\"."));
                            }
                            throw SessionExceptionCodes.WRONG_SESSION_SECRET.create();
                        }
                        String oldIP = session.getLocalIp();
                        if (!newIP.equals(oldIP)) {
                            LOG.info((Object)("Changing IP of session " + session.getSessionID() + " with authID: " + session.getAuthId() + " from " + oldIP + " to " + newIP + '.'));
                            session.setLocalIp(newIP);
                        }
                    } else {
                        if (INFO) {
                            LOG.info((Object)("There is no session associated with session identifier: " + sessionId));
                        }
                        throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
                    }
                    response.setData("1");
                }
                catch (OXException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                    response.setException(e);
                }
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                resp.setStatus(200);
                try {
                    ResponseWriter.write(response, resp.getWriter(), AJAXServlet.localeFrom(session));
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        map.put("redeem", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String hash;
                Session session;
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String randomToken = req.getParameter("random");
                if (randomToken == null) {
                    resp.sendError(400);
                    return;
                }
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (sessiondService == null) {
                    OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                    LOG.error((Object)se.getMessage(), (Throwable)se);
                    resp.sendError(403);
                    return;
                }
                LoginConfiguration conf = Login.this.confReference.get();
                if (conf.insecure) {
                    if (conf.redirectIPChangeAllowed) {
                        session = sessiondService.getSessionByRandomToken(randomToken, req.getRemoteAddr());
                    } else {
                        String newIP;
                        String oldIP;
                        session = sessiondService.getSessionByRandomToken(randomToken);
                        if (null != session && (null == (oldIP = session.getLocalIp()) || SessionServlet.isWhitelistedFromIPCheck(oldIP, conf.ranges)) && !(newIP = req.getRemoteAddr()).equals(oldIP)) {
                            LOG.info((Object)("Changing IP of session " + session.getSessionID() + " with authID: " + session.getAuthId() + " from " + oldIP + " to " + newIP + '.'));
                            session.setLocalIp(newIP);
                        }
                    }
                } else {
                    session = sessiondService.getSessionByRandomToken(randomToken);
                }
                if (session == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No session could be found for random token: " + randomToken), new Throwable());
                    } else if (INFO) {
                        LOG.info((Object)("No session could be found for random token: " + randomToken));
                    }
                    resp.sendError(403);
                    return;
                }
                if (conf.insecure) {
                    SessionServlet.removeOXCookies(session.getHash(), req, resp);
                }
                try {
                    Context context = ContextStorage.getInstance().getContext(session.getContextId());
                    User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                    if (!context.isEnabled() || !user.isMailEnabled()) {
                        LOG.info((Object)("Status code 403 (FORBIDDEN): Either context " + context.getContextId() + " or user " + user.getId() + " not enabled"));
                        resp.sendError(403);
                        return;
                    }
                }
                catch (UndeclaredThrowableException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Unexpected error occurred during login: " + e.getMessage()));
                    resp.sendError(403);
                    return;
                }
                catch (OXException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Couldn't resolve context/user by identifier: " + session.getContextId() + "/" + session.getUserId()));
                    resp.sendError(403);
                    return;
                }
                String client = req.getParameter("client");
                if (!conf.insecure) {
                    hash = session.getHash();
                } else {
                    if (null == client) {
                        client = session.getClient();
                    } else {
                        session.setClient(client);
                    }
                    hash = HashCalculator.getHash(req, client);
                    session.setHash(hash);
                }
                Login.this.writeSecretCookie(resp, session, hash, req.isSecure(), req.getServerName());
                try {
                    JSONObject json = new JSONObject();
                    LoginWriter.write(session, json);
                    Login.appendModules(session, json, req);
                    json.write((Writer)resp.getWriter());
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        map.put("autologin", new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                Response response = new Response();
                Session session = null;
                try {
                    SessiondService sessiondService;
                    LoginConfiguration conf = Login.this.confReference.get();
                    if (!conf.sessiondAutoLogin) {
                        if (Login.this.doAutoLogin(req, resp)) {
                            throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
                        }
                        return;
                    }
                    javax.servlet.http.Cookie[] cookies = req.getCookies();
                    if (cookies == null) {
                        cookies = new javax.servlet.http.Cookie[]{};
                    }
                    if (null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
                        OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                        LOG.error((Object)se.getMessage(), (Throwable)se);
                        resp.sendError(403);
                        return;
                    }
                    String secret = null;
                    String hash = HashCalculator.getHash(req);
                    String sessionCookieName = SESSION_PREFIX + hash;
                    String secretCookieName = SECRET_PREFIX + hash;
                    for (javax.servlet.http.Cookie cookie : cookies) {
                        String cookieName = cookie.getName();
                        if (cookieName.startsWith(sessionCookieName)) {
                            String sessionId = cookie.getValue();
                            session = sessiondService.getSession(sessionId);
                            if (null == session) continue;
                            if (!conf.ipCheck) {
                                Login.this.updateIPAddress(req.getRemoteAddr(), session);
                            } else {
                                String newIP = req.getRemoteAddr();
                                SessionServlet.checkIP(true, conf.ranges, session, newIP, conf.ipCheckWhitelist);
                                Login.this.updateIPAddress(newIP, session);
                            }
                            try {
                                Context ctx = ContextStorage.getInstance().getContext(session.getContextId());
                                User user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
                                if (!ctx.isEnabled() || !user.isMailEnabled()) {
                                    throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                                }
                            }
                            catch (UndeclaredThrowableException e) {
                                throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                            }
                            JSONObject json = new JSONObject();
                            LoginWriter.write(session, json);
                            Login.appendModules(session, json, req);
                            response.setData(json);
                            if (null == secret) continue;
                            break;
                        }
                        if (!cookieName.startsWith(secretCookieName)) continue;
                        secret = cookie.getValue();
                        if (null != session) break;
                    }
                    if (null == response.getData() || session == null || secret == null || !session.getSecret().equals(secret)) {
                        SessionServlet.removeOXCookies(hash, req, resp);
                        SessionServlet.removeJSESSIONID(req, resp);
                        if (Login.this.doAutoLogin(req, resp)) {
                            throw OXJSONExceptionCodes.INVALID_COOKIE.create();
                        }
                        return;
                    }
                }
                catch (OXException e) {
                    if (AjaxExceptionCodes.DISABLED_ACTION.equals(e)) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    } else {
                        e.log(LOG);
                    }
                    if (SessionServlet.isIpCheckError(e) && null != session) {
                        try {
                            SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                            SessionServlet.removeOXCookies(session.getHash(), req, resp);
                            SessionServlet.removeJSESSIONID(req, resp);
                            sessiondService.removeSession(session.getSessionID());
                        }
                        catch (Exception e2) {
                            LOG.error((Object)"Cookies could not be removed.", (Throwable)e2);
                        }
                    }
                    response.setException(e);
                }
                catch (JSONException e) {
                    OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    LOG.error((Object)oje.getMessage(), (Throwable)oje);
                    response.setException(oje);
                }
                Tools.disableCaching(resp);
                resp.setStatus(200);
                resp.setContentType("text/javascript; charset=UTF-8");
                try {
                    if (response.hasError()) {
                        ResponseWriter.write(response, resp.getWriter(), AJAXServlet.localeFrom(session));
                    } else {
                        ((JSONObject)response.getData()).write((Writer)resp.getWriter());
                    }
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        map.put(ACTION_FORMLOGIN, new JSONRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doFormLogin(req, resp);
                }
                catch (OXException e) {
                    String errorPage = Login.this.confReference.get().errorPageTemplate.replace("ERROR_MESSAGE", e.getMessage());
                    resp.setContentType("text/html; charset=UTF-8");
                    resp.getWriter().write(errorPage);
                }
            }
        });
        this.handlerMap = Collections.unmodifiableMap(map);
    }

    public void init(ServletConfig config) throws ServletException {
        String errorPageTemplate;
        super.init(config);
        String uiWebPath = config.getInitParameter(ServerConfig.Property.UI_WEB_PATH.getPropertyName());
        boolean sessiondAutoLogin = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.SESSIOND_AUTOLOGIN.getPropertyName()));
        CookieHashSource hashSource = CookieHashSource.parse(config.getInitParameter(ServerConfig.Property.COOKIE_HASH.getPropertyName()));
        String httpAuthAutoLogin = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_AUTOLOGIN.getPropertyName());
        String defaultClient = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_CLIENT.getPropertyName());
        String clientVersion = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_VERSION.getPropertyName());
        String templateFileLocation = config.getInitParameter(ConfigurationProperty.ERROR_PAGE_TEMPLATE.getPropertyName());
        if (null == templateFileLocation) {
            errorPageTemplate = ERROR_PAGE_TEMPLATE;
        } else {
            File templateFile = new File(templateFileLocation);
            try {
                errorPageTemplate = IOTools.getFileContents(templateFile);
                LOG.info((Object)("Found an error page template at " + templateFileLocation));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Could not find an error page template at " + templateFileLocation + ", using default."));
                errorPageTemplate = ERROR_PAGE_TEMPLATE;
            }
        }
        int cookieExpiry = ConfigTools.parseTimespanSecs((String)config.getInitParameter(ServerConfig.Property.COOKIE_TTL.getPropertyName()));
        boolean cookieForceHTTPS = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.COOKIE_FORCE_HTTPS.getPropertyName())) || Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.FORCE_HTTPS.getPropertyName()));
        boolean insecure = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.INSECURE.getPropertyName()));
        boolean ipCheck = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.IP_CHECK.getPropertyName()));
        ClientWhitelist ipCheckWhitelist = new ClientWhitelist().add(config.getInitParameter(ServerConfig.Property.IP_CHECK_WHITELIST.getPropertyName()));
        boolean redirectIPChangeAllowed = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.REDIRECT_IP_CHANGE_ALLOWED.getPropertyName()));
        Java7ConcurrentLinkedQueue ranges = new Java7ConcurrentLinkedQueue();
        String tmp = config.getInitParameter(ConfigurationProperty.NO_IP_CHECK_RANGE.getPropertyName());
        if (tmp != null) {
            String[] lines;
            for (String line : lines = tmp.split("\n")) {
                if ((line = line.replaceAll("\\s", "")).equals("") || line.length() != 0 && line.charAt(0) == '#') continue;
                ranges.add(IPRange.parseRange(line));
            }
        }
        this.confReference.set(new LoginConfiguration(uiWebPath, sessiondAutoLogin, hashSource, httpAuthAutoLogin, defaultClient, clientVersion, errorPageTemplate, cookieExpiry, cookieForceHTTPS, insecure, ipCheck, ipCheckWhitelist, redirectIPChangeAllowed, (Queue<IPRange>)ranges));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String action = req.getParameter("action");
        String subPath = Login.getServletSpecificURI(req);
        if (null != subPath && subPath.length() > 0 && subPath.startsWith("/httpAuth")) {
            this.doHttpAuth(req, resp);
        } else if (null != action) {
            this.doJSONAuth(req, resp, action);
        } else {
            Login.logAndSendException(resp, AjaxExceptionCodes.MISSING_PARAMETER.create("action"));
            return;
        }
    }

    private void doJSONAuth(HttpServletRequest req, HttpServletResponse resp, String action) throws IOException {
        JSONRequestHandler handler = this.handlerMap.get(action);
        if (null == handler) {
            Login.logAndSendException(resp, AjaxExceptionCodes.UNKNOWN_ACTION.create(action));
            return;
        }
        handler.handleRequest(req, resp);
    }

    private void doHttpAuth(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader("authorization") != null) {
            try {
                this.doAuthHeaderLogin(req, resp);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                resp.addHeader("WWW-Authenticate", "NEGOTIATE");
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Open-Xchange\"");
                resp.sendError(401, e.getMessage());
            }
        } else {
            resp.addHeader("WWW-Authenticate", "NEGOTIATE");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"Open-Xchange\"");
            resp.sendError(401, "Authorization Required!");
        }
    }

    protected void updateIPAddress(String newIP, Session session) {
        if (this.confReference.get().insecure) {
            String oldIP = session.getLocalIp();
            if (null != newIP && !newIP.equals(oldIP)) {
                LOG.info((Object)("Updating sessions IP address. authID: " + session.getAuthId() + ", sessionID: " + session.getSessionID() + ", old ip: " + oldIP + ", new ip: " + newIP));
                session.setLocalIp(newIP);
            }
        }
    }

    protected static String addFragmentParameter(String usedUIWebPath, String param, String value) {
        String retval = usedUIWebPath;
        int fragIndex = retval.indexOf(35);
        int questionMarkIndex = retval.indexOf(63, fragIndex);
        String query = "";
        if (questionMarkIndex > 0) {
            query = retval.substring(questionMarkIndex);
            retval = retval.substring(0, questionMarkIndex);
        }
        if (!retval.contains("#")) {
            return retval + "#" + param + "=" + value + query;
        }
        return retval + "&" + param + "=" + value + query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCookieReWrite(HttpServletRequest req, HttpServletResponse resp, CookieType type) throws OXException, JSONException, IOException {
        LoginConfiguration conf = this.confReference.get();
        if (!conf.sessiondAutoLogin && CookieType.SESSION == type) {
            throw AjaxExceptionCodes.DISABLED_ACTION.create("store");
        }
        SessiondService sessiond = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null == sessiond) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        String sessionId = req.getParameter("session");
        if (null == sessionId) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        ServerSession session = SessionServlet.getSession(conf.hashSource, req, sessionId, sessiond);
        try {
            SessionServlet.checkIP(conf.ipCheck, conf.ranges, session, req.getRemoteAddr(), conf.ipCheckWhitelist);
            if (type == CookieType.SESSION) {
                this.writeSessionCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
            } else {
                this.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
            }
            req.getSession();
            Response response = new Response();
            response.setData("1");
            ResponseWriter.write(response, resp.getWriter(), Login.localeFrom((Session)session));
        }
        finally {
            Props properties;
            if (LogProperties.isEnabled() && null != (properties = LogProperties.optLogProperties())) {
                properties.remove("com.openexchange.session.sessionId");
                properties.remove("com.openexchange.session.userId");
                properties.remove("com.openexchange.session.contextId");
                properties.remove("com.openexchange.session.clientId");
                properties.remove("com.openexchange.session.session");
            }
        }
    }

    protected void doStore(HttpServletRequest req, HttpServletResponse resp) throws OXException, JSONException, IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        this.doCookieReWrite(req, resp, CookieType.SESSION);
    }

    protected void doRefreshSecret(HttpServletRequest req, HttpServletResponse resp) throws OXException, JSONException, IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        this.doCookieReWrite(req, resp, CookieType.SECRET);
    }

    protected static void logAndSendException(HttpServletResponse resp, OXException e) throws IOException {
        LOG.debug((Object)e.getMessage(), (Throwable)e);
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        response.setException(e);
        Send.sendResponse(response, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    @Deprecated
    protected void writeSecretCookie(HttpServletResponse resp, Session session, String hash, boolean secure) {
        this.writeSecretCookie(resp, session, hash, secure, null);
    }

    protected void writeSecretCookie(HttpServletResponse resp, Session session, String hash, boolean secure, String serverName) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(SECRET_PREFIX + hash, session.getSecret());
        this.configureCookie(cookie, secure, serverName);
        resp.addCookie(cookie);
        String altId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID);
        if (null != altId) {
            cookie = new javax.servlet.http.Cookie(PUBLIC_SESSION_NAME, altId);
            this.configureCookie(cookie, secure, serverName);
            resp.addCookie(cookie);
        }
    }

    @Deprecated
    protected void writeSessionCookie(HttpServletResponse resp, Session session, String hash, boolean secure) {
        this.writeSessionCookie(resp, session, hash, secure, null);
    }

    protected void writeSessionCookie(HttpServletResponse resp, Session session, String hash, boolean secure, String serverName) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(SESSION_PREFIX + hash, session.getSessionID());
        this.configureCookie(cookie, secure, serverName);
        resp.addCookie(cookie);
    }

    private void configureCookie(javax.servlet.http.Cookie cookie, boolean secure, String serverName) {
        String domain;
        cookie.setPath("/");
        LoginConfiguration conf = this.confReference.get();
        if (secure || conf.cookieForceHTTPS && !Cookies.isLocalLan(serverName)) {
            cookie.setSecure(true);
        }
        if (conf.sessiondAutoLogin || conf.cookieExpiry < 0) {
            cookie.setMaxAge(conf.cookieExpiry);
        }
        if (null != (domain = Cookies.getDomainValue(null == serverName ? (String)LogProperties.getLogProperty((String)"com.openexchange.ajp13.serverName") : serverName))) {
            cookie.setDomain(domain);
        }
    }

    protected boolean doAutoLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        return this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                LoginRequest request = Login.this.parseAutoLoginRequest(req2);
                return LoginPerformer.getInstance().doAutoLogin(request);
            }
        });
    }

    protected void doLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                LoginRequest request = Login.this.parseLogin(req2, "name", false);
                return LoginPerformer.getInstance().doLogin(request);
            }
        });
    }

    protected void doOAuthLogin(HttpServletRequest req, final HttpServletResponse resp) throws IOException, OXException {
        this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                try {
                    OAuthProviderService providerService = ServerServiceRegistry.getInstance().getService(OAuthProviderService.class);
                    OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)req2, null);
                    OAuthAccessor accessor = providerService.getAccessor(requestMessage);
                    providerService.getValidator().validateMessage(requestMessage, accessor);
                    String login = (String)accessor.getProperty("login");
                    String password = (String)accessor.getProperty("password");
                    LoginRequest request = Login.this.parseLogin(req2, login, password, false);
                    return LoginPerformer.getInstance().doLogin(request);
                }
                catch (OAuthProblemException e) {
                    try {
                        this.handleException((Exception)((Object)e), req2, resp, false);
                        return null;
                    }
                    catch (IOException ioe) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)ioe, new Object[]{ioe.getMessage()});
                    }
                    catch (ServletException se) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)se, new Object[]{se.getMessage()});
                    }
                }
                catch (IOException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (OAuthException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (URISyntaxException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }

            private void handleException(Exception e, HttpServletRequest request, HttpServletResponse response, boolean sendBody) throws IOException, ServletException {
                StringBuilder realm = new StringBuilder(32).append(request.isSecure() ? "https://" : "http://");
                realm.append(request.getLocalName());
                OAuthServlet.handleException((HttpServletResponse)response, (Exception)e, (String)realm.toString(), (boolean)sendBody);
            }
        });
    }

    private boolean loginOperation(HttpServletRequest req, HttpServletResponse resp, LoginClosure login) throws IOException, OXException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        LoginResult result = null;
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            properties.put("http.request", req);
            String capabilities = req.getParameter("capabilities");
            if (null != capabilities) {
                properties.put("client.capabilities", capabilities);
            }
            if (null == (result = login.doLogin(req))) {
                return true;
            }
            Login.addHeadersAndCookies(result, resp);
            ResultCode code = result.getCode();
            if (null != code) {
                switch (code) {
                    case FAILED: {
                        return true;
                    }
                    case REDIRECT: {
                        throw LoginExceptionCodes.REDIRECT.create(new Object[]{result.getRedirect()});
                    }
                }
            }
            Session session = result.getSession();
            session.setParameter("user-agent", (Object)req.getHeader("user-agent"));
            JSONObject json = new JSONObject();
            LoginWriter.write(result, json);
            Login.appendModules(session, json, req);
            response.setData(json);
        }
        catch (OXException e) {
            if ("SVL".equals(e.getPrefix())) {
                throw e;
            }
            if (LoginExceptionCodes.NOT_SUPPORTED.equals(e)) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
            }
            if (LoginExceptionCodes.REDIRECT.equals(e)) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        try {
            if (response.hasError() || null == result) {
                ResponseWriter.write(response, resp.getWriter());
                return false;
            }
            Session session = result.getSession();
            SessionServlet.rememberSession(req, new ServerSessionAdapter(session, result.getContext(), result.getUser()));
            this.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
            if (req.getParameter("callback") != null && req.getParameter("action").equals("login")) {
                APIResponseRenderer.writeResponse(response, "login", req, resp);
            } else {
                ((JSONObject)response.getData()).write((Writer)resp.getWriter());
            }
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error((Object)"Error while writing response object.", (Throwable)e);
            Login.sendError(resp);
            return false;
        }
        return false;
    }

    private static void addHeadersAndCookies(LoginResult result, HttpServletResponse resp) {
        Header[] headers;
        Cookie[] cookies = result.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                resp.addCookie(Login.wrapCookie(cookie));
            }
        }
        if (null != (headers = result.getHeaders())) {
            for (Header header : headers) {
                resp.addHeader(header.getName(), header.getValue());
            }
        }
    }

    private static javax.servlet.http.Cookie wrapCookie(Cookie cookie) {
        return new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
    }

    protected LoginRequest parseLogin(HttpServletRequest req, String loginParamName, boolean strict) throws OXException {
        String prop;
        String tmp = req.getParameter(loginParamName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(loginParamName);
        }
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        String string = prop = null == service ? null : service.getProperty("com.openexchange.login.disableTrimLogin");
        if (null == prop || !Boolean.parseBoolean(prop.toString())) {
            tmp = tmp.trim();
        }
        String login = tmp;
        String password = req.getParameter("password");
        if (null == password) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
        return this.parseLogin(req, login, password, strict);
    }

    protected LoginRequest parseLogin(final HttpServletRequest req, final String login, final String password, boolean strict) throws OXException {
        String version2;
        final String authId = Login.parseAuthId(req, strict);
        final String client = this.parseClient(req, strict);
        if (null == req.getParameter("version")) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("version");
            }
            version2 = null;
        } else {
            version2 = req.getParameter("version");
        }
        final String clientIP = Login.parseClientIP(req);
        final String userAgent = Login.parseUserAgent(req);
        final boolean isVolatile = Login.parseVolatile(req, false);
        final Map<String, List<String>> headers = Tools.copyHeaders(req);
        final Cookie[] cookies = Tools.getCookieFromHeader(req);
        LoginRequest loginRequest = new LoginRequest(){
            private final String hash;
            {
                this.hash = HashCalculator.getHash(req, userAgent, client);
            }

            @Override
            public boolean isVolatile() {
                return isVolatile;
            }

            @Override
            public String getLogin() {
                return login;
            }

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public String getClientIP() {
                return clientIP;
            }

            @Override
            public String getUserAgent() {
                return userAgent;
            }

            @Override
            public String getAuthId() {
                return authId;
            }

            @Override
            public String getClient() {
                return client;
            }

            @Override
            public String getVersion() {
                return version2;
            }

            @Override
            public Interface getInterface() {
                return Interface.HTTP_JSON;
            }

            @Override
            public String getHash() {
                return this.hash;
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return headers;
            }

            @Override
            public Cookie[] getCookies() {
                return cookies;
            }
        };
        return loginRequest;
    }

    protected LoginRequest parseAutoLoginRequest(final HttpServletRequest req) throws OXException {
        final String authId = Login.parseAuthId(req, false);
        final String client = this.parseClient(req, false);
        final String clientIP = Login.parseClientIP(req);
        final String userAgent = Login.parseUserAgent(req);
        final boolean isVolatile = Login.parseVolatile(req, false);
        final Map<String, List<String>> headers = Tools.copyHeaders(req);
        final Cookie[] cookies = Tools.getCookieFromHeader(req);
        return new LoginRequest(){
            private final String hash;
            {
                this.hash = HashCalculator.getHash(req, client);
            }

            @Override
            public boolean isVolatile() {
                return isVolatile;
            }

            @Override
            public String getVersion() {
                return null;
            }

            @Override
            public String getUserAgent() {
                return userAgent;
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public String getLogin() {
                return null;
            }

            @Override
            public Interface getInterface() {
                return Interface.HTTP_JSON;
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return headers;
            }

            @Override
            public String getHash() {
                return this.hash;
            }

            @Override
            public String getClientIP() {
                return clientIP;
            }

            @Override
            public String getClient() {
                return client;
            }

            @Override
            public String getAuthId() {
                return authId;
            }

            @Override
            public Cookie[] getCookies() {
                return cookies;
            }
        };
    }

    private static boolean parseVolatile(HttpServletRequest req, boolean fallback) {
        String parameter = req.getParameter("volatile");
        if (Login.isEmpty(parameter)) {
            return fallback;
        }
        return Boolean.parseBoolean(parameter.trim());
    }

    private static String parseUserAgent(HttpServletRequest req) {
        String parameter = req.getParameter("clientUserAgent");
        return null == parameter ? req.getHeader("user-agent") : parameter;
    }

    private static String parseClientIP(HttpServletRequest req) {
        String parameter = req.getParameter("clientIP");
        return null == parameter ? req.getRemoteAddr() : parameter;
    }

    private String parseClient(HttpServletRequest req, boolean strict) throws OXException {
        String parameter = req.getParameter("client");
        if (null == parameter) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("client");
            }
            return this.confReference.get().defaultClient;
        }
        return parameter;
    }

    private String parseClient(HttpServletRequest req) {
        try {
            return this.parseClient(req, false);
        }
        catch (OXException e) {
            return this.confReference.get().defaultClient;
        }
    }

    private static String parseAuthId(HttpServletRequest req, boolean strict) throws OXException {
        String authIdParam = req.getParameter("authId");
        if (null == authIdParam) {
            if (strict) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("authId");
            }
            return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        }
        return authIdParam;
    }

    protected static void appendModules(Session session, JSONObject json, HttpServletRequest req) {
        String modules = "modules";
        if (Login.parseBoolean(req.getParameter("modules"))) {
            try {
                Setting setting = ConfigTree.getInstance().getSettingByPath("modules");
                SettingStorage.getInstance(session).readValues(setting);
                json.put("modules", ConfigMenu.convert2JS(setting));
            }
            catch (OXException e) {
                LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
            }
            catch (JSONException e) {
                LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static boolean parseBoolean(String parameter) {
        return "true".equalsIgnoreCase(parameter) || "1".equals(parameter) || "yes".equalsIgnoreCase(parameter) || "on".equalsIgnoreCase(parameter);
    }

    protected void doFormLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, OXException, IOException {
        LoginRequest request = this.parseLogin(req, "login", true);
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        properties.put("http.request", req);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        LoginResult result = LoginPerformer.getInstance().doLogin(request, properties);
        Session session = result.getSession();
        Tools.disableCaching(resp);
        this.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
        resp.sendRedirect(this.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("autologin"), session.getSessionID()));
    }

    private void doAuthHeaderLogin(final HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        String version2;
        Authorization.Credentials creds;
        String auth = req.getHeader("authorization");
        if (!Authorization.checkForAuthorizationHeader(auth)) {
            throw LoginExceptionCodes.UNKNOWN_HTTP_AUTHORIZATION.create();
        }
        LoginConfiguration conf = this.confReference.get();
        if (Authorization.checkForBasicAuthorization(auth)) {
            creds = Authorization.decode(auth);
            version2 = conf.clientVersion;
        } else if (Authorization.checkForKerberosAuthorization(auth)) {
            creds = new Authorization.Credentials("kerberos", "");
            version2 = "Kerberos";
        } else {
            throw LoginExceptionCodes.UNKNOWN_HTTP_AUTHORIZATION.create(new Object[]{""});
        }
        final String client = this.parseClient(req);
        final String clientIP = Login.parseClientIP(req);
        final String userAgent = Login.parseUserAgent(req);
        final boolean isVolatile = Login.parseVolatile(req, false);
        final Map<String, List<String>> headers = Tools.copyHeaders(req);
        final Cookie[] cookies = Tools.getCookieFromHeader(req);
        LoginRequest request = new LoginRequest(){
            private final String hash;
            {
                this.hash = HashCalculator.getHash(req, userAgent, client);
            }

            @Override
            public boolean isVolatile() {
                return isVolatile;
            }

            @Override
            public String getVersion() {
                return version2;
            }

            @Override
            public String getUserAgent() {
                return userAgent;
            }

            @Override
            public String getPassword() {
                return creds.getPassword();
            }

            @Override
            public String getLogin() {
                return creds.getLogin();
            }

            @Override
            public Interface getInterface() {
                return Interface.HTTP_JSON;
            }

            @Override
            public String getHash() {
                return this.hash;
            }

            @Override
            public String getClientIP() {
                return clientIP;
            }

            @Override
            public String getClient() {
                return client;
            }

            @Override
            public String getAuthId() {
                return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return headers;
            }

            @Override
            public Cookie[] getCookies() {
                return cookies;
            }
        };
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        properties.put("http.request", req);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        LoginResult result = LoginPerformer.getInstance().doLogin(request, properties);
        Session session = result.getSession();
        Tools.disableCaching(resp);
        this.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
        Login.addHeadersAndCookies(result, resp);
        resp.sendRedirect(this.generateRedirectURL(null, conf.httpAuthAutoLogin, session.getSessionID()));
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    protected String generateRedirectURL(String uiWebPathParam, String shouldStore, String sessionId) {
        String retval = uiWebPathParam;
        if (null == retval) {
            retval = this.confReference.get().uiWebPath;
        }
        retval = retval.replaceAll("[\n\r]", "");
        retval = Login.addFragmentParameter(retval, "session", sessionId);
        if (shouldStore != null) {
            retval = Login.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }

    private static enum CookieType {
        SESSION,
        SECRET;

    }

    private static final class LoginConfiguration {
        protected final String uiWebPath;
        protected final boolean sessiondAutoLogin;
        protected final CookieHashSource hashSource;
        protected final String httpAuthAutoLogin;
        protected final String defaultClient;
        protected final String clientVersion;
        protected final String errorPageTemplate;
        protected final int cookieExpiry;
        protected final boolean insecure;
        protected final boolean cookieForceHTTPS;
        protected final boolean ipCheck;
        protected final ClientWhitelist ipCheckWhitelist;
        volatile boolean redirectIPChangeAllowed;
        protected final Queue<IPRange> ranges;

        protected LoginConfiguration(String uiWebPath, boolean sessiondAutoLogin, CookieHashSource hashSource, String httpAuthAutoLogin, String defaultClient, String clientVersion, String errorPageTemplate, int cookieExpiry, boolean cookieForceHTTPS, boolean insecure, boolean ipCheck, ClientWhitelist ipCheckWhitelist, boolean redirectIPChangeAllowed, Queue<IPRange> ranges) {
            this.uiWebPath = uiWebPath;
            this.sessiondAutoLogin = sessiondAutoLogin;
            this.hashSource = hashSource;
            this.httpAuthAutoLogin = httpAuthAutoLogin;
            this.defaultClient = defaultClient;
            this.clientVersion = clientVersion;
            this.errorPageTemplate = errorPageTemplate;
            this.cookieExpiry = cookieExpiry;
            this.cookieForceHTTPS = cookieForceHTTPS;
            this.insecure = insecure;
            this.ipCheck = ipCheck;
            this.ipCheckWhitelist = ipCheckWhitelist;
            this.redirectIPChangeAllowed = redirectIPChangeAllowed;
            this.ranges = ranges;
        }

        protected LoginConfiguration() {
            this.uiWebPath = null;
            this.sessiondAutoLogin = false;
            this.hashSource = null;
            this.httpAuthAutoLogin = null;
            this.defaultClient = null;
            this.clientVersion = null;
            this.errorPageTemplate = null;
            this.cookieExpiry = -1;
            this.cookieForceHTTPS = false;
            this.insecure = false;
            this.ipCheck = false;
            this.ipCheckWhitelist = null;
            this.redirectIPChangeAllowed = true;
            this.ranges = null;
        }
    }

    private static interface JSONRequestHandler {
        public void handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }

    private static interface LoginClosure {
        public LoginResult doLogin(HttpServletRequest var1) throws OXException;
    }
}

