/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.messaging.BinaryContent;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

public class MimeBinaryContent
implements BinaryContent {
    protected final Part part;
    protected final byte[] cachedContent;

    public MimeBinaryContent(InputStream inputStream) throws OXException {
        this.part = null;
        try {
            int read;
            UnsynchronizedByteArrayOutputStream buffer = new UnsynchronizedByteArrayOutputStream(16384);
            byte[] buf = new byte[8192];
            while ((read = inputStream.read(buf, 0, buf.length)) != -1) {
                buffer.write(buf, 0, read);
            }
            this.cachedContent = buffer.toByteArray();
        }
        catch (IOException e) {
            throw MessagingExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MimeBinaryContent.class)).error((Object)"Couldn't close stream.", (Throwable)e);
            }
        }
    }

    public MimeBinaryContent(byte[] content) {
        this.part = null;
        this.cachedContent = new byte[content.length];
        System.arraycopy(content, 0, this.cachedContent, 0, content.length);
    }

    protected MimeBinaryContent(Part part) {
        this.part = part;
        this.cachedContent = null;
    }

    public InputStream getData() throws OXException {
        return this.getBodyPartInputStream();
    }

    private InputStream getBodyPartInputStream() throws OXException {
        if (this.cachedContent != null) {
            return new UnsynchronizedByteArrayInputStream(this.cachedContent);
        }
        if (null == this.part) {
            throw MessagingExceptionCodes.UNEXPECTED_ERROR.create(new Object[]{"No content"});
        }
        try {
            return this.part.getInputStream();
        }
        catch (IOException e) {
            try {
                if (this.part instanceof MimeBodyPart) {
                    return ((MimeBodyPart)this.part).getRawInputStream();
                }
                throw e;
            }
            catch (MessagingException me) {
                me.setNextException((Exception)e);
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (IOException ioe) {
                throw MessagingExceptionCodes.IO_ERROR.create((Throwable)ioe, new Object[]{ioe.getMessage()});
            }
        }
        catch (MessagingException e) {
            try {
                if (this.part instanceof MimeMessage) {
                    return ((MimeMessage)this.part).getRawInputStream();
                }
                throw e;
            }
            catch (MessagingException me) {
                me.setNextException((Exception)((Object)e));
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }
}

