/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic;

import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.messaging.generic.internal.TimeZoneUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.mail.internet.MailDateFormat;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class Utility {
    private static final ConcurrentMap<String, Future<MailDateFormat>> MDF_MAP = new ConcurrentHashMap<String, Future<MailDateFormat>>();
    private static final MailDateFormat DEFAULT_MAIL_DATE_FORMAT = new MailDateFormat();

    private Utility() {
    }

    public static TimeZone getTimeZone(String id) {
        return TimeZoneUtils.getTimeZone(id);
    }

    public static long addTimeZoneOffset(long date, String timeZone) {
        return date + (long)TimeZoneUtils.getTimeZone(timeZone).getOffset(date);
    }

    public static long addTimeZoneOffset(long date, TimeZone timeZone) {
        return date + (long)timeZone.getOffset(date);
    }

    public static SimpleDateFormat getDefaultMailDateFormat() {
        return DEFAULT_MAIL_DATE_FORMAT;
    }

    public static SimpleDateFormat getMailDateFormat(final String timeZoneId) {
        FutureTask<MailDateFormat> ft;
        FutureTask<MailDateFormat> future = (FutureTask<MailDateFormat>)MDF_MAP.get(timeZoneId);
        if (null == future && null == (future = (Future)MDF_MAP.putIfAbsent(timeZoneId, ft = new FutureTask<MailDateFormat>(new Callable<MailDateFormat>(){

            @Override
            public MailDateFormat call() throws Exception {
                MailDateFormat mdf = new MailDateFormat();
                mdf.setTimeZone(TimeZoneUtils.getTimeZone(timeZoneId));
                return mdf;
            }
        })))) {
            future = ft;
            ft.run();
        }
        try {
            return (SimpleDateFormat)future.get();
        }
        catch (InterruptedException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Utility.class)).error((Object)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Utility.class)).error((Object)cause.getMessage(), cause);
            return DEFAULT_MAIL_DATE_FORMAT;
        }
    }

    public static String decodeEnvelopeSubject(String subject) {
        return MimeMessageUtility.decodeEnvelopeSubject((String)subject);
    }

    public static String decodeEnvelopeHeader(String headerValue) {
        return MimeMessageUtility.decodeEnvelopeHeader((String)headerValue);
    }

    public static String decodeMultiEncodedHeader(String headerValue) {
        return MimeMessageUtility.decodeMultiEncodedHeader((String)headerValue);
    }

    public static String fold(int used, String foldMe) {
        return MimeMessageUtility.fold((int)used, (String)foldMe);
    }

    public static String unfold(String headerLine) {
        return MimeMessageUtility.unfold((String)headerLine);
    }

    public static String htmlFormat(String plainText) {
        return HtmlProcessing.htmlFormat((String)plainText);
    }

    public static String htmlFormat(String plainText, boolean withQuote) {
        return HtmlProcessing.htmlFormat((String)plainText, (boolean)withQuote);
    }

    public static String textFormat(String htmlContent) {
        if (htmlContent == null || htmlContent.length() == 0) {
            return "";
        }
        return HtmlProcessing.html2text((String)htmlContent, (boolean)true);
    }

    public static String formatHrefLinks(String content) {
        return HtmlProcessing.formatHrefLinks((String)content);
    }

    public static String getConformHTML(String htmlContent, String charset) {
        return HtmlProcessing.getConformHTML((String)htmlContent, (String)charset);
    }

    public static Document createDOMDocument(String string) {
        return HtmlProcessing.createDOMDocument((String)string);
    }

    public static String prettyPrintXML(String string) {
        return HtmlProcessing.prettyPrintXML((String)string);
    }

    public static String prettyPrintXML(Node node) {
        return HtmlProcessing.prettyPrintXML((Node)node);
    }

    public static String getContentType(File file) {
        return Utility.getContentType(file.getName());
    }

    public static String getContentType(String fileName) {
        return MimeType2ExtMap.getContentType((String)fileName);
    }

    public static String getContentTypeByExtension(String extension) {
        return MimeType2ExtMap.getContentTypeByExtension((String)extension);
    }

    public static List<String> getFileExtensions(String mimeType) {
        return MimeType2ExtMap.getFileExtensions((String)mimeType);
    }

    static {
        DEFAULT_MAIL_DATE_FORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
    }
}

