/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;

public enum DBPoolingExceptionCodes {
    NO_CONFIG_DB("Cannot get connection to config DB.", Category.CATEGORY_SERVICE_DOWN, 1),
    RESOLVE_FAILED("Database for context %1$d and server %2$d can not be resolved", Category.CATEGORY_ERROR, 2),
    NO_CONNECTION("No connection to database %1$d", Category.CATEGORY_SERVICE_DOWN, 3),
    SCHEMA_FAILED("Schema can not be set on database connection", Category.CATEGORY_CONNECTIVITY, 4),
    NULL_CONNECTION("Null is returned to connection pool.", Category.CATEGORY_ERROR, 5),
    SQL_ERROR("Problem with executing SQL: %1$s", Category.CATEGORY_ERROR, 6),
    NO_DBPOOL("Cannot get information for pool %d.", Category.CATEGORY_ERROR, 7),
    NO_DRIVER("Driver class %1$s missing.", Category.CATEGORY_CONFIGURATION, 8),
    RETURN_FAILED("Object %1$s does not belong to this pool. The object will be removed. If there was a previous message about this object not having been returned to the pool, the object was just in use too long.", Category.CATEGORY_ERROR, 9),
    NO_SERVER_NAME("Server name is not defined.", Category.CATEGORY_CONFIGURATION, 10),
    NOT_INITIALIZED("%1$s is not initialized.", Category.CATEGORY_ERROR, 11),
    TOO_LONG("Connection used for %1$d milliseconds.", Category.CATEGORY_WARNING, 12),
    ACTIVE_STATEMENTS("%1$d statements are not closed.", Category.CATEGORY_ERROR, 13),
    NO_AUTOCOMMIT("Connection not reset to auto commit.", Category.CATEGORY_ERROR, 14),
    PARAMETER_PROBLEM("Parsing problem in URL parameter \"%1$s\".", Category.CATEGORY_CONFIGURATION, 15),
    MISSING_CONFIGURATION("Configuration file for database configuration is missing.", Category.CATEGORY_CONFIGURATION, 16),
    PROPERTY_MISSING("Property \"%1$s\" is not defined.", Category.CATEGORY_CONFIGURATION, 17),
    ALREADY_INITIALIZED("%1$s is already initialized.", Category.CATEGORY_ERROR, 18),
    NOT_RESOLVED_SERVER("Cannot resolve server id for server %1$s.", Category.CATEGORY_CONFIGURATION, 19),
    UNKNOWN_POOL("Nothing known about pool %1$d.", Category.CATEGORY_ERROR, 20),
    TRANSACTION_MISSING("Transaction counter is missing for context %1$d.", Category.CATEGORY_CONFIGURATION, 21),
    INSERT_FAILED("Inserting database assignment for context %1$d and server %2$d failed!", Category.CATEGORY_ERROR, 22);

    private final String message;
    private final Category category;
    private final int detailNumber;
    public static final String PREFIX = "DBP";

    private DBPoolingExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public int getDetailNumber() {
        return this.detailNumber;
    }

    public OXException create() {
        return this.create(new Object[0]);
    }

    public OXException create(Object ... logArguments) {
        return this.create(null, logArguments);
    }

    public OXException create(Throwable cause, Object ... logArguments) {
        return new OXException(this.detailNumber, "A severe error occurred.", cause, new Object[0]).setPrefix(PREFIX).addCategory(this.category).setLogMessage(this.message, logArguments);
    }
}

