/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database;

import com.openexchange.database.CreateTableService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCreateTableImpl
implements CreateTableService {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf(LogFactory.getLog(AbstractCreateTableImpl.class));
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE +TABLE +`?(\\w+)`? +\\(");
    private static final String TABLE = "TABLE";
    protected static final String[] NO_TABLES = new String[0];

    protected AbstractCreateTableImpl() {
    }

    @Override
    public final void perform(Connection con) throws OXException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            for (String create : this.getCreateStatements()) {
                String tableName = AbstractCreateTableImpl.extractTableName(create);
                if (null != tableName && AbstractCreateTableImpl.tableExists(con, tableName)) {
                    LOG.info((Object)("A table with name \"" + tableName + "\" already exists. Aborting table creation."));
                    continue;
                }
                stmt.execute(create);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw DBPoolingExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            Databases.closeSQLStuff(stmt);
        }
    }

    private static String extractTableName(String create) {
        Matcher m = PATTERN_CREATE_TABLE.matcher(create);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{TABLE});
            retval = rs.next() && rs.getString("TABLE_NAME").equalsIgnoreCase(table);
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs);
            throw throwable;
        }
        Databases.closeSQLStuff(rs);
        return retval;
    }

    protected abstract String[] getCreateStatements();
}

