/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.mysql.jdbc.AssertionFailedException;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.folder.FolderToolkit;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserToolkit;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.GetTask;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.TasksDowngrade;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.groupware.userconfiguration.AllowAllUserConfiguration;
import com.openexchange.groupware.userconfiguration.AllowAllUserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.util.Date;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class DowngradeTest
extends TestCase {
    private Context ctx;
    private User user;
    private User secondUser;
    private Session session;

    public DowngradeTest(String name) {
        super(name);
    }

    private static String getUsername(String un) {
        int pos = un.indexOf(64);
        return pos == -1 ? un : un.substring(0, pos);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        AJAXConfig.init();
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.user = UserToolkit.getUser(DowngradeTest.getUsername(userName), this.ctx);
        String secondUserName = AJAXConfig.getProperty(AJAXConfig.Property.SECONDUSER);
        this.secondUser = UserToolkit.getUser(DowngradeTest.getUsername(secondUserName), this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.user.getId(), (Context)this.ctx, (String)"DowngradeTest");
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemovePrivateParticipants() throws Throwable {
        int folderId = FolderToolkit.getStandardTaskFolder(this.user.getId(), this.ctx);
        Task task = Create.createWithDefaults(folderId, "DowngradeTest");
        task.setParticipants(new Participant[]{new UserParticipant(this.user.getId()), new UserParticipant(this.secondUser.getId())});
        TasksSQLImpl taskSQL = new TasksSQLImpl(this.session);
        taskSQL.insertTaskObject(task);
        try {
            this.downgradeDelegate();
            this.assertNoParticipants(folderId, task.getObjectID());
        }
        finally {
            TaskLogic.deleteTask((Session)this.session, (Context)this.ctx, (int)this.user.getId(), (Task)task, (Date)task.getLastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemovePublicParticipants() throws Throwable {
        FolderObject folder = this.createPublicFolder();
        int folderId = folder.getObjectID();
        Task task = Create.createWithDefaults(folderId, "DowngradeTest");
        task.setParticipants(new Participant[]{new UserParticipant(this.user.getId()), new UserParticipant(this.secondUser.getId())});
        TasksSQLImpl taskSQL = new TasksSQLImpl(this.session);
        taskSQL.insertTaskObject(task);
        try {
            this.downgradeDelegate();
            this.assertParticipants(folderId, task.getObjectID());
            this.updatePublicFolder(folder);
            this.downgradeDelegate();
            this.assertNoParticipants(folderId, task.getObjectID());
        }
        finally {
            TaskLogic.deleteTask((Session)this.session, (Context)this.ctx, (int)this.user.getId(), (Task)task, (Date)task.getLastModified());
            this.deletePublicFolder(folder);
        }
    }

    public void testRemovePrivateTasks() throws OXException, OXException, OXException {
        int folderId = FolderToolkit.getStandardTaskFolder(this.user.getId(), this.ctx);
        Task task = Create.createWithDefaults(folderId, "DowngradeTest");
        TasksSQLImpl taskSQL = new TasksSQLImpl(this.session);
        taskSQL.insertTaskObject(task);
        this.downgradeNoTasks();
        this.assertNoTask(task.getObjectID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemovePublicTask() throws OXException, OXException, OXException {
        FolderObject folder = this.createPublicFolder();
        int folderId = folder.getObjectID();
        Task task = Create.createWithDefaults(folderId, "DowngradeTest");
        task.setParticipants(new Participant[]{new UserParticipant(this.user.getId()), new UserParticipant(this.secondUser.getId())});
        TasksSQLImpl taskSQL = new TasksSQLImpl(this.session);
        taskSQL.insertTaskObject(task);
        try {
            this.downgradeNoTasks();
            this.assertParticipants(folderId, task.getObjectID());
            this.updatePublicFolder(folder);
            this.downgradeNoTasks();
            this.assertNoTask(task.getObjectID());
        }
        finally {
            this.deletePublicFolder(folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downgradeDelegate() throws OXException, OXException {
        AllowAllUserConfiguration userConfig = new AllowAllUserConfiguration(this.user.getId(), this.user.getGroups(), this.ctx){
            private static final long serialVersionUID = -6133954203762209965L;

            public UserPermissionBits getUserPermissionBits() {
                return new AllowAllUserPermissionBits(this.userId, this.groups, this.ctx){
                    private static final long serialVersionUID = 8557097436407742416L;

                    public boolean hasPermission(int permissionBit) {
                        return permissionBit != 131072;
                    }
                };
            }
        };
        Connection con = Database.get((Context)this.ctx, (boolean)true);
        try {
            DowngradeEvent event = new DowngradeEvent((UserConfiguration)userConfig, con, this.ctx);
            new TasksDowngrade().downgradePerformed(event);
        }
        finally {
            Database.back((Context)this.ctx, (boolean)true, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downgradeNoTasks() throws OXException, OXException {
        AllowAllUserConfiguration userConfig = new AllowAllUserConfiguration(this.user.getId(), this.user.getGroups(), this.ctx){
            private static final long serialVersionUID = 400233948268970280L;

            public UserPermissionBits getUserPermissionBits() {
                return new AllowAllUserPermissionBits(this.userId, this.groups, this.ctx){
                    private static final long serialVersionUID = -1380938924019873373L;

                    public boolean hasPermission(int permissionBit) {
                        return permissionBit != 131072 && permissionBit != 8;
                    }
                };
            }
        };
        Connection con = Database.get((Context)this.ctx, (boolean)true);
        try {
            DowngradeEvent event = new DowngradeEvent((UserConfiguration)userConfig, con, this.ctx);
            new TasksDowngrade().downgradePerformed(event);
        }
        finally {
            Database.back((Context)this.ctx, (boolean)true, (Connection)con);
        }
    }

    private void assertNoParticipants(int folderId, int objectId) {
        try {
            Task task = GetTask.load((Context)this.ctx, (int)folderId, (int)objectId, (StorageType)StorageType.ACTIVE);
            Participant[] parts = task.getParticipants();
            if (null != parts && parts.length > 0) {
                throw new AssertionFailedError("Task has participants.");
            }
        }
        catch (OXException e) {
            throw new AssertionFailedException((Exception)((Object)e));
        }
    }

    private void assertParticipants(int folderId, int objectId) {
        try {
            Task task = GetTask.load((Context)this.ctx, (int)folderId, (int)objectId, (StorageType)StorageType.ACTIVE);
            Participant[] parts = task.getParticipants();
            if (null == parts || parts.length == 0) {
                throw new AssertionFailedError("Task has no participants.");
            }
        }
        catch (OXException e) {
            throw new AssertionFailedException((Exception)((Object)e));
        }
    }

    private void assertNoTask(int objectId) {
        try {
            TaskStorage stor = TaskStorage.getInstance();
            stor.selectTask(this.ctx, objectId, StorageType.ACTIVE);
            DowngradeTest.fail((String)"Private task has not been removed on downgrade.");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject createPublicFolder() throws OXException, OXException {
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        try {
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)con, (Connection)con);
            OCLPermission oclp1 = new OCLPermission();
            oclp1.setEntity(this.user.getId());
            oclp1.setAllPermission(128, 128, 128, 128);
            oclp1.setFolderAdmin(true);
            OCLPermission oclp2 = new OCLPermission();
            oclp2.setEntity(this.secondUser.getId());
            oclp2.setAllPermission(4, 4, 4, 4);
            oclp2.setFolderAdmin(false);
            FolderObject fo = new FolderObject();
            fo.setFolderName("DowngradeTest");
            fo.setParentFolderID(2);
            fo.setModule(1);
            fo.setType(2);
            fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
            FolderObject folderObject = fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            return folderObject;
        }
        finally {
            DBPool.pushWrite((Context)this.ctx, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePublicFolder(FolderObject folder) throws OXException, OXException {
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        try {
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)con, (Connection)con);
            Iterator iter = folder.getPermissions().iterator();
            while (iter.hasNext()) {
                if (((OCLPermission)iter.next()).getEntity() != this.secondUser.getId()) continue;
                iter.remove();
            }
            oxma.updateFolder(folder, false, false, System.currentTimeMillis());
        }
        finally {
            DBPool.pushWrite((Context)this.ctx, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePublicFolder(FolderObject folder) throws OXException, OXException {
        Connection con = DBPool.pickupWriteable((Context)this.ctx);
        try {
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)con, (Connection)con);
            oxma.deleteFolder(folder, false, System.currentTimeMillis());
        }
        finally {
            DBPool.pushWrite((Context)this.ctx, (Connection)con);
        }
    }
}

